/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.idea.gradleJava.run.KotlinGradleTaskUtilsKt;
import org.jetbrains.plugins.gradle.execution.GradleRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer;", "Lorg/jetbrains/plugins/gradle/execution/GradleRunConfigurationProducer;", "()V", "findTaskNameAllowingEDT", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "", "configuration", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleTaskRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleTaskRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer\n+ 2 permissions.kt\norg/jetbrains/kotlin/analysis/api/permissions/PermissionsKt\n*L\n1#1,63:1\n41#2,8:64\n*S KotlinDebug\n*F\n+ 1 KotlinGradleTaskRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/gradleJava/run/KotlinGradleTaskRunConfigurationProducer\n*L\n59#1:64,8\n*E\n"})
public final class KotlinGradleTaskRunConfigurationProducer
extends GradleRunConfigurationProducer {
    public boolean setupConfigurationFromContext(@NotNull GradleRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        if (!KotlinGradleTaskUtilsKt.isGradleConfiguration(configuration2)) {
            return false;
        }
        Module module2 = context2.getModule();
        if (module2 == null) {
            return false;
        }
        Module module3 = module2;
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        PsiElement psiElement2 = location3.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
        if (!KotlinGradleTaskUtilsKt.isInGradleKotlinScript(psiElement2)) {
            return false;
        }
        String string = GradleRunnerUtil.resolveProjectPath((Module)module3);
        if (string == null) {
            return false;
        }
        String projectPath2 = string;
        PsiElement psiElement3 = location3.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPsiElement(...)");
        String string2 = this.findTaskNameAllowingEDT(psiElement3);
        if (string2 == null) {
            return false;
        }
        String taskToRun = string2;
        configuration2.getSettings().setExternalProjectPath(projectPath2);
        configuration2.getSettings().setTaskNames(CollectionsKt.listOf((Object)taskToRun));
        configuration2.setName(AbstractExternalSystemTaskConfigurationType.generateName((Project)module3.getProject(), (ExternalSystemTaskExecutionSettings)configuration2.getSettings()));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull GradleRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!KotlinGradleTaskUtilsKt.isGradleConfiguration(configuration2)) {
            return false;
        }
        if (context2.getModule() == null) {
            return false;
        }
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        PsiElement psiElement2 = location3.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
        if (!KotlinGradleTaskUtilsKt.isInGradleKotlinScript(psiElement2)) {
            return false;
        }
        String string = GradleRunnerUtil.resolveProjectPath((Module)context2.getModule());
        if (string == null) {
            return false;
        }
        String projectPath2 = string;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = configuration2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"getSettings(...)");
        ExternalSystemTaskExecutionSettings settings2 = externalSystemTaskExecutionSettings;
        if (!StringUtil.equals((CharSequence)projectPath2, (CharSequence)settings2.getExternalProjectPath())) {
            return false;
        }
        List list2 = settings2.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTaskNames(...)");
        String string2 = (String)CollectionsKt.singleOrNull((List)list2);
        if (string2 == null) {
            return false;
        }
        String taskFromSettings = string2;
        PsiElement psiElement3 = location3.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getPsiElement(...)");
        String string3 = this.findTaskNameAllowingEDT(psiElement3);
        if (string3 == null) {
            return false;
        }
        String taskName = string3;
        return Intrinsics.areEqual((Object)taskName, (Object)taskFromSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findTaskNameAllowingEDT(PsiElement psiElement2) {
        String string;
        boolean $i$f$allowAnalysisOnEdt = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv.isAnalysisAllowedOnEdt()) {
            boolean bl = false;
            string = KotlinGradleTaskUtilsKt.findTaskNameAround(psiElement2);
        } else {
            permissionRegistry$iv.setAnalysisAllowedOnEdt(true);
            try {
                boolean bl = false;
                String string2 = KotlinGradleTaskUtilsKt.findTaskNameAround(psiElement2);
                string = string2;
            }
            finally {
                permissionRegistry$iv.setAnalysisAllowedOnEdt(false);
            }
        }
        return string;
    }
}

