/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinEqualsBetweenInconvertibleTypesInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Util", "kotlin.idea"})
public final class KotlinEqualsBetweenInconvertibleTypesInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                KtExpression ktExpression = call2.getCalleeExpression();
                KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression callee = ktSimpleNameExpression;
                Name identifier2 = callee.getReferencedNameAsName();
                if (!Intrinsics.areEqual((Object)identifier2, (Object)OperatorNameConventions.EQUALS)) {
                    return;
                }
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)call2));
                if (ktQualifiedExpression == null || (ktQualifiedExpression = ktQualifiedExpression.getReceiverExpression()) == null) {
                    return;
                }
                KtQualifiedExpression receiver2 = ktQualifiedExpression;
                List list2 = call2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
                if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                    return;
                }
                KtValueArgument argument2 = ktValueArgument;
                if (Util.INSTANCE.isInconvertibleTypes(ResolutionUtils.analyze((KtElement)call2, BodyResolveMode.PARTIAL), (KtExpression)receiver2, (KtExpression)argument2)) {
                    this.$holder.registerProblem((PsiElement)callee, KotlinBundle.message((String)"equals.between.objects.of.inconvertible.types", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\u00020\t*\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinEqualsBetweenInconvertibleTypesInspection$Util;", "", "()V", "getTargetType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isInconvertibleTypes", "", "expr1", "expr2", "kotlin.idea"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        public final boolean isInconvertibleTypes(@NotNull BindingContext $this$isInconvertibleTypes, @Nullable KtExpression expr1, @Nullable KtExpression expr2) {
            Intrinsics.checkNotNullParameter((Object)$this$isInconvertibleTypes, (String)"<this>");
            KtExpression ktExpression = expr1;
            if (ktExpression == null || (ktExpression = this.getTargetType(ktExpression, $this$isInconvertibleTypes)) == null) {
                return false;
            }
            KtExpression type1 = ktExpression;
            KtExpression ktExpression2 = expr2;
            if (ktExpression2 == null || (ktExpression2 = this.getTargetType(ktExpression2, $this$isInconvertibleTypes)) == null) {
                return false;
            }
            KtExpression type2 = ktExpression2;
            return !Intrinsics.areEqual((Object)type1, (Object)type2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final KotlinType getTargetType(KtExpression $this$getTargetType, BindingContext context2) {
            KotlinType kotlinType;
            KotlinType kotlinType2 = context2.getType($this$getTargetType);
            if (kotlinType2 == null) return null;
            KotlinType it = kotlinType = kotlinType2;
            boolean bl = false;
            if (!KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)it) && !KotlinBuiltIns.isStringOrNullableString((KotlinType)it)) {
                if (!TypeUtilsKt.isEnum((KotlinType)it)) return null;
            }
            boolean bl2 = true;
            if (!bl2) return null;
            KotlinType kotlinType3 = kotlinType;
            KotlinType kotlinType4 = kotlinType3;
            if (kotlinType4 == null) return null;
            KotlinType kotlinType5 = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType4);
            return kotlinType5;
        }
    }
}

