/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.NullChecksToSafeCallInspectionKt;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "isApplicable", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nNullChecksToSafeCallInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullChecksToSafeCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,93:1\n26#2,7:94\n*S KotlinDebug\n*F\n+ 1 NullChecksToSafeCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/NullChecksToSafeCallInspection\n*L\n33#1:94,7\n*E\n"})
public final class NullChecksToSafeCallInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public NullChecksToSafeCallInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message((String)"null.checks.replaceable.with.safe.calls", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"null.checks.to.safe.call.check.fix.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return NullChecksToSafeCallInspectionKt.access$isNullChecksToSafeCallFixAvailable(element3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        PsiElement result$iv;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Triple triple = NullChecksToSafeCallInspectionKt.access$collectNullCheckExpressions(element3);
        if (triple == null) {
            return;
        }
        Triple triple2 = triple;
        KtExpression lte = (KtExpression)triple2.component1();
        KtQualifiedExpression rte = (KtQualifiedExpression)triple2.component2();
        boolean isAnd = (Boolean)triple2.component3();
        PsiElement parent2 = element3.getParent();
        PsiElement psiElement2 = (PsiElement)element3;
        Project project3 = lte.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        PsiElement newElement$iv = (PsiElement)CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project3, false, 2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(lte, rte, isAnd){
            final /* synthetic */ KtExpression $lte;
            final /* synthetic */ KtQualifiedExpression $rte;
            final /* synthetic */ boolean $isAnd;
            {
                this.$lte = $lte;
                this.$rte = $rte;
                this.$isAnd = $isAnd;
                super(1);
            }

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$this$buildExpression");
                $this$buildExpression.appendExpression(this.$lte);
                $this$buildExpression.appendFixedText("?.");
                $this$buildExpression.appendExpression(this.$rte.getSelectorExpression());
                $this$buildExpression.appendFixedText(this.$isAnd ? "!= null" : "== null");
            }
        }), (int)1, null);
        boolean $i$f$replaced = false;
        if (!Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv) && !((result$iv = $this$replaced$iv.replace(newElement$iv)) instanceof KtExpression)) {
            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            PsiElement cfr_ignored_0 = (PsiElement)ktExpression;
        }
        if (parent2 instanceof KtBinaryExpression && NullChecksToSafeCallInspectionKt.access$isNullChecksToSafeCallFixAvailable((KtBinaryExpression)parent2)) {
            this.applyTo((KtBinaryExpression)parent2, project2, editor2);
        }
    }
}

