/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/VariableDeclarationIntoWhenFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "actionName", "", "subjectExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "transform", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function1;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "getName", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMoveVariableDeclarationIntoWhenInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveVariableDeclarationIntoWhenInspection.kt\norg/jetbrains/kotlin/idea/inspections/VariableDeclarationIntoWhenFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,168:1\n936#2,15:169\n1855#2,2:186\n179#3,2:184\n*S KotlinDebug\n*F\n+ 1 MoveVariableDeclarationIntoWhenInspection.kt\norg/jetbrains/kotlin/idea/inspections/VariableDeclarationIntoWhenFix\n*L\n144#1:169,15\n148#1:186,2\n146#1:184,2\n*E\n"})
final class VariableDeclarationIntoWhenFix
implements LocalQuickFix {
    @NotNull
    private final String actionName;
    @NotNull
    private final SmartPsiElementPointer<KtExpression> subjectExpressionPointer;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Function1<KtProperty, KtExpression> transform;

    public VariableDeclarationIntoWhenFix(@Nls @NotNull String actionName, @NotNull SmartPsiElementPointer<KtExpression> subjectExpressionPointer, @NotNull Function1<? super KtProperty, ? extends KtExpression> transform2) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(subjectExpressionPointer, (String)"subjectExpressionPointer");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        this.actionName = actionName;
        this.subjectExpressionPointer = subjectExpressionPointer;
        this.transform = transform2;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        PsiElement psiElement2 = PsiTreeUtil.findSameElementInCopy((PsiElement)this.subjectExpressionPointer.getElement(), (PsiFile)target2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"findSameElementInCopy(...)");
        return (FileModifier)new VariableDeclarationIntoWhenFix(this.actionName, (SmartPsiElementPointer<KtExpression>)SmartPointersKt.createSmartPointer((PsiElement)psiElement2), this.transform);
    }

    @NotNull
    public String getName() {
        return this.actionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        KDoc docComment;
        List tailComments2;
        KtExpression toReplace;
        KtProperty newElement2;
        KtExpression subjectExpression;
        KtProperty property2;
        block16: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
            if (ktProperty == null) {
                return;
            }
            property2 = ktProperty;
            KtExpression ktExpression = (KtExpression)this.subjectExpressionPointer.getElement();
            if (ktExpression == null) {
                return;
            }
            subjectExpression = ktExpression;
            PsiElement psiElement3 = property2.copy();
            KtProperty ktProperty2 = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
            if (ktProperty2 == null) {
                return;
            }
            newElement2 = ktProperty2;
            KtExpression ktExpression2 = (KtExpression)this.transform.invoke((Object)newElement2);
            if (ktExpression2 == null) {
                return;
            }
            toReplace = ktExpression2;
            List $this$takeLastWhile$iv = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)newElement2))));
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                v4 = CollectionsKt.emptyList();
            } else {
                ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PsiElement it = (PsiElement)iterator$iv.previous();
                    boolean bl = false;
                    if (it instanceof PsiWhiteSpace || it instanceof PsiComment) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        v4 = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u245$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u245$iv.add(iterator$iv.next());
                        }
                        v4 = arrayList;
                    }
                    break block16;
                }
                v4 = tailComments2 = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
            }
        }
        if (!((Collection)tailComments2).isEmpty()) {
            Object v5;
            block17: {
                Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings$default((PsiElement)((PsiElement)subjectExpression), (boolean)false, (boolean)false, (int)1, null);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.LBRACE)) continue;
                    v5 = element$iv;
                    break block17;
                }
                v5 = null;
            }
            PsiElement leftBrace = v5;
            if (leftBrace != null) {
                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)tailComments2);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    subjectExpression.getParent().addAfter(it, leftBrace);
                    it.delete();
                }
            }
        }
        if ((docComment = newElement2.getDocComment()) != null) {
            PsiElement whenExpression2 = subjectExpression.getParent();
            whenExpression2.getParent().addBefore((PsiElement)docComment, whenExpression2);
            docComment.delete();
        }
        PsiElement resultElement = subjectExpression.replace((PsiElement)toReplace);
        PsiElement psiElement4 = property2.getNextSibling();
        PsiWhiteSpace psiWhiteSpace = psiElement4 instanceof PsiWhiteSpace ? (PsiWhiteSpace)psiElement4 : null;
        property2.getParent().deleteChildRange((PsiElement)property2, psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)property2);
        Intrinsics.checkNotNull((Object)resultElement);
        Editor editor2 = EditorUtilsKt.findExistingEditor(resultElement);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        KtProperty ktProperty = resultElement instanceof KtProperty ? (KtProperty)resultElement : null;
        GenerateUtilsKt.moveCaret$default(editor3, ktProperty != null && (ktProperty = ktProperty.getNameIdentifier()) != null ? PsiUtilsKt.getStartOffset((PsiElement)ktProperty) : PsiUtilsKt.getStartOffset((PsiElement)resultElement), null, 2, null);
    }
}

