/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.ConvertTestFunctionToSpacedIntention;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertCamelCaseTestFunctionToSpacedIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertTestFunctionToSpacedIntention;", "()V", "isApplicableName", "", "name", "", "split", "", "Case", "kotlin.idea"})
public final class ConvertCamelCaseTestFunctionToSpacedIntention
extends ConvertTestFunctionToSpacedIntention {
    public ConvertCamelCaseTestFunctionToSpacedIntention() {
        super("camel-case", null);
    }

    @Override
    public boolean isApplicableName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return !this.isSnakeCase(name2);
    }

    @Override
    @NotNull
    public List<String> split(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (name2 == "") {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        Case previousCase = Case.OTHER;
        int from = 0;
        int n = name2.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = name2.charAt(i2);
            Case currentCase = Character.isUpperCase(c) ? Case.UPPER : (Character.isLowerCase(c) ? Case.LOWER : Case.OTHER);
            if (i2 == StringsKt.getLastIndex((CharSequence)name2)) {
                Collection collection = (Collection)result2;
                String string = name2.substring(from);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
            } else if (i2 > 0 && currentCase != previousCase && currentCase != Case.LOWER) {
                Collection collection = (Collection)result2;
                String string = name2.substring(from, i2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection.add(string);
                from = i2;
            }
            previousCase = currentCase;
        }
        return (List)result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertCamelCaseTestFunctionToSpacedIntention$Case;", "", "(Ljava/lang/String;I)V", "LOWER", "UPPER", "OTHER", "kotlin.idea"})
    public static final class Case
    extends Enum<Case> {
        public static final /* enum */ Case LOWER = new Case();
        public static final /* enum */ Case UPPER = new Case();
        public static final /* enum */ Case OTHER = new Case();
        private static final /* synthetic */ Case[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Case[] values() {
            return (Case[])$VALUES.clone();
        }

        public static Case valueOf(String value2) {
            return Enum.valueOf(Case.class, value2);
        }

        @NotNull
        public static EnumEntries<Case> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = caseArray = new Case[]{Case.LOWER, Case.UPPER, Case.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

