/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaReferenceShortener;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenStrategy;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.SymbolUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ImportAllMembersIntentionKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports", "starImportsToAdd", "", "Lorg/jetbrains/kotlin/name/FqName;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "Context", "kotlin.code-insight.intentions.k2"})
public final class ImportAllMembersIntention
extends KotlinApplicableModCommandAction<KtExpression, Context>
implements HighPriorityAction {
    public ImportAllMembersIntention() {
        super(Reflection.getOrCreateKotlinClass(KtExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"import.members.with", (Object[])new Object[0]);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Context context3 = (Context)this.getElementContext(context2, (KtElement)element3);
        if (context3 == null) {
            return null;
        }
        FqName fqName2 = context3.component1();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)fqName2.asString(), (String)"asString(...)");
        return Presentation.of((String)KotlinBundle.message((String)"import.members.from.0", (Object[])objectArray));
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return ImportAllMembersIntentionKt.access$isOnTheLeftOfQualificationDot(element3) && !KtPsiUtilKt.isInImportDirective((KtExpression)element3);
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $context_receiver_0, @NotNull KtExpression element3) {
        KtReference actualReference;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtReference ktReference = actualReference = ImportAllMembersIntentionKt.access$getActualReference(element3);
        KaSymbol kaSymbol = ktReference != null ? $context_receiver_0.resolveToSymbol(ktReference) : null;
        KaNamedClassSymbol kaNamedClassSymbol = kaSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaSymbol : null;
        if (kaNamedClassSymbol == null) {
            return null;
        }
        KaNamedClassSymbol target2 = kaNamedClassSymbol;
        ClassId classId = target2.getClassId();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        if (!SymbolUtilsKt.isJavaSourceOrLibrary(target2.getOrigin()) && (target2.getClassKind() == KaClassKind.OBJECT || ImportAllMembersIntentionKt.access$isReferenceToObjectMemberOrUnresolved($context_receiver_0, element3))) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)element3);
        boolean bl = ktQualifiedExpression != null ? ImportAllMembersIntentionKt.access$isEnumSyntheticMethodCall(ktQualifiedExpression, target2) : false;
        if (bl) {
            return null;
        }
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        if (ImportAllMembersIntentionKt.access$hasImportedEnumSyntheticMethodCall(ktFile2, $context_receiver_0)) {
            return null;
        }
        KaReferenceShortener kaReferenceShortener = $context_receiver_0;
        KtFile ktFile3 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
        ShortenCommand shortenCommand2 = KaReferenceShortener.collectPossibleReferenceShortenings$default(kaReferenceShortener, ktFile3, null, null, (Function1)new Function1<KaClassLikeSymbol, ShortenStrategy>(classId2){
            final /* synthetic */ ClassId $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final ShortenStrategy invoke(@NotNull KaClassLikeSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClassId classId = it.getClassId();
                return (classId != null ? ImportAllMembersIntentionKt.access$isNestedClassIn(classId, this.$classId) : false) ? ShortenStrategy.SHORTEN_AND_STAR_IMPORT : ShortenStrategy.DO_NOT_SHORTEN;
            }
        }, (Function1)new Function1<KaCallableSymbol, ShortenStrategy>(target2, classId2){
            final /* synthetic */ KaNamedClassSymbol $target;
            final /* synthetic */ ClassId $classId;
            {
                this.$target = $target;
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final ShortenStrategy invoke(@NotNull KaCallableSymbol it) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ImportAllMembersIntentionKt.access$isEnumSyntheticMethodCall(it, this.$target)) {
                    return ShortenStrategy.DO_NOT_SHORTEN;
                }
                if (it instanceof KaConstructorSymbol) {
                    ClassId classId = ((KaConstructorSymbol)it).getContainingClassId();
                    object = classId != null ? classId.getOuterClassId() : null;
                } else {
                    CallableId callableId = it.getCallableId();
                    object = callableId != null ? callableId.getClassId() : null;
                }
                ClassId containingClassId = object;
                return Intrinsics.areEqual((Object)containingClassId, (Object)this.$classId) ? ShortenStrategy.SHORTEN_AND_STAR_IMPORT : ShortenStrategy.DO_NOT_SHORTEN;
            }
        }, 6, null);
        if (shortenCommand2.isEmpty()) {
            return null;
        }
        return new Context(classId2.asSingleFqName(), shortenCommand2);
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtExpression element3, @NotNull Context elementContext2, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext2, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        ShortenCommand shortenCommand2 = elementContext2.getShortenCommand();
        KtFile ktFile2 = (KtFile)shortenCommand2.getTargetFile().getElement();
        if (ktFile2 == null) {
            return;
        }
        KtFile file2 = ktFile2;
        this.removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports(shortenCommand2.getStarImportsToAdd(), file2);
        ShortenUtilsKt.invokeShortening(shortenCommand2);
    }

    private final void removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports(Set<FqName> starImportsToAdd, KtFile ktFile2) {
        for (FqName starImportFqName : starImportsToAdd) {
            for (KtImportDirective existingImportFromFile : ktFile2.getImportDirectives()) {
                ImportPath importPath;
                if (existingImportFromFile.getAlias() != null || !Intrinsics.areEqual((Object)((importPath = existingImportFromFile.getImportPath()) != null && (importPath = importPath.getFqName()) != null ? importPath.parent() : null), (Object)starImportFqName)) continue;
                existingImportFromFile.delete();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "shortenCommand", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getShortenCommand", "()Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.code-insight.intentions.k2"})
    public static final class Context {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final ShortenCommand shortenCommand;

        public Context(@NotNull FqName fqName2, @NotNull ShortenCommand shortenCommand2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)shortenCommand2, (String)"shortenCommand");
            this.fqName = fqName2;
            this.shortenCommand = shortenCommand2;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final ShortenCommand getShortenCommand() {
            return this.shortenCommand;
        }

        @NotNull
        public final FqName component1() {
            return this.fqName;
        }

        @NotNull
        public final ShortenCommand component2() {
            return this.shortenCommand;
        }

        @NotNull
        public final Context copy(@NotNull FqName fqName2, @NotNull ShortenCommand shortenCommand2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)shortenCommand2, (String)"shortenCommand");
            return new Context(fqName2, shortenCommand2);
        }

        public static /* synthetic */ Context copy$default(Context context2, FqName fqName2, ShortenCommand shortenCommand2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = context2.fqName;
            }
            if ((n & 2) != 0) {
                shortenCommand2 = context2.shortenCommand;
            }
            return context2.copy(fqName2, shortenCommand2);
        }

        @NotNull
        public String toString() {
            return "Context(fqName=" + this.fqName + ", shortenCommand=" + this.shortenCommand + ")";
        }

        public int hashCode() {
            int result2 = this.fqName.hashCode();
            result2 = result2 * 31 + this.shortenCommand.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other2;
            if (!Intrinsics.areEqual((Object)this.fqName, (Object)context2.fqName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.shortenCommand, (Object)context2.shortenCommand);
        }
    }
}

