/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eJ\b\u0010\n\u001a\u00020\u000bH'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0001\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTarget", "Lcom/intellij/psi/PsiFileSystemItem;", "Companion", "File", "SourceDirectory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "kotlin.refactorings.move.k2"})
public interface K2MoveTargetDescriptor {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor$Companion.$$INSTANCE;

    @NotNull
    public PsiDirectory getBaseDirectory();

    @NotNull
    public FqName getPkgName();

    @RequiresWriteLock
    @NotNull
    public PsiFileSystemItem getOrCreateTarget();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Companion;", "", "()V", "File", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.refactorings.move.k2"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final File File(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            PsiDirectory psiDirectory = file2.getContainingDirectory();
            if (psiDirectory == null) {
                throw new IllegalStateException("No containing directory was found".toString());
            }
            PsiDirectory directory = psiDirectory;
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new File(string, file2.getPackageFqName(), directory);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "fileName", "", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getFileName", "()Ljava/lang/String;", "getOrCreateTarget", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.refactorings.move.k2"})
    public static final class File
    extends SourceDirectory {
        @NotNull
        private final String fileName;

        public File(@NotNull String fileName, @NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            super(pkgName, baseDirectory);
            this.fileName = fileName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public KtFile getOrCreateTarget() {
            PsiFileSystemItem psiFileSystemItem = super.getOrCreateTarget();
            Intrinsics.checkNotNull((Object)psiFileSystemItem, (String)"null cannot be cast to non-null type com.intellij.psi.PsiDirectory");
            PsiDirectory directory = (PsiDirectory)psiFileSystemItem;
            return MoveUtilKt.getOrCreateKotlinFile(this.fileName, directory, this.getPkgName().asString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$SourceDirectory;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTarget", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlin.refactorings.move.k2"})
    public static class SourceDirectory
    implements K2MoveTargetDescriptor {
        @NotNull
        private final FqName pkgName;
        @NotNull
        private final PsiDirectory baseDirectory;

        public SourceDirectory(@NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            this.pkgName = pkgName;
            this.baseDirectory = baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        @NotNull
        public PsiFileSystemItem getOrCreateTarget() {
            PsiFileSystemItem psiFileSystemItem;
            FqName basePkg = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(this.getBaseDirectory());
            if (!Intrinsics.areEqual((Object)basePkg, (Object)this.getPkgName())) {
                String string = this.getPkgName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String string2 = basePkg.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String pkgDiff = StringsKt.replace$default((String)StringsKt.removePrefix((String)string, (CharSequence)string2), (String)".", (String)"/", (boolean)false, (int)4, null);
                VirtualFile virtualFile2 = VfsUtil.createDirectoryIfMissing((VirtualFile)this.getBaseDirectory().getVirtualFile(), (String)pkgDiff);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createDirectoryIfMissing(...)");
                Project project2 = this.getBaseDirectory().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile2, project2);
                if (psiDirectory == null) {
                    throw new IllegalStateException("Could not create directory structure".toString());
                }
                psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
            } else {
                psiFileSystemItem = (PsiFileSystemItem)this.getBaseDirectory();
            }
            return psiFileSystemItem;
        }
    }
}

