/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "jvmName", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddJvmNameAnnotationFix
extends KotlinQuickFixAction<KtElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jvmName;

    public AddJvmNameAnnotationFix(@NotNull KtElement element3, @NotNull String jvmName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        super((PsiElement)element3);
        this.jvmName = jvmName;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.getElement() instanceof KtAnnotationEntry) {
            string = KotlinBundle.message((String)"fix.change.jvm.name", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)JvmFileClassUtil.INSTANCE.getJVM_NAME().shortName(), (String)"shortName(...)");
            string = KotlinBundle.message((String)"fix.add.annotation.text.self", (Object[])objectArray);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement element3 = ktElement;
        KtElement ktElement2 = element3;
        if (ktElement2 instanceof KtAnnotationEntry) {
            KtValueArgumentList argList = ((KtAnnotationEntry)element3).getValueArgumentList();
            KtValueArgumentList newArgList = new KtPsiFactory(project2, false, 2, null).createCallArguments("(\"" + this.jvmName + "\")");
            if (argList != null) {
                argList.replace((PsiElement)newArgList);
            } else {
                element3.addAfter((PsiElement)newArgList, ((KtAnnotationEntry)element3).getLastChild());
            }
        } else if (ktElement2 instanceof KtFunction) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)element3, JvmFileClassUtil.INSTANCE.getJVM_NAME(), "\"" + this.jvmName + "\"", null, null, 12, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "typeElements", "", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddJvmNameAnnotationFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddJvmNameAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1855#2,2:78\n1855#2,2:80\n*S KotlinDebug\n*F\n+ 1 AddJvmNameAnnotationFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddJvmNameAnnotationFix$Companion\n*L\n72#1:78,2\n69#1:80,2\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            String string = function2.getName();
            if (string == null) {
                return null;
            }
            String functionName = string;
            PsiElement psiElement3 = function2.getParent();
            if (psiElement3 == null) {
                return null;
            }
            PsiElement containingDeclaration2 = psiElement3;
            Fe10KotlinNewDeclarationNameValidator nameValidator2 = new Fe10KotlinNewDeclarationNameValidator(containingDeclaration2, (PsiElement)function2, KotlinNameSuggestionProvider.ValidatorTarget.FUNCTION, null, 8, null);
            Object object = function2.getReceiverTypeReference();
            if (object == null || (object = this.typeElements((KtTypeReference)object)) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"", null, null, (int)0, null, (Function1)createAction.receiverTypeElements.1.INSTANCE, (int)30, null)) == null) {
                object = "";
            }
            Object receiverTypeElements2 = object;
            String jvmName = KotlinNameSuggester.Companion.suggestNameByName(functionName + (String)receiverTypeElements2, (Function1<? super String, Boolean>)((Function1)nameValidator2));
            KtAnnotationEntry ktAnnotationEntry = ModifierListModifactorKt.findAnnotation((KtAnnotated)function2, JvmFileClassUtil.INSTANCE.getJVM_NAME());
            return new AddJvmNameAnnotationFix((KtElement)(ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)function2), jvmName);
        }

        private final List<KtTypeElement> typeElements(KtTypeReference $this$typeElements) {
            List typeElements;
            block1: {
                typeElements = new ArrayList();
                Object object = $this$typeElements.getTypeElement();
                if (object == null || (object = object.getTypeArgumentsAsTypes()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix$Companion.typeElements$collect(typeElements, it);
                }
            }
            return typeElements;
        }

        private static final void typeElements$collect(List<KtTypeElement> typeElements, KtTypeReference typeReference2) {
            KtTypeReference ktTypeReference = typeReference2;
            if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTypeElement()) == null) {
                return;
            }
            KtTypeReference typeElement2 = ktTypeReference;
            List list2 = typeElement2.getTypeArgumentsAsTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArgumentsAsTypes(...)");
            List typeArguments2 = list2;
            if (typeArguments2.isEmpty()) {
                typeElements.add((KtTypeElement)typeElement2);
            } else {
                Iterable $this$forEach$iv = typeArguments2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    org.jetbrains.kotlin.idea.quickfix.AddJvmNameAnnotationFix$Companion.typeElements$collect(typeElements, it);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

