/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinPsiOnlyQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinPsiOnlyQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "binaryOperatorName", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;ZLjava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.fir.frontend-independent"})
public final class ReplaceInfixOrOperatorCallFix
extends KotlinPsiOnlyQuickFixAction<KtExpression> {
    private final boolean notNullNeeded;
    @NotNull
    private final String binaryOperatorName;

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element3, boolean notNullNeeded, @NotNull String binaryOperatorName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)binaryOperatorName, (String)"binaryOperatorName");
        super((PsiElement)element3);
        this.notNullNeeded = notNullNeeded;
        this.binaryOperatorName = binaryOperatorName;
    }

    public /* synthetic */ ReplaceInfixOrOperatorCallFix(KtExpression ktExpression, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        this(ktExpression, bl, string);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"replace.with.safe.call", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block19: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            String elvis2 = ReplaceCallFixKt.elvisOrEmpty(element3, this.notNullNeeded);
            PsiElement replacement2 = null;
            KtExpression ktExpression2 = element3;
            if (ktExpression2 instanceof KtArrayAccessExpression) {
                KtBinaryExpression assignment2;
                KtBinaryExpression ktBinaryExpression = assignment2 = KtPsiUtilKt.getAssignmentByLHS((KtExpression)element3);
                KtExpression right = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
                KtExpression ktExpression3 = ((KtArrayAccessExpression)element3).getArrayExpression();
                if (ktExpression3 == null) {
                    return;
                }
                KtExpression arrayExpression = ktExpression3;
                if (assignment2 != null) {
                    if (right == null) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = arrayExpression;
                    List list2 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIndexExpressions(...)");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.1.INSTANCE, (int)30, null);
                    objectArray[2] = right;
                    KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0?.set($1, $2)", (Object[])objectArray, (boolean)false, (int)4, null);
                    assignment2.replace((PsiElement)newExpression2);
                } else {
                    String string = "$0?.get($1)" + elvis2;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = arrayExpression;
                    List list3 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getIndexExpressions(...)");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.2.INSTANCE, (int)30, null);
                    KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
                    replacement2 = ((KtArrayAccessExpression)element3).replace((PsiElement)newExpression3);
                }
            } else if (ktExpression2 instanceof KtCallExpression) {
                KtExpression ktExpression4 = ((KtCallExpression)element3).getCalleeExpression();
                if (ktExpression4 == null) {
                    return;
                }
                KtExpression calleeExpression2 = ktExpression4;
                KtValueArgumentList ktValueArgumentList = ((KtCallExpression)element3).getValueArgumentList();
                String string = ktValueArgumentList != null ? ktValueArgumentList.getText() : null;
                if (string == null) {
                    return;
                }
                String valueArgumentList2 = string;
                PsiElement newExpression3 = ((KtCallExpression)element3).getParent();
                KtQualifiedExpression parentQualified = newExpression3 instanceof KtQualifiedExpression ? (KtQualifiedExpression)newExpression3 : null;
                newExpression3 = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(parentQualified, calleeExpression2, valueArgumentList2, elvis2){
                    final /* synthetic */ KtQualifiedExpression $parentQualified;
                    final /* synthetic */ KtExpression $calleeExpression;
                    final /* synthetic */ String $valueArgumentList;
                    final /* synthetic */ String $elvis;
                    {
                        this.$parentQualified = $parentQualified;
                        this.$calleeExpression = $calleeExpression;
                        this.$valueArgumentList = $valueArgumentList;
                        this.$elvis = $elvis;
                        super(1);
                    }

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                        Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$this$buildExpression");
                        if (this.$parentQualified != null) {
                            KtExpression receiver2 = this.$parentQualified.getReceiverExpression();
                            ASTNode operationNode = this.$parentQualified.getOperationTokenNode();
                            ASTNode aSTNode = receiver2.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                            String beforeOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), (Function1)invoke.newExpression.beforeOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.beforeOperationNode.2.INSTANCE, (int)30, null);
                            String afterOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)operationNode, (boolean)true), (Function1)invoke.newExpression.afterOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.afterOperationNode.2.INSTANCE, (int)30, null);
                            $this$buildExpression.appendExpression(receiver2);
                            $this$buildExpression.appendFixedText(beforeOperationNode2);
                            String string = KtTokens.SAFE_ACCESS.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                            $this$buildExpression.appendFixedText(string);
                            $this$buildExpression.appendFixedText(afterOperationNode2);
                        }
                        $this$buildExpression.appendExpression(this.$calleeExpression);
                        String string = KtTokens.SAFE_ACCESS.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        $this$buildExpression.appendFixedText(string);
                        $this$buildExpression.appendFixedText("invoke");
                        $this$buildExpression.appendFixedText(this.$valueArgumentList);
                        $this$buildExpression.appendFixedText(this.$elvis);
                    }
                }), (int)1, null);
                KtQualifiedExpression ktQualifiedExpression = parentQualified;
                replacement2 = (ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : element3).replace(newExpression3);
            } else if (ktExpression2 instanceof KtBinaryExpression) {
                KtExpression ktExpression5;
                KtExpression ktExpression6 = ((KtBinaryExpression)element3).getLeft();
                if (ktExpression6 == null) {
                    return;
                }
                KtExpression left = ktExpression6;
                KtExpression ktExpression7 = ((KtBinaryExpression)element3).getRight();
                if (ktExpression7 == null) {
                    return;
                }
                KtExpression right = ktExpression7;
                boolean isNormalAssignment = KtTokens.AUGMENTED_ASSIGNMENTS.contains(((KtBinaryExpression)element3).getOperationToken()) && !((ImmutableSet)OperatorConventions.ASSIGNMENT_OPERATIONS.values()).contains((Object)Name.identifier((String)this.binaryOperatorName));
                boolean isContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)KtTokens.IN_KEYWORD);
                boolean isNotContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)KtTokens.NOT_IN);
                if (isContainsOperator || isNotContainsOperator) {
                    String booleanSuffix = isNotContainsOperator ? " != true" : " == true";
                    Object[] objectArray = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression5 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$2?.$1($0)" + booleanSuffix), (Object[])objectArray, (boolean)false, (int)4, null);
                } else if (isNormalAssignment) {
                    var15_25 = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression5 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $0?.$1($2)", (Object[])var15_25, (boolean)false, (int)4, null);
                } else {
                    var15_25 = new Object[]{left, this.binaryOperatorName, right};
                    ktExpression5 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0?.$1($2)" + elvis2), (Object[])var15_25, (boolean)false, (int)4, null);
                }
                KtExpression newExpression4 = ktExpression5;
                replacement2 = ((KtBinaryExpression)element3).replace((PsiElement)newExpression4);
            }
            if (!(((CharSequence)elvis2).length() > 0)) break block19;
            PsiElement psiElement2 = replacement2;
            if (psiElement2 != null) {
                ReplaceCallFixKt.moveCaretToEnd(psiElement2, editor2, project2);
            }
        }
    }
}

