/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.refactoring.copy.AbstractCopyKotlinDeclarationsHandlerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0004\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\"\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J%\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0004\u00a2\u0006\u0002\u0010!R\u001b\u0010\u0003\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler;", "Lcom/intellij/refactoring/copy/CopyHandlerDelegateBase;", "()V", "copyFilesHandler", "Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "getCopyFilesHandler", "()Lcom/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler;", "copyFilesHandler$delegate", "Lkotlin/Lazy;", "canCopy", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "fromUpdate", "([Lcom/intellij/psi/PsiElement;Z)Z", "canCopyDeclarations", "([Lcom/intellij/psi/PsiElement;)Z", "canCopyFiles", "createFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetFileName", "", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "getFilePolicy", "Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler$ExistingFilePolicy;", "existingFile", "Lcom/intellij/psi/PsiFile;", "getOrCreateTargetFile", "originalFile", "getSourceFiles", "Lcom/intellij/psi/PsiFileSystemItem;", "([Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiFileSystemItem;", "ExistingFilePolicy", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractCopyKotlinDeclarationsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,140:1\n11065#2:141\n11400#2,3:142\n12474#2,2:147\n9972#2:149\n10394#2,2:150\n10396#2,3:153\n37#3,2:145\n1#4:152\n1655#5,8:156\n73#6:164\n73#6:165\n*S KotlinDebug\n*F\n+ 1 AbstractCopyKotlinDeclarationsHandler.kt\norg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler\n*L\n44#1:141\n44#1:142,3\n50#1:147,2\n57#1:149\n57#1:150,2\n57#1:153,3\n45#1:145,2\n58#1:156,8\n112#1:164\n123#1:165\n*E\n"})
public abstract class AbstractCopyKotlinDeclarationsHandler
extends CopyHandlerDelegateBase {
    @NotNull
    private final Lazy copyFilesHandler$delegate = LazyKt.lazy((Function0)copyFilesHandler.2.INSTANCE);

    @NotNull
    protected final CopyFilesOrDirectoriesHandler getCopyFilesHandler() {
        Lazy lazy = this.copyFilesHandler$delegate;
        return (CopyFilesOrDirectoriesHandler)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiFileSystemItem[] getSourceFiles(@NotNull PsiElement[] elements2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement[] $this$map$iv = elements2;
        boolean $i$f$map = false;
        PsiElement[] psiElementArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            PsiFileSystemItem psiFileSystemItem;
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile2 = it.getContainingFile();
            if (psiFile2 != null) {
                psiFileSystemItem = (PsiFileSystemItem)psiFile2;
            } else {
                psiFileSystemItem = it instanceof PsiFileSystemItem ? (PsiFileSystemItem)it : null;
                if (psiFileSystemItem == null) {
                    return null;
                }
            }
            collection.add(psiFileSystemItem);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFileSystemItem[0]);
    }

    private final boolean canCopyFiles(PsiElement[] elements2, boolean fromUpdate) {
        boolean bl;
        PsiFileSystemItem[] sourceFiles2;
        block3: {
            PsiFileSystemItem[] psiFileSystemItemArray = this.getSourceFiles(elements2);
            if (psiFileSystemItemArray == null) {
                return false;
            }
            PsiFileSystemItem[] $this$any$iv = sourceFiles2 = psiFileSystemItemArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                PsiFileSystemItem element$iv;
                PsiFileSystemItem it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(it instanceof KtFile)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        return this.getCopyFilesHandler().canCopy((PsiElement[])sourceFiles2, fromUpdate);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean canCopyDeclarations(@NotNull PsiElement[] elements2) {
        PsiFile psiFile2;
        void $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement[] psiElementArray = elements2;
        boolean $i$f$flatMap = false;
        void var7_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            Collection collection = AbstractCopyKotlinDeclarationsHandlerKt.access$getDeclarationsToCopy((PsiElement)it);
            if (collection.isEmpty()) {
                boolean bl2 = false;
                return false;
            }
            Iterable list$iv$iv = (List)collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiFile> set$iv = new HashSet<PsiFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtElement it = (KtElement)e$iv;
            boolean bl = false;
            PsiFile key$iv = it.getContainingFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        KtElement ktElement = (KtElement)CollectionsKt.singleOrNull((List)list$iv);
        PsiFile psiFile3 = psiFile2 = ktElement != null ? ktElement.getContainingFile() : null;
        if (psiFile2 == null) {
            return false;
        }
        PsiFile containingFile = psiFile2;
        return ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)containingFile) != null;
    }

    public boolean canCopy(@NotNull PsiElement[] elements2, boolean fromUpdate) {
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        return this.canCopyDeclarations(elements2) || this.canCopyFiles(elements2, fromUpdate);
    }

    @Nullable
    protected final KtFile getOrCreateTargetFile(@NotNull KtFile originalFile2, @NotNull PsiDirectory targetDirectory2, @NotNull String targetFileName) {
        Intrinsics.checkNotNullParameter((Object)originalFile2, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)targetDirectory2, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        PsiFile existingFile = targetDirectory2.findFile(targetFileName);
        if (Intrinsics.areEqual((Object)existingFile, (Object)originalFile2)) {
            return null;
        }
        if (existingFile != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getFilePolicy(existingFile, targetFileName, targetDirectory2).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(existingFile){
                        final /* synthetic */ PsiFile $existingFile;
                        {
                            this.$existingFile = $existingFile;
                            super(0);
                        }

                        public final void invoke() {
                            this.$existingFile.delete();
                        }
                    }));
                    break;
                }
                case 3: {
                    return null;
                }
            }
        }
        return (KtFile)ActionsKt.runWriteAction((Function0)((Function0)new Function0<KtFile>(existingFile, this, targetFileName, targetDirectory2){
            final /* synthetic */ PsiFile $existingFile;
            final /* synthetic */ AbstractCopyKotlinDeclarationsHandler this$0;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $targetDirectory;
            {
                this.$existingFile = $existingFile;
                this.this$0 = $receiver;
                this.$targetFileName = $targetFileName;
                this.$targetDirectory = $targetDirectory;
                super(0);
            }

            @NotNull
            public final KtFile invoke() {
                KtFile ktFile2;
                if (this.$existingFile != null && this.$existingFile.isValid()) {
                    PsiFile psiFile2 = this.$existingFile;
                    Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    ktFile2 = (KtFile)psiFile2;
                } else {
                    ktFile2 = this.this$0.createFile(this.$targetFileName, this.$targetDirectory);
                }
                return ktFile2;
            }
        }));
    }

    @NotNull
    public abstract KtFile createFile(@NotNull String var1, @NotNull PsiDirectory var2);

    private final ExistingFilePolicy getFilePolicy(PsiFile existingFile, String targetFileName, PsiDirectory targetDirectory2) {
        ExistingFilePolicy existingFilePolicy;
        Object[] objectArray = new Object[2];
        objectArray[0] = targetFileName;
        Intrinsics.checkNotNullExpressionValue((Object)targetDirectory2.getVirtualFile().getPath(), (String)"getPath(...)");
        String message2 = KotlinBundle.message((String)"text.file.0.already.exists.in.1", (Object[])objectArray);
        if (!(existingFile instanceof KtFile)) {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.OVERWRITE;
            }
            int answer = Messages.showOkCancelDialog((String)message2, (String)AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), (String)KotlinBundle.message((String)"action.text.overwrite", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            existingFilePolicy = answer == 0 ? ExistingFilePolicy.OVERWRITE : ExistingFilePolicy.SKIP;
        } else {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return ExistingFilePolicy.APPEND;
            }
            int answer = Messages.showYesNoCancelDialog((String)message2, (String)AbstractCopyKotlinDeclarationsHandlerKt.getCopyCommandName(), (String)KotlinBundle.message((String)"action.text.append", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.overwrite", (Object[])new Object[0]), (String)KotlinBundle.message((String)"action.text.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (answer) {
                case 0: {
                    existingFilePolicy = ExistingFilePolicy.APPEND;
                    break;
                }
                case 1: {
                    existingFilePolicy = ExistingFilePolicy.OVERWRITE;
                    break;
                }
                default: {
                    existingFilePolicy = ExistingFilePolicy.SKIP;
                }
            }
        }
        return existingFilePolicy;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/AbstractCopyKotlinDeclarationsHandler$ExistingFilePolicy;", "", "(Ljava/lang/String;I)V", "APPEND", "OVERWRITE", "SKIP", "kotlin.refactorings.common"})
    public static final class ExistingFilePolicy
    extends Enum<ExistingFilePolicy> {
        public static final /* enum */ ExistingFilePolicy APPEND = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy OVERWRITE = new ExistingFilePolicy();
        public static final /* enum */ ExistingFilePolicy SKIP = new ExistingFilePolicy();
        private static final /* synthetic */ ExistingFilePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExistingFilePolicy[] values() {
            return (ExistingFilePolicy[])$VALUES.clone();
        }

        public static ExistingFilePolicy valueOf(String value2) {
            return Enum.valueOf(ExistingFilePolicy.class, value2);
        }

        @NotNull
        public static EnumEntries<ExistingFilePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = existingFilePolicyArray = new ExistingFilePolicy[]{ExistingFilePolicy.APPEND, ExistingFilePolicy.OVERWRITE, ExistingFilePolicy.SKIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExistingFilePolicy.values().length];
            try {
                nArray[ExistingFilePolicy.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.OVERWRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExistingFilePolicy.SKIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

