/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.OutputValue;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.OutputValueBoxer;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\"#B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H$J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H$J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010!\u001a\u00020\u0019H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer;", "KotlinType", "", "outputValues", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "(Ljava/util/List;)V", "boxingRequired", "", "getBoxingRequired", "()Z", "getOutputValues", "()Ljava/util/List;", "returnType", "getReturnType", "()Ljava/lang/Object;", "extractArgumentExpressionByIndex", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boxedExpression", "index", "", "extractExpressionByIndex", "extractExpressionByValue", "value", "getBoxingExpressionPattern", "", "arguments", "getReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getUnboxingExpressions", "", "boxedText", "AsList", "AsTuple", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nOutputValueBoxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputValueBoxer.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,109:1\n37#2,2:110\n*S KotlinDebug\n*F\n+ 1 OutputValueBoxer.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer\n*L\n23#1:110,2\n*E\n"})
public abstract class OutputValueBoxer<KotlinType> {
    @NotNull
    private final List<OutputValue<KotlinType>> outputValues;

    public OutputValueBoxer(@NotNull List<? extends OutputValue<KotlinType>> outputValues) {
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        this.outputValues = outputValues;
    }

    @NotNull
    public final List<OutputValue<KotlinType>> getOutputValues() {
        return this.outputValues;
    }

    public abstract KotlinType getReturnType();

    @Nullable
    protected abstract String getBoxingExpressionPattern(@NotNull List<? extends KtExpression> var1);

    public abstract boolean getBoxingRequired();

    @Nullable
    public final KtReturnExpression getReturnExpression(@NotNull List<? extends KtExpression> arguments2, @NotNull KtPsiFactory psiFactory) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        String string = this.getBoxingExpressionPattern(arguments2);
        if (string == null) {
            return null;
        }
        String expressionPattern = string;
        Collection $this$toTypedArray$iv = arguments2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KtExpression[] ktExpressionArray = thisCollection$iv.toArray(new KtExpression[0]);
        KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("return " + expressionPattern), (Object[])Arrays.copyOf(ktExpressionArray, ktExpressionArray.length), (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReturnExpression");
        return (KtReturnExpression)ktExpression;
    }

    @Nullable
    protected abstract KtExpression extractExpressionByIndex(@NotNull KtExpression var1, int var2);

    @Nullable
    protected final KtExpression extractArgumentExpressionByIndex(@NotNull KtExpression boxedExpression, int index) {
        List arguments2;
        KtCallExpression call2;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)boxedExpression, (String)"boxedExpression");
        KtExpression ktExpression2 = boxedExpression;
        Object object = ktExpression2 instanceof KtCallExpression ? (KtCallExpression)boxedExpression : (ktExpression2 instanceof KtQualifiedExpression ? ((ktExpression = ((KtQualifiedExpression)boxedExpression).getSelectorExpression()) instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) : null);
        KtCallExpression ktCallExpression = call2 = object;
        List list2 = arguments2 = ktCallExpression != null ? ktCallExpression.getValueArguments() : null;
        if (arguments2 == null || arguments2.size() <= index) {
            return null;
        }
        return ((KtValueArgument)arguments2.get(index)).getArgumentExpression();
    }

    @Nullable
    public final KtExpression extractExpressionByValue(@NotNull KtExpression boxedExpression, @NotNull OutputValue<KotlinType> value2) {
        Intrinsics.checkNotNullParameter((Object)boxedExpression, (String)"boxedExpression");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        int index = this.outputValues.indexOf(value2);
        if (index < 0) {
            return null;
        }
        return this.extractExpressionByIndex(boxedExpression, index);
    }

    @NotNull
    public abstract Map<OutputValue<KotlinType>, String> getUnboxingExpressions(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0014J\"\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer$AsList;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer;", "outputValues", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "(Ljava/util/List;)V", "boxingRequired", "", "getBoxingRequired", "()Z", "extractExpressionByIndex", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boxedExpression", "index", "", "getBoxingExpressionPattern", "", "arguments", "getUnboxingExpressions", "", "boxedText", "kotlin.refactorings.common"})
    public static abstract class AsList<KotlinType>
    extends OutputValueBoxer<KotlinType> {
        private final boolean boxingRequired;

        public AsList(@NotNull List<? extends OutputValue<KotlinType>> outputValues) {
            Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
            super(outputValues);
            this.boxingRequired = !((Collection)outputValues).isEmpty();
        }

        @Override
        public boolean getBoxingRequired() {
            return this.boxingRequired;
        }

        @Override
        @Nullable
        protected String getBoxingExpressionPattern(@NotNull List<? extends KtExpression> arguments2) {
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            if (arguments2.isEmpty()) {
                return null;
            }
            return CollectionsKt.joinToString$default((Iterable)((Iterable)CollectionsKt.getIndices((Collection)arguments2)), (CharSequence)", ", (CharSequence)"kotlin.collections.listOf(", (CharSequence)")", (int)0, null, (Function1)getBoxingExpressionPattern.1.INSTANCE, (int)24, null);
        }

        @Override
        @Nullable
        protected KtExpression extractExpressionByIndex(@NotNull KtExpression boxedExpression, int index) {
            Intrinsics.checkNotNullParameter((Object)boxedExpression, (String)"boxedExpression");
            return this.extractArgumentExpressionByIndex(boxedExpression, index);
        }

        @Override
        @NotNull
        public Map<OutputValue<KotlinType>, String> getUnboxingExpressions(@NotNull String boxedText) {
            Intrinsics.checkNotNullParameter((Object)boxedText, (String)"boxedText");
            Ref.IntRef i2 = new Ref.IntRef();
            Map map2 = ContainerUtil.newMapFromKeys(this.getOutputValues().iterator(), arg_0 -> AsList.getUnboxingExpressions$lambda$0((Function1)new Function1<OutputValue<KotlinType>, String>(boxedText, i2){
                final /* synthetic */ String $boxedText;
                final /* synthetic */ Ref.IntRef $i;
                {
                    this.$boxedText = $boxedText;
                    this.$i = $i;
                    super(1);
                }

                public final String invoke(OutputValue<KotlinType> it) {
                    int n = this.$i.element;
                    this.$i.element = n + 1;
                    return this.$boxedText + "[" + n + "]";
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"newMapFromKeys(...)");
            return map2;
        }

        private static final String getUnboxingExpressions$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b&\u0018\u0000 \u0016*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0014J\"\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer$AsTuple;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer;", "outputValues", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "(Ljava/util/List;)V", "boxingRequired", "", "getBoxingRequired", "()Z", "extractExpressionByIndex", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boxedExpression", "index", "", "getBoxingExpressionPattern", "", "arguments", "getUnboxingExpressions", "", "boxedText", "Companion", "kotlin.refactorings.common"})
    @SourceDebugExtension(value={"SMAP\nOutputValueBoxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputValueBoxer.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer$AsTuple\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
    public static abstract class AsTuple<KotlinType>
    extends OutputValueBoxer<KotlinType> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean boxingRequired;
        @NotNull
        private static final String[] selectors;

        public AsTuple(@NotNull List<? extends OutputValue<KotlinType>> outputValues) {
            boolean bl;
            Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
            super(outputValues);
            boolean bl2 = bl = outputValues.size() <= 3;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "At most 3 output values are supported";
                throw new AssertionError((Object)string);
            }
            this.boxingRequired = outputValues.size() > 1;
        }

        @Override
        public boolean getBoxingRequired() {
            return this.boxingRequired;
        }

        @Override
        @Nullable
        protected String getBoxingExpressionPattern(@NotNull List<? extends KtExpression> arguments2) {
            String string;
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            switch (arguments2.size()) {
                case 0: {
                    string = null;
                    break;
                }
                case 1: {
                    string = "$0";
                    break;
                }
                default: {
                    String constructorName = arguments2.size() == 2 ? "kotlin.Pair" : "kotlin.Triple";
                    IntRange intRange = CollectionsKt.getIndices((Collection)arguments2);
                    String string2 = constructorName + "(";
                    return CollectionsKt.joinToString$default((Iterable)((Iterable)intRange), (CharSequence)", ", (CharSequence)string2, (CharSequence)")", (int)0, null, (Function1)getBoxingExpressionPattern.1.INSTANCE, (int)24, null);
                }
            }
            return string;
        }

        @Override
        @Nullable
        protected KtExpression extractExpressionByIndex(@NotNull KtExpression boxedExpression, int index) {
            Intrinsics.checkNotNullParameter((Object)boxedExpression, (String)"boxedExpression");
            if (this.getOutputValues().size() == 1) {
                return boxedExpression;
            }
            return this.extractArgumentExpressionByIndex(boxedExpression, index);
        }

        @Override
        @NotNull
        public Map<OutputValue<KotlinType>, String> getUnboxingExpressions(@NotNull String boxedText) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)boxedText, (String)"boxedText");
            switch (this.getOutputValues().size()) {
                case 0: {
                    Map<OutputValue<KotlinType>, String> map3 = Collections.emptyMap();
                    map2 = map3;
                    Intrinsics.checkNotNullExpressionValue(map3, (String)"emptyMap(...)");
                    break;
                }
                case 1: {
                    Map<Object, String> map4 = Collections.singletonMap(CollectionsKt.first(this.getOutputValues()), boxedText);
                    map2 = map4;
                    Intrinsics.checkNotNullExpressionValue(map4, (String)"singletonMap(...)");
                    break;
                }
                default: {
                    Ref.IntRef i2 = new Ref.IntRef();
                    Map map5 = ContainerUtil.newMapFromKeys(this.getOutputValues().iterator(), arg_0 -> AsTuple.getUnboxingExpressions$lambda$1((Function1)new Function1<OutputValue<KotlinType>, String>(boxedText, i2){
                        final /* synthetic */ String $boxedText;
                        final /* synthetic */ Ref.IntRef $i;
                        {
                            this.$boxedText = $boxedText;
                            this.$i = $i;
                            super(1);
                        }

                        public final String invoke(OutputValue<KotlinType> it) {
                            int n = this.$i.element;
                            this.$i.element = n + 1;
                            return this.$boxedText + "." + AsTuple.access$getSelectors$cp()[n];
                        }
                    }, arg_0));
                    Intrinsics.checkNotNull((Object)map5);
                    map2 = map5;
                }
            }
            return map2;
        }

        private static final String getUnboxingExpressions$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ String[] access$getSelectors$cp() {
            return selectors;
        }

        static {
            String[] stringArray = new String[]{"first", "second", "third"};
            selectors = stringArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValueBoxer$AsTuple$Companion;", "", "()V", "selectors", "", "", "[Ljava/lang/String;", "kotlin.refactorings.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

