/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.script.configuration;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.core.script.BundledIdeScriptDefinition;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J,\u0010\b\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\n\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/script/configuration/MultipleScriptDefinitionsChecker;", "Lcom/intellij/ui/EditorNotificationProvider;", "()V", "areDefinitionsForGradleKts", "", "allApplicableDefinitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotification", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "defs", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMultipleScriptDefinitionsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipleScriptDefinitionsChecker.kt\norg/jetbrains/kotlin/idea/script/configuration/MultipleScriptDefinitionsChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition\n*L\n1#1,96:1\n118#2:97\n1#3:98\n766#4:99\n857#4:100\n858#4:102\n1726#4,2:103\n1728#4:106\n58#5:101\n58#5:105\n*S KotlinDebug\n*F\n+ 1 MultipleScriptDefinitionsChecker.kt\norg/jetbrains/kotlin/idea/script/configuration/MultipleScriptDefinitionsChecker\n*L\n36#1:97\n42#1:99\n42#1:100\n42#1:102\n55#1:103,2\n55#1:106\n43#1:101\n56#1:105\n*E\n"})
public final class MultipleScriptDefinitionsChecker
implements EditorNotificationProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        KtFile p0;
        Object object;
        Object $this$safeAs$iv;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!FileUtils.isKotlinFileType(file2)) {
                    return null;
                }
                $this$safeAs$iv = PsiManager.getInstance((Project)project2).findFile(file2);
                boolean $i$f$safeAs = false;
                PsiFile psiFile2 = $this$safeAs$iv;
                if (!(psiFile2 instanceof KtFile)) {
                    psiFile2 = null;
                }
                if ((object = (KtFile)psiFile2) == null) break block11;
                p0 = $i$f$safeAs = object;
                boolean bl = false;
                object = p0.isScript() ? $i$f$safeAs : null;
                if (object != null) break block12;
            }
            return null;
        }
        KtFile ktFile2 = object;
        if (KotlinScriptingSettings.Companion.getInstance(project2).getSuppressDefinitionsCheck()) {
            return null;
        }
        $this$safeAs$iv = ScriptDefinitionsManager.Companion.getInstance(project2).getAllDefinitions();
        boolean $i$f$filter = false;
        p0 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinScriptDefinition kotlinScriptDefinition;
            ScriptDefinition it = (ScriptDefinition)((Object)element$iv$iv);
            boolean bl = false;
            ScriptDefinition this_$iv = it;
            boolean $i$f$asLegacyOrNull = false;
            if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                KotlinScriptDefinition kotlinScriptDefinition2 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                if (!(kotlinScriptDefinition2 instanceof BundledIdeScriptDefinition)) {
                    kotlinScriptDefinition2 = null;
                }
                kotlinScriptDefinition = (BundledIdeScriptDefinition)kotlinScriptDefinition2;
            } else {
                kotlinScriptDefinition = null;
            }
            boolean bl2 = kotlinScriptDefinition == null && it.isScript(new KtFileScriptSource(ktFile2, null, 2, null)) && KotlinScriptingSettings.Companion.getInstance(project2).isScriptDefinitionEnabled(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allApplicableDefinitions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (allApplicableDefinitions.size() < 2 || this.areDefinitionsForGradleKts(allApplicableDefinitions)) {
            return null;
        }
        return arg_0 -> MultipleScriptDefinitionsChecker.collectNotificationData$lambda$1(this, project2, allApplicableDefinitions, arg_0);
    }

    private final boolean areDefinitionsForGradleKts(List<? extends ScriptDefinition> allApplicableDefinitions) {
        boolean bl;
        block8: {
            Iterable $this$all$iv = allApplicableDefinitions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    KotlinScriptDefinition kotlinScriptDefinition;
                    ScriptDefinition definition2 = (ScriptDefinition)((Object)element$iv);
                    boolean bl3 = false;
                    ScriptDefinition this_$iv = definition2;
                    boolean $i$f$asLegacyOrNull = false;
                    if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                        KotlinScriptDefinition kotlinScriptDefinition2 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                        if (!(kotlinScriptDefinition2 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                            kotlinScriptDefinition2 = null;
                        }
                        kotlinScriptDefinition = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2;
                    } else {
                        kotlinScriptDefinition = null;
                    }
                    if ((KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition != null) {
                        KotlinScriptDefinitionFromAnnotatedTemplate it;
                        boolean bl4 = false;
                        String pattern2 = it.getScriptFilePattern().getPattern();
                        bl2 = StringsKt.endsWith$default((String)pattern2, (String)"\\.gradle\\.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)pattern2, (String)"\\.gradle\\.kts$", (boolean)false, (int)2, null);
                    } else {
                        bl2 = StringsKt.endsWith$default((String)definition2.getFileExtension(), (String)"gradle.kts", (boolean)false, (int)2, null);
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final EditorNotificationPanel createNotification(FileEditor fileEditor, Project project2, List<? extends ScriptDefinition> defs) {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createNotification_u24lambda_u246 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        boolean bl = false;
        Object[] objectArray = new Object[]{((ScriptDefinition)((Object)CollectionsKt.first(defs))).getName()};
        $this$createNotification_u24lambda_u246.setText(KotlinBundle.message((String)"script.text.multiple.script.definitions.are.applicable.for.this.script", (Object[])objectArray));
        UiUtils.createComponentActionLabel($this$createNotification_u24lambda_u246, KotlinBundle.message((String)"script.action.text.show.all", (Object[])new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(defs){
            final /* synthetic */ List<ScriptDefinition> $defs;
            {
                this.$defs = $defs;
                super(1);
            }

            public final void invoke(@NotNull HyperlinkLabel label2) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ScriptDefinition>(this.$defs){

                    @NotNull
                    public String getTextFor(@NotNull ScriptDefinition value2) {
                        Object object;
                        block12: {
                            KotlinScriptDefinition kotlinScriptDefinition;
                            block11: {
                                KotlinScriptDefinition kotlinScriptDefinition2;
                                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                                ScriptDefinition this_$iv = value2;
                                boolean $i$f$asLegacyOrNull = false;
                                if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                                    KotlinScriptDefinition kotlinScriptDefinition3 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                                    if (!(kotlinScriptDefinition3 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                                        kotlinScriptDefinition3 = null;
                                    }
                                    kotlinScriptDefinition2 = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition3;
                                } else {
                                    kotlinScriptDefinition2 = null;
                                }
                                if ((object = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2) == null) break block11;
                                KotlinScriptDefinitionFromAnnotatedTemplate it = object;
                                boolean bl = false;
                                String string = it.getName() + " (" + it.getScriptFilePattern() + ")";
                                object = string;
                                if (string != null) break block12;
                            }
                            ScriptDefinition this_$iv = value2;
                            boolean $i$f$asLegacyOrNull = false;
                            if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                                KotlinScriptDefinition kotlinScriptDefinition4 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                                if (!(kotlinScriptDefinition4 instanceof BundledIdeScriptDefinition)) {
                                    kotlinScriptDefinition4 = null;
                                }
                                kotlinScriptDefinition = (BundledIdeScriptDefinition)kotlinScriptDefinition4;
                            } else {
                                kotlinScriptDefinition = null;
                            }
                            BundledIdeScriptDefinition bundledIdeScriptDefinition = (BundledIdeScriptDefinition)kotlinScriptDefinition;
                            if (bundledIdeScriptDefinition != null) {
                                BundledIdeScriptDefinition it = bundledIdeScriptDefinition;
                                boolean bl = false;
                                object = it.getName() + " (" + KotlinParserDefinition.STD_SCRIPT_EXT + ")";
                            } else {
                                object = value2.getName() + " (" + value2.getFileExtension() + ")";
                            }
                        }
                        Object text2 = object;
                        return text2;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
                ListPopup list2 = listPopup;
                list2.showUnderneathOf((Component)label2);
            }
        }));
        $this$createNotification_u24lambda_u246.createActionLabel(KotlinBundle.message((String)"script.action.text.ignore", (Object[])new Object[0]), () -> MultipleScriptDefinitionsChecker.createNotification$lambda$6$lambda$4(project2));
        $this$createNotification_u24lambda_u246.createActionLabel(KotlinBundle.message((String)"script.action.text.open.settings", (Object[])new Object[0]), () -> MultipleScriptDefinitionsChecker.createNotification$lambda$6$lambda$5(project2));
        return editorNotificationPanel;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$1(MultipleScriptDefinitionsChecker this$0, Project $project, List $allApplicableDefinitions, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$allApplicableDefinitions, (String)"$allApplicableDefinitions");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        return this$0.createNotification(fileEditor, $project, $allApplicableDefinitions);
    }

    private static final void createNotification$lambda$6$lambda$4(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        KotlinScriptingSettings.Companion.getInstance($project).setSuppressDefinitionsCheck(true);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }

    private static final void createNotification$lambda$6$lambda$5(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "preferences.language.Kotlin.scripting", "");
    }
}

