/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinASStatisticsEventFlags;", "", "()V", "IS_KMP_MODULE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "calculateAndPackEventsFlagsToLong", "", "module", "Lcom/intellij/openapi/module/Module;", "Builder", "kotlin.base.statistics"})
public final class KotlinASStatisticsEventFlags {
    @NotNull
    public static final KotlinASStatisticsEventFlags INSTANCE = new KotlinASStatisticsEventFlags();
    @NotNull
    private static final Logger LOG;
    private static final int IS_KMP_MODULE;

    private KotlinASStatisticsEventFlags() {
    }

    public final long calculateAndPackEventsFlagsToLong(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return new Builder().build((Function1<? super Builder, Unit>)((Function1)new Function1<Builder, Unit>(module2){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(1);
            }

            public final void invoke(@NotNull Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.registerEvent(KotlinASStatisticsEventFlags.access$getIS_KMP_MODULE$p(), KotlinFacetUtils.isKpmModule(this.$module));
            }
        }));
    }

    public static final /* synthetic */ int access$getIS_KMP_MODULE$p() {
        return IS_KMP_MODULE;
    }

    static {
        Logger logger = Logger.getInstance(KotlinASStatisticsEventFlags.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinASStatisticsEventFlags$Builder;", "", "()V", "events", "", "", "", "build", "", "f", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "calculateLong", "registerEvent", "eventIndex", "value", "kotlin.base.statistics"})
    private static final class Builder {
        @NotNull
        private final Map<Integer, Boolean> events = new LinkedHashMap();

        public final long build(@NotNull Function1<? super Builder, Unit> f2) {
            Intrinsics.checkNotNullParameter(f2, (String)"f");
            f2.invoke((Object)this);
            return this.calculateLong();
        }

        public final void registerEvent(int eventIndex, boolean value2) {
            if (this.events.get(eventIndex) != null) {
                LOG.error("Event with index " + eventIndex + " already registered");
                return;
            }
            if (eventIndex < 0 || eventIndex > 63) {
                LOG.error("Event index should be in range [0, 63], but it is " + eventIndex);
                return;
            }
            Integer n = eventIndex;
            Boolean bl = value2;
            this.events.put(n, bl);
        }

        private final long calculateLong() {
            Ref.LongRef flags = new Ref.LongRef();
            for (Map.Entry<Integer, Boolean> entry : this.events.entrySet()) {
                int bitIndex = ((Number)entry.getKey()).intValue();
                boolean value2 = entry.getValue();
                if (!value2) continue;
                Builder.calculateLong$setBit(flags, bitIndex);
            }
            return flags.element;
        }

        private static final void calculateLong$setBit(Ref.LongRef flags, int bitIndex) {
            flags.element |= 1L << bitIndex;
        }
    }
}

