/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.versions.BinaryVersionedFile;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinJsMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinJvmMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.LibInfo;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a>\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u0002\u001aE\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00110\u0010\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00122\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001e\u0010\u001f\u001a\u00020 *\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"DEPRECATED_LIBRARIES_INFORMATION", "", "Lorg/jetbrains/kotlin/idea/versions/DeprecatedLibInfo;", "getDEPRECATED_LIBRARIES_INFORMATION", "()Ljava/util/List;", "MAVEN_JS_STDLIB_ID", "", "MAVEN_JS_TEST_ID", "deprecatedLib", "oldGroupId", "oldName", "newGroupId", "newName", "outdatedAfterVersion", "message", "getLibraryRootsWithAbiIncompatibleVersion", "", "Lorg/jetbrains/kotlin/idea/versions/BinaryVersionedFile;", "T", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "module", "Lcom/intellij/openapi/module/Module;", "supportedVersion", "indexId", "Lcom/intellij/util/indexing/ID;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lcom/intellij/util/indexing/ID;)Ljava/util/Collection;", "getLibraryRootsWithIncompatibleAbi", "getLibraryRootsWithIncompatibleAbiJavaScript", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "getLibraryRootsWithIncompatibleAbiJvm", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "forEachAllUsedLibraries", "", "Lcom/intellij/openapi/project/Project;", "processor", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/libraries/Library;", "", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nKotlinRuntimeLibraryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRuntimeLibraryUtil.kt\norg/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n1549#2:138\n1620#2,3:139\n819#2:144\n847#2,2:145\n37#3,2:142\n*S KotlinDebug\n*F\n+ 1 KotlinRuntimeLibraryUtil.kt\norg/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtilKt\n*L\n61#1:138\n61#1:139,3\n65#1:144\n65#1:145,2\n61#1:142,2\n*E\n"})
public final class KotlinRuntimeLibraryUtilKt {
    @NotNull
    public static final String MAVEN_JS_STDLIB_ID = "kotlin-stdlib-js";
    @NotNull
    public static final String MAVEN_JS_TEST_ID = "kotlin-test-js";
    @NotNull
    private static final List<DeprecatedLibInfo> DEPRECATED_LIBRARIES_INFORMATION;

    @NotNull
    public static final Collection<BinaryVersionedFile<BinaryVersion>> getLibraryRootsWithIncompatibleAbi(@NotNull Module module2) {
        Collection<BinaryVersionedFile<JvmMetadataVersion>> collection;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        TargetPlatform platform2 = TargetPlatformDetectorUtils.getPlatform(module2);
        if (JvmPlatformKt.isJvm((TargetPlatform)platform2)) {
            collection = KotlinRuntimeLibraryUtilKt.getLibraryRootsWithIncompatibleAbiJvm(module2);
        } else if (JsPlatformKt.isJs((TargetPlatform)platform2)) {
            collection = KotlinRuntimeLibraryUtilKt.getLibraryRootsWithIncompatibleAbiJavaScript(module2);
        } else {
            return CollectionsKt.emptyList();
        }
        Collection<BinaryVersionedFile<JvmMetadataVersion>> badRoots = collection;
        return badRoots.isEmpty() ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.toHashSet((Iterable)badRoots);
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JvmMetadataVersion>> getLibraryRootsWithIncompatibleAbiJvm(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module2, (BinaryVersion)JvmMetadataVersion.INSTANCE, KotlinJvmMetadataVersionIndex.Companion.getNAME());
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JsMetadataVersion>> getLibraryRootsWithIncompatibleAbiJavaScript(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module2, (BinaryVersion)JsMetadataVersion.INSTANCE, KotlinJsMetadataVersionIndex.Companion.getNAME());
    }

    public static final void forEachAllUsedLibraries(@NotNull Project $this$forEachAllUsedLibraries, @NotNull Function1<? super Library, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachAllUsedLibraries, (String)"<this>");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        OrderEnumerator.orderEntries((Project)$this$forEachAllUsedLibraries).forEachLibrary(arg_0 -> KotlinRuntimeLibraryUtilKt.forEachAllUsedLibraries$lambda$0(processor2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends BinaryVersion> Collection<BinaryVersionedFile<T>> getLibraryRootsWithAbiIncompatibleVersion(Module module2, T supportedVersion, ID<T, ?> indexId) {
        void $this$filterNotTo$iv$iv;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Set set = SetsKt.setOf((Object)module2);
        List list2 = ModuleUtil.getAllDependentModules((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllDependentModules(...)");
        Set moduleWithAllDependencies = SetsKt.plus((Set)set, (Iterable)list2);
        Iterable $this$map$iv = moduleWithAllDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module3 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModuleWithLibrariesScope());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])thisCollection$iv.toArray(new GlobalSearchScope[0]));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        GlobalSearchScope moduleWithAllDependentLibraries = globalSearchScope;
        Collection collection = FileBasedIndex.getInstance().getAllKeys(indexId, module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllKeys(...)");
        Collection allVersions = collection;
        Iterable $this$filterNot$iv = allVersions;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            BinaryVersion p0 = (BinaryVersion)element$iv$iv;
            boolean bl = false;
            if (p0.isCompatible()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        HashSet badVersions = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        HashSet<BinaryVersionedFile<BinaryVersion>> badRoots = new HashSet<BinaryVersionedFile<BinaryVersion>>();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex2 = projectFileIndex;
        for (BinaryVersion version2 : badVersions) {
            Collection indexedFiles;
            Intrinsics.checkNotNullExpressionValue((Object)FileBasedIndex.getInstance().getContainingFiles(indexId, (Object)version2, moduleWithAllDependentLibraries), (String)"getContainingFiles(...)");
            for (VirtualFile indexedFile : indexedFiles) {
                VirtualFile libraryRoot;
                if (fileIndex2.getClassRootForFile(indexedFile) == null) {
                    throw new IllegalStateException(("Only library roots were requested, and only class files should be indexed with the " + indexId + " key. File: " + indexedFile.getPath()).toString());
                }
                VirtualFile virtualFile2 = VfsUtil.getLocalFile((VirtualFile)libraryRoot);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getLocalFile(...)");
                badRoots.add(new BinaryVersionedFile<BinaryVersion>(virtualFile2, version2, supportedVersion));
            }
        }
        return badRoots;
    }

    private static final DeprecatedLibInfo deprecatedLib(String oldGroupId, String oldName, String newGroupId, String newName2, String outdatedAfterVersion, @Nls String message2) {
        return new DeprecatedLibInfo(new LibInfo(oldGroupId, oldName, null, 4, null), new LibInfo(newGroupId, newName2, null, 4, null), outdatedAfterVersion, message2);
    }

    static /* synthetic */ DeprecatedLibInfo deprecatedLib$default(String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = string;
        }
        if ((n & 8) != 0) {
            string4 = string2;
        }
        return KotlinRuntimeLibraryUtilKt.deprecatedLib(string, string2, string3, string4, string5, string6);
    }

    @NotNull
    public static final List<DeprecatedLibInfo> getDEPRECATED_LIBRARIES_INFORMATION() {
        return DEPRECATED_LIBRARIES_INFORMATION;
    }

    private static final boolean forEachAllUsedLibraries$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new DeprecatedLibInfo[2];
        Object[] objectArray2 = new Object[]{"kotlin-stdlib-jre7", "kotlin-stdlib-jdk7"};
        objectArray[0] = KotlinRuntimeLibraryUtilKt.deprecatedLib$default("org.jetbrains.kotlin", "kotlin-stdlib-jre7", null, "kotlin-stdlib-jdk7", "1.2.0-rc-39", KotlinProjectConfigurationBundle.message("version.message.is.deprecated.since.1.2.0.and.should.be.replaced.with", objectArray2), 4, null);
        objectArray2 = new Object[]{"kotlin-stdlib-jre8", "kotlin-stdlib-jdk8"};
        objectArray[1] = KotlinRuntimeLibraryUtilKt.deprecatedLib$default("org.jetbrains.kotlin", "kotlin-stdlib-jre8", null, "kotlin-stdlib-jdk8", "1.2.0-rc-39", KotlinProjectConfigurationBundle.message("version.message.is.deprecated.since.1.2.0.and.should.be.replaced.with", objectArray2), 4, null);
        DEPRECATED_LIBRARIES_INFORMATION = CollectionsKt.listOf((Object[])objectArray);
    }
}

