/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.nj2k.NullabilityKt;

class J2KNullityInferrer {
    private static final int MAX_PASSES = 10;
    private int numAnnotationsAdded;
    private final Set<PsiType> myNotNullTypes = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<PsiType> myNullableTypes = Collections.newSetFromMap(new IdentityHashMap());

    J2KNullityInferrer() {
    }

    Set<PsiType> getNotNullTypes() {
        return this.myNotNullTypes;
    }

    Set<PsiType> getNullableTypes() {
        return this.myNullableTypes;
    }

    private boolean expressionIsNeverNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        if (ExpressionUtils.nonStructuralChildren((PsiExpression)expression2).allMatch(expr -> expr instanceof PsiMethodCallExpression && this.isNotNull((PsiModifierListOwner)((PsiMethodCallExpression)expr).resolveMethod()))) {
            return true;
        }
        return NullabilityUtil.getExpressionNullability((PsiExpression)expression2, (boolean)true) == Nullability.NOT_NULL;
    }

    private boolean expressionIsSometimesNull(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        if (ExpressionUtils.nonStructuralChildren((PsiExpression)expression2).anyMatch(expr -> expr instanceof PsiMethodCallExpression && this.isNullable((PsiModifierListOwner)((PsiMethodCallExpression)expr).resolveMethod()))) {
            return true;
        }
        return NullabilityUtil.getExpressionNullability((PsiExpression)expression2, (boolean)true) == Nullability.NULLABLE;
    }

    private boolean variableNeverAssignedNull(@NotNull PsiVariable variable2) {
        SearchScope scope2;
        PsiExpression initializer2;
        if (variable2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(0);
        }
        if ((initializer2 = variable2.getInitializer()) != null) {
            if (!this.expressionIsNeverNull(initializer2)) {
                return false;
            }
        } else {
            PsiParameter parameter;
            if (!variable2.hasModifierProperty("final")) {
                return false;
            }
            if (variable2 instanceof PsiParameter && (parameter = (PsiParameter)variable2).getDeclarationScope() instanceof PsiCatchSection) {
                return false;
            }
        }
        if ((scope2 = J2KNullityInferrer.getScope(variable2)) == null) {
            return false;
        }
        Query references2 = ReferencesSearch.search((PsiElement)variable2, (SearchScope)scope2);
        for (PsiReference reference2 : references2) {
            PsiAssignmentExpression assignment2;
            PsiElement parent2;
            PsiElement element3 = reference2.getElement();
            if (!(element3 instanceof PsiReferenceExpression) || !((parent2 = element3.getParent()) instanceof PsiAssignmentExpression) || !(assignment2 = (PsiAssignmentExpression)parent2).getLExpression().equals(element3) || this.expressionIsNeverNull(assignment2.getRExpression())) continue;
            return false;
        }
        return true;
    }

    private boolean variableSometimesAssignedNull(@NotNull PsiVariable variable2) {
        PsiExpression initializer2;
        if (variable2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(1);
        }
        if ((initializer2 = variable2.getInitializer()) != null && this.expressionIsSometimesNull(initializer2)) {
            return true;
        }
        SearchScope scope2 = J2KNullityInferrer.getScope(variable2);
        if (scope2 == null) {
            return false;
        }
        Query references2 = ReferencesSearch.search((PsiElement)variable2, (SearchScope)scope2);
        for (PsiReference reference2 : references2) {
            PsiAssignmentExpression assignment2;
            PsiElement parent2;
            PsiElement element3 = reference2.getElement();
            if (!(element3 instanceof PsiReferenceExpression) || !((parent2 = element3.getParent()) instanceof PsiAssignmentExpression) || !(assignment2 = (PsiAssignmentExpression)parent2).getLExpression().equals(element3) || !this.expressionIsSometimesNull(assignment2.getRExpression())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static SearchScope getScope(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(2);
        }
        if (!(variable2 instanceof PsiField)) {
            return variable2.getUseScope();
        }
        PsiField field2 = (PsiField)variable2;
        if (J2KNullityInferrer.isPrivate(field2)) {
            return variable2.getUseScope();
        }
        PsiFile containingFile = variable2.getContainingFile();
        return containingFile != null ? new LocalSearchScope((PsiElement)containingFile) : null;
    }

    private static boolean isPrivate(PsiField field2) {
        PsiModifierList modifierList = field2.getModifierList();
        if (modifierList == null) {
            return false;
        }
        return modifierList.hasModifierProperty("private");
    }

    public void collect(@NotNull PsiFile file2) {
        int prevNumAnnotationsAdded;
        if (file2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(3);
        }
        file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitTypeElement(@NotNull PsiTypeElement typeElement2) {
                if (typeElement2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeElement(typeElement2);
                PsiType type2 = typeElement2.getType();
                Nullability nullability = DfaPsiUtil.getTypeNullability((PsiType)type2);
                switch (nullability) {
                    case NULLABLE: {
                        J2KNullityInferrer.this.registerNullableType(type2);
                        break;
                    }
                    case NOT_NULL: {
                        J2KNullityInferrer.this.registerNotNullType(type2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/nj2k/J2KNullityInferrer$1", "visitTypeElement"));
            }
        });
        int pass = 0;
        do {
            NullityInferrerVisitor visitor2 = new NullityInferrerVisitor();
            prevNumAnnotationsAdded = this.numAnnotationsAdded;
            file2.accept((PsiElementVisitor)visitor2);
        } while (prevNumAnnotationsAdded < this.numAnnotationsAdded && ++pass < 10);
    }

    private void registerNullableAnnotation(@NotNull PsiModifierListOwner declaration2) {
        if (declaration2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(4);
        }
        this.registerAnnotation(declaration2, true);
    }

    private void registerNotNullAnnotation(@NotNull PsiModifierListOwner declaration2) {
        if (declaration2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(5);
        }
        this.registerAnnotation(declaration2, false);
    }

    private void registerAnnotation(@NotNull PsiModifierListOwner declaration2, boolean isNullable) {
        PsiType type2;
        if (declaration2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(6);
        }
        if ((type2 = J2KNullityInferrer.getType(declaration2)) == null) {
            return;
        }
        this.registerTypeNullability(type2, isNullable);
    }

    private static PsiType getType(PsiModifierListOwner declaration2) {
        if (declaration2 instanceof PsiVariable) {
            return ((PsiVariable)declaration2).getType();
        }
        if (declaration2 instanceof PsiMethod) {
            return ((PsiMethod)declaration2).getReturnType();
        }
        return null;
    }

    private void registerNullableType(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(7);
        }
        this.registerTypeNullability(type2, true);
    }

    private void registerNotNullType(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(8);
        }
        this.registerTypeNullability(type2, false);
    }

    private void registerTypeNullability(@NotNull PsiType type2, boolean isNullable) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(9);
        }
        if (this.isNullable(type2)) {
            return;
        }
        if (this.isNotNull(type2) && !isNullable) {
            return;
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        if (isNullable) {
            this.myNullableTypes.add(unwrappedType);
            this.myNotNullTypes.remove(unwrappedType);
        } else {
            this.myNotNullTypes.add(unwrappedType);
        }
        ++this.numAnnotationsAdded;
    }

    private boolean registerAnnotationByNullAssignmentStatus(PsiVariable variable2) {
        if (this.variableNeverAssignedNull(variable2)) {
            this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
            return true;
        }
        if (this.variableSometimesAssignedNull(variable2)) {
            this.registerNullableAnnotation((PsiModifierListOwner)variable2);
            return true;
        }
        return false;
    }

    private boolean isNotNull(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (NullableNotNullManager.isNotNull((PsiModifierListOwner)owner)) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.isNotNull(type2);
    }

    private boolean isNotNull(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(10);
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        return this.myNotNullTypes.contains(unwrappedType);
    }

    private boolean isNullable(@Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        if (NullableNotNullManager.isNullable((PsiModifierListOwner)owner)) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.isNullable(type2);
    }

    private boolean isNullable(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(11);
        }
        PsiType unwrappedType = J2KNullityInferrer.unwrap(type2);
        return this.myNullableTypes.contains(unwrappedType);
    }

    @NotNull
    private static PsiType unwrap(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(12);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)type2;
            return J2KNullityInferrer.unwrap((PsiType)capturedWildcardType.getWildcard());
        }
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (wildcardType.isExtends()) {
                PsiType psiType = wildcardType.getExtendsBound();
                if (psiType == null) {
                    J2KNullityInferrer.$$$reportNull$$$0(13);
                }
                return psiType;
            }
            if (wildcardType.isSuper()) {
                PsiType psiType = wildcardType.getSuperBound();
                if (psiType == null) {
                    J2KNullityInferrer.$$$reportNull$$$0(14);
                }
                return psiType;
            }
        }
        PsiType psiType = type2;
        if (psiType == null) {
            J2KNullityInferrer.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    private boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        NullableNotNullManager manager;
        NullabilityAnnotationInfo info2;
        if (owner == null) {
            J2KNullityInferrer.$$$reportNull$$$0(16);
        }
        if ((info2 = (manager = NullableNotNullManager.getInstance((Project)owner.getProject())).findEffectiveNullabilityInfo(owner)) != null && !info2.isInferred() && info2.getNullability() != Nullability.UNKNOWN) {
            return true;
        }
        PsiType type2 = J2KNullityInferrer.getType(owner);
        if (type2 == null) {
            return false;
        }
        return this.hasNullability(type2);
    }

    private boolean hasNullability(@NotNull PsiType type2) {
        if (type2 == null) {
            J2KNullityInferrer.$$$reportNull$$$0(17);
        }
        return this.isNullable(type2) || this.isNotNull(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "variableNeverAssignedNull";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "variableSometimesAssignedNull";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerNullableAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerNotNullAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerNullableType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerNotNullType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerTypeNullability";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class NullityInferrerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private NullityInferrerVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor() || method.getReturnType() instanceof PsiPrimitiveType) {
                return;
            }
            Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overridingMethod : overridingMethods) {
                if (!J2KNullityInferrer.this.isNullable((PsiModifierListOwner)overridingMethod)) continue;
                J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                return;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
            if (!manager.isNotNull((PsiModifierListOwner)method, false) && manager.isNotNull((PsiModifierListOwner)method, true)) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                return;
            }
            if (J2KNullityInferrer.this.hasNullability((PsiModifierListOwner)method)) {
                return;
            }
            Nullability nullability = DfaUtil.inferMethodNullability((PsiMethod)method);
            switch (nullability) {
                case NULLABLE: {
                    J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)method);
                    break;
                }
                case NOT_NULL: {
                    for (PsiMethod overridingMethod : overridingMethods) {
                        if (J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)overridingMethod)) continue;
                        return;
                    }
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)method);
                }
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable2) {
            if (variable2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable2);
            if (variable2.getType() instanceof PsiPrimitiveType || J2KNullityInferrer.this.hasNullability((PsiModifierListOwner)variable2)) {
                return;
            }
            if (J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)variable2)) {
                return;
            }
            this.inferNullabilityFromVariableReferences((PsiVariable)variable2);
        }

        private void inferNullabilityFromVariableReferences(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(2);
            }
            if (KotlinPluginModeProvider.Companion.isK1Mode()) {
                return;
            }
            SearchScope scope2 = J2KNullityInferrer.getScope(variable2);
            if (scope2 == null) {
                return;
            }
            Query references2 = ReferencesSearch.search((PsiElement)variable2, (SearchScope)scope2);
            for (PsiReference reference2 : references2) {
                PsiElement element3 = reference2.getElement();
                if (!(element3 instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element3;
                PsiElement refParent = PsiTreeUtil.skipParentsOfType((PsiElement)referenceExpression, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
                this.processReference(variable2, referenceExpression, refParent);
                if (!J2KNullityInferrer.this.isNullable((PsiModifierListOwner)variable2)) continue;
                break;
            }
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(3);
            }
            super.visitParameter(parameter);
            if (parameter.getType() instanceof PsiPrimitiveType || J2KNullityInferrer.this.hasNullability((PsiModifierListOwner)parameter)) {
                return;
            }
            PsiElement grandParent = parameter.getDeclarationScope();
            if (grandParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)grandParent;
                if (method.getBody() != null) {
                    if (JavaSourceInference.inferNullability((PsiParameter)parameter) == Nullability.NOT_NULL) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return;
                    }
                    for (PsiReferenceExpression expr : VariableAccessUtils.getVariableReferences((PsiVariable)parameter, (PsiElement)method)) {
                        PsiElement parent2;
                        if (this.processReference((PsiVariable)parameter, expr, parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) {
                            return;
                        }
                        if (!J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)method)) continue;
                        PsiElement toReturn = parent2;
                        if (parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getCondition() != expr) {
                            toReturn = parent2.getParent();
                        }
                        if (!(toReturn instanceof PsiReturnStatement)) continue;
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)parameter);
                        return;
                    }
                }
            } else if (grandParent instanceof PsiForeachStatement) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(grandParent))) {
                    PsiElement parent3;
                    PsiReferenceExpression expr;
                    PsiElement place = reference2.getElement();
                    if (!(place instanceof PsiReferenceExpression) || !this.processReference((PsiVariable)parameter, expr = (PsiReferenceExpression)place, parent3 = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class}))) continue;
                    return;
                }
            } else {
                J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)parameter);
            }
        }

        private boolean processReference(@NotNull PsiVariable variable2, @NotNull PsiReferenceExpression expr, PsiElement parent2) {
            PsiSwitchStatement switchStatement;
            if (variable2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(4);
            }
            if (expr == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(5);
            }
            if (NullabilityKt.isUsedInAutoUnboxingContext(expr)) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
                return true;
            }
            if (NullabilityKt.getDfaNullability((PsiExpression)expr) == DfaNullability.NOT_NULL) {
                return false;
            }
            if (parent2 instanceof PsiThrowStatement) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            if (parent2 instanceof PsiSynchronizedStatement) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            if (parent2 instanceof PsiArrayAccessExpression) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            if (parent2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)parent2;
                PsiExpression opposite = null;
                PsiExpression lOperand = binOp.getLOperand();
                PsiExpression rOperand = binOp.getROperand();
                if (lOperand == expr) {
                    opposite = rOperand;
                } else if (rOperand == expr) {
                    opposite = lOperand;
                }
                if (opposite != null && opposite.getType() == PsiTypes.nullType()) {
                    if (DfaPsiUtil.isAssertionEffectively((PsiExpression)binOp, (binOp.getOperationTokenType() == JavaTokenType.NE ? 1 : 0) != 0)) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                        return true;
                    }
                    J2KNullityInferrer.this.registerNullableAnnotation((PsiModifierListOwner)variable2);
                    return true;
                }
            } else if (parent2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)parent2;
                PsiExpression qualifierExpression = ref.getQualifierExpression();
                if (qualifierExpression == expr) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                    return true;
                }
                PsiElement exprParent = expr.getParent();
                while (exprParent instanceof PsiTypeCastExpression || exprParent instanceof PsiParenthesizedExpression) {
                    if (qualifierExpression == exprParent) {
                        J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                        return true;
                    }
                    exprParent = exprParent.getParent();
                }
            } else if (parent2 instanceof PsiAssignmentExpression) {
                PsiVariable localVar;
                PsiReferenceExpression ref;
                PsiExpression psiExpression;
                PsiAssignmentExpression assignment2 = (PsiAssignmentExpression)parent2;
                if (assignment2.getRExpression() == expr && (psiExpression = assignment2.getLExpression()) instanceof PsiReferenceExpression && (psiExpression = (ref = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiVariable && J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)(localVar = (PsiVariable)psiExpression))) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                    return true;
                }
            } else if (parent2 instanceof PsiForeachStatement) {
                PsiForeachStatement forEach = (PsiForeachStatement)parent2;
                if (forEach.getIteratedValue() == expr) {
                    J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                    return true;
                }
            } else if (parent2 instanceof PsiSwitchStatement && (switchStatement = (PsiSwitchStatement)parent2).getExpression() == expr) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            return this.processArgumentReference(variable2, expr);
        }

        private boolean processArgumentReference(@NotNull PsiVariable variable2, @NotNull PsiReferenceExpression expr) {
            PsiParameter parameter;
            boolean isVarArgs;
            PsiCall call2;
            if (variable2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(6);
            }
            if (expr == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(7);
            }
            if ((call2 = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiCall.class)) == null) {
                return false;
            }
            PsiExpressionList argumentList2 = call2.getArgumentList();
            if (argumentList2 == null) {
                return false;
            }
            Object[] args = argumentList2.getExpressions();
            int idx = ArrayUtil.find((Object[])args, (Object)expr);
            if (idx < 0) {
                return false;
            }
            PsiMethod resolvedMethod = call2.resolveMethod();
            if (resolvedMethod == null) {
                return false;
            }
            PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
            if (idx >= parameters2.length) {
                return false;
            }
            PsiParameter resolvedToParam = parameters2[idx];
            boolean isArray = variable2.getType() instanceof PsiArrayType;
            boolean bl = isVarArgs = variable2 instanceof PsiParameter && (parameter = (PsiParameter)variable2).isVarArgs();
            if (J2KNullityInferrer.this.isNotNull((PsiModifierListOwner)resolvedToParam) || isArray && !isVarArgs && resolvedToParam.isVarArgs()) {
                J2KNullityInferrer.this.registerNotNullAnnotation((PsiModifierListOwner)variable2);
                return true;
            }
            return false;
        }

        public void visitField(@NotNull PsiField field2) {
            if (field2 == null) {
                NullityInferrerVisitor.$$$reportNull$$$0(8);
            }
            super.visitField(field2);
            if (field2 instanceof PsiEnumConstant || field2.getType() instanceof PsiPrimitiveType || J2KNullityInferrer.this.hasNullability((PsiModifierListOwner)field2)) {
                return;
            }
            if (J2KNullityInferrer.this.registerAnnotationByNullAssignmentStatus((PsiVariable)field2)) {
                return;
            }
            if (!J2KNullityInferrer.isPrivate(field2)) {
                return;
            }
            this.inferNullabilityFromVariableReferences((PsiVariable)field2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/nj2k/J2KNullityInferrer$NullityInferrerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inferNullabilityFromVariableReferences";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processArgumentReference";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

