/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"getDfaNullability", "Lcom/intellij/codeInspection/dataFlow/DfaNullability;", "expr", "Lcom/intellij/psi/PsiExpression;", "isUsedInAutoUnboxingContext", "", "Lcom/intellij/psi/PsiReferenceExpression;", "kotlin.j2k.shared"})
public final class NullabilityKt {
    public static final boolean isUsedInAutoUnboxingContext(@NotNull PsiReferenceExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        PsiType exprType = expr.getType();
        if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)exprType)) {
            return false;
        }
        PsiType psiType = ExpectedTypeUtils.findExpectedType((PsiExpression)((PsiExpression)expr), (boolean)false);
        if (psiType == null) {
            return false;
        }
        PsiType expectedType = psiType;
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType)) {
            return false;
        }
        PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)exprType);
        if (psiPrimitiveType == null) {
            return false;
        }
        PsiPrimitiveType unboxedType = psiPrimitiveType;
        return expectedType.isAssignableFrom((PsiType)unboxedType);
    }

    @Nullable
    public static final DfaNullability getDfaNullability(@NotNull PsiExpression expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        CommonDataflow.DataflowResult dataflowResult = CommonDataflow.getDataflowResult((PsiElement)((PsiElement)expr));
        if (dataflowResult == null) {
            return null;
        }
        CommonDataflow.DataflowResult dataflowResult2 = dataflowResult;
        DfType dfType = dataflowResult2.getDfType(expr);
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType dfType2 = dfType;
        if (!(dfType2 instanceof DfReferenceType)) {
            return null;
        }
        return ((DfReferenceType)dfType2).getNullability();
    }
}

