/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IteratorNext;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "getKotlinPrimitiveClassName", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getPrimitiveIteratorType", "primitiveClassName", "backend.jvm.codegen"})
public final class IteratorNext
extends IntrinsicMethod {
    @NotNull
    public static final IteratorNext INSTANCE = new IteratorNext();

    private IteratorNext() {
    }

    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        Type type = AsmUtil.isBoxedPrimitiveType(signature.getReturnType()) ? AsmUtil.unboxType(signature.getReturnType()) : signature.getReturnType();
        Intrinsics.checkNotNull((Object)type);
        Type type2 = type;
        JvmMethodSignature newSignature = IntrinsicMethod.Companion.newReturnType(signature, type2);
        Name primitiveClassName = this.getKotlinPrimitiveClassName(type2);
        return IntrinsicFunction.Companion.create(expression2, newSignature, classCodegen, CollectionsKt.listOf((Object)this.getPrimitiveIteratorType(primitiveClassName)), (Function2<? super IntrinsicFunction, ? super InstructionAdapter, Unit>)((Function2)(arg_0, arg_1) -> IteratorNext.toCallable$lambda$0(primitiveClassName, type2, arg_0, arg_1)));
    }

    private final Name getKotlinPrimitiveClassName(Type type) {
        return JvmPrimitiveType.get((String)type.getClassName()).getPrimitiveType().getTypeName();
    }

    private final Type getPrimitiveIteratorType(Name primitiveClassName) {
        Name name = Name.identifier((String)(primitiveClassName.asString() + "Iterator"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        Name iteratorName = name;
        FqName fqName = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.child(iteratorName);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        Type type = Type.getObjectType((String)JvmFileClassUtilKt.getInternalNameWithoutInnerClasses((FqName)fqName));
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getObjectType(...)");
        return type;
    }

    private static final Unit toCallable$lambda$0(Name $primitiveClassName, Type $type, IntrinsicFunction $this$create, InstructionAdapter it) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"$this$create");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.invokevirtual(INSTANCE.getPrimitiveIteratorType($primitiveClassName).getInternalName(), "next" + $primitiveClassName.asString(), "()" + $type.getDescriptor(), false);
        return Unit.INSTANCE;
    }
}

