/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="JvmBuiltInsLowering", description="JVM-specific implementations of some built-ins")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "coerceIfPossible", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmBuiltInsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuiltInsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class JvmBuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> jvm8builtInReplacements;

    public JvmBuiltInsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"compareTo"), (Object)this.context.getIr().getSymbols().getCompareUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"div"), (Object)this.context.getIr().getSymbols().getDivideUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"rem"), (Object)this.context.getIr().getSymbols().getRemainderUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"toString"), (Object)this.context.getIr().getSymbols().getToUnsignedStringInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"compareTo"), (Object)this.context.getIr().getSymbols().getCompareUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"div"), (Object)this.context.getIr().getSymbols().getDivideUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"rem"), (Object)this.context.getIr().getSymbols().getRemainderUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"toString"), (Object)this.context.getIr().getSymbols().getToUnsignedStringLong())};
        this.jvm8builtInReplacements = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidWithContext transformer2 = new IrElementTransformerVoidWithContext(this){
            final /* synthetic */ JvmBuiltInsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                IrSimpleFunctionSymbol jvm8Replacement;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                expression2.transformChildren((IrElementTransformer)this, null);
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                String string = AdditionalIrUtilsKt.getFqNameForIrSerialization((IrDeclarationParent)callee.getParent()).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String parentClassName = string;
                String string2 = callee.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String functionName = string2;
                if (Intrinsics.areEqual((Object)parentClassName, (Object)"kotlin.CompareToKt") && Intrinsics.areEqual((Object)functionName, (Object)"compareTo")) {
                    IrExpression irExpression2 = expression2.getValueArgument(0);
                    Intrinsics.checkNotNull((Object)irExpression2);
                    IrType operandType = irExpression2.getType();
                    if (IrTypePredicatesKt.isUInt((IrType)operandType)) {
                        return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getIr().getSymbols().getCompareUnsignedInt());
                    }
                    if (IrTypePredicatesKt.isULong((IrType)operandType)) {
                        return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getIr().getSymbols().getCompareUnsignedLong());
                    }
                }
                if ((jvm8Replacement = (IrSimpleFunctionSymbol)JvmBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to((Object)parentClassName, (Object)functionName))) != null) {
                    return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, jvm8Replacement);
                }
                if (VarargLoweringKt.isArrayOf((IrFunction)callee)) {
                    irExpression = expression2.getValueArgument(0);
                    if (irExpression == null) {
                        throw new AssertionError((Object)("Argument #0 expected: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression2), null, (int)1, null)));
                    }
                } else if (VarargLoweringKt.isEmptyArray((IrFunction)callee)) {
                    JvmBackendContext jvmBackendContext = this.this$0.getContext();
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    irExpression = IrArrayBuilderKt.irArrayOf$default(JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr, (IrElement)expression2), expression2.getType(), null, 2, null);
                } else {
                    irExpression = (IrExpression)expression2;
                }
                return irExpression;
            }
        };
        irFile.transformChildren((IrElementTransformer)transformer2, null);
    }

    private final IrExpression replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        IrExpression irExpression;
        IrExpression it;
        IrCallImpl irCallImpl;
        IrType expectedType = $this$replaceWithCallTo.getType();
        IrType intrinsicCallType = ((IrSimpleFunction)replacement.getOwner()).getReturnType();
        IrCallImpl newCall = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$replaceWithCallTo.getStartOffset(), (int)$this$replaceWithCallTo.getEndOffset(), (IrType)intrinsicCallType, (IrSimpleFunctionSymbol)replacement, (int)0, (int)0, null, null, (int)240, null);
        boolean bl = false;
        Ref.IntRef valueArgumentOffset = new Ref.IntRef();
        IrExpression irExpression2 = $this$replaceWithCallTo.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl2 = false;
            if (!JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall, it)) {
                return (IrExpression)$this$replaceWithCallTo;
            }
        }
        IrExpression irExpression3 = $this$replaceWithCallTo.getDispatchReceiver();
        if (irExpression3 != null) {
            it = irExpression3;
            boolean bl3 = false;
            if (!JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall, it)) {
                return (IrExpression)$this$replaceWithCallTo;
            }
        }
        int n = $this$replaceWithCallTo.getValueArgumentsCount();
        for (int index = 0; index < n; ++index) {
            IrExpression irExpression4 = $this$replaceWithCallTo.getValueArgument(index);
            Intrinsics.checkNotNull((Object)irExpression4);
            if (JvmBuiltInsLowering.replaceWithCallTo$lambda$2$tryToAddCoercedArgument(this, replacement, valueArgumentOffset, newCall, irExpression4)) continue;
            return (IrExpression)$this$replaceWithCallTo;
        }
        IrCallImpl intrinsicCall = irCallImpl;
        if (IrTypePredicatesKt.isInt((IrType)intrinsicCallType) || IrTypePredicatesKt.isLong((IrType)intrinsicCallType)) {
            irExpression = this.coerceIfPossible((IrExpression)intrinsicCall, expectedType);
            if (irExpression == null) {
                throw new AssertionError((Object)("Can't coerce '" + RenderIrElementKt.render$default((IrType)intrinsicCallType, null, (int)1, null) + "' to '" + RenderIrElementKt.render$default((IrType)expectedType, null, (int)1, null) + '\''));
            }
        } else {
            irExpression = (IrExpression)intrinsicCall;
        }
        return irExpression;
    }

    private final IrExpression coerceIfPossible(IrExpression $this$coerceIfPossible, IrType toType) {
        IrExpression irExpression;
        Type toJvmType;
        Type fromJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), $this$coerceIfPossible.getType(), null, null, false, 14, null);
        if (!Intrinsics.areEqual((Object)fromJvmType, (Object)(toJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), toType, null, null, false, 14, null)))) {
            irExpression = null;
        } else {
            IrCallImpl irCallImpl;
            IrCallImpl call2 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$coerceIfPossible.getStartOffset(), (int)$this$coerceIfPossible.getEndOffset(), (IrType)toType, (IrSimpleFunctionSymbol)this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), (int)0, (int)0, null, null, (int)240, null);
            boolean bl = false;
            call2.putTypeArgument(0, $this$coerceIfPossible.getType());
            call2.putTypeArgument(1, toType);
            call2.putValueArgument(0, $this$coerceIfPossible);
            irExpression = (IrExpression)irCallImpl;
        }
        return irExpression;
    }

    private static final boolean replaceWithCallTo$lambda$2$tryToAddCoercedArgument(JvmBuiltInsLowering this$0, IrSimpleFunctionSymbol $replacement, Ref.IntRef valueArgumentOffset, IrCallImpl $newCall, IrExpression expr) {
        IrExpression irExpression = this$0.coerceIfPossible(expr, ((IrValueParameter)((IrSimpleFunction)$replacement.getOwner()).getValueParameters().get(valueArgumentOffset.element)).getType());
        if (irExpression == null) {
            return false;
        }
        IrExpression coercedExpr = irExpression;
        int n = valueArgumentOffset.element;
        valueArgumentOffset.element = n + 1;
        $newCall.putValueArgument(n, coercedExpr);
        return true;
    }

    public static final /* synthetic */ IrExpression access$replaceWithCallTo(JvmBuiltInsLowering $this, IrCall $receiver, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($receiver, replacement);
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmBuiltInsLowering $this) {
        return $this.jvm8builtInReplacements;
    }
}

