/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationData;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@PhaseDescription(name="TailCallOptimization", description="Add or move returns to suspension points on tail-call positions")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TailCallOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "coerceToUnit", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.jvm.lower"})
public final class TailCallOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public TailCallOptimizationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.transformChildren((IrElementTransformer)new IrElementTransformer<TailCallOptimizationData>(this){
            final /* synthetic */ TailCallOptimizationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitSimpleFunction(IrSimpleFunction declaration, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrElementTransformer.DefaultImpls.visitSimpleFunction((IrElementTransformer)this, (IrSimpleFunction)declaration, (Object)(declaration.isSuspend() ? new TailCallOptimizationData(declaration) : null));
            }

            public IrExpression visitContainerExpression(IrContainerExpression expression2, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)((IrInlinedFunctionBlock)expression2))) {
                    return (IrExpression)expression2;
                }
                return IrElementTransformer.DefaultImpls.visitContainerExpression((IrElementTransformer)this, (IrContainerExpression)expression2, (Object)data);
            }

            public IrExpression visitCall(IrCall expression2, TailCallOptimizationData data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElement irElement = IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
                Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                IrExpression transformed = (IrExpression)irElement;
                return data == null || !data.getTailCalls().contains(expression2) ? transformed : (IrExpression)new IrReturnImpl(data.getFunction().getEndOffset(), data.getFunction().getEndOffset(), TailCallOptimizationLowering.access$getContext$p(this.this$0).getIrBuiltIns().getNothingType(), (IrReturnTargetSymbol)data.getFunction().getSymbol(), data.getReturnsUnit() ? TailCallOptimizationLowering.access$coerceToUnit(this.this$0, transformed) : transformed);
            }

            public IrElement visitElement(IrElement element, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitElement((IrElementTransformer)this, (IrElement)element, (Object)data);
            }

            public IrStatement visitDeclaration(IrDeclarationBase declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDeclaration((IrElementTransformer)this, (IrDeclarationBase)declaration, (Object)data);
            }

            public IrStatement visitValueParameter(IrValueParameter declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitValueParameter((IrElementTransformer)this, (IrValueParameter)declaration, (Object)data);
            }

            public IrStatement visitClass(IrClass declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitClass((IrElementTransformer)this, (IrClass)declaration, (Object)data);
            }

            public IrStatement visitAnonymousInitializer(IrAnonymousInitializer declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer((IrElementTransformer)this, (IrAnonymousInitializer)declaration, (Object)data);
            }

            public IrStatement visitTypeParameter(IrTypeParameter declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitTypeParameter((IrElementTransformer)this, (IrTypeParameter)declaration, (Object)data);
            }

            public IrStatement visitFunction(IrFunction declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFunction((IrElementTransformer)this, (IrFunction)declaration, (Object)data);
            }

            public IrStatement visitConstructor(IrConstructor declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstructor((IrElementTransformer)this, (IrConstructor)declaration, (Object)data);
            }

            public IrStatement visitEnumEntry(IrEnumEntry declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitEnumEntry((IrElementTransformer)this, (IrEnumEntry)declaration, (Object)data);
            }

            public IrStatement visitErrorDeclaration(IrErrorDeclaration declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration((IrElementTransformer)this, (IrErrorDeclaration)declaration, (Object)data);
            }

            public IrStatement visitField(IrField declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitField((IrElementTransformer)this, (IrField)declaration, (Object)data);
            }

            public IrStatement visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty((IrElementTransformer)this, (IrLocalDelegatedProperty)declaration, (Object)data);
            }

            public IrModuleFragment visitModuleFragment(IrModuleFragment declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitModuleFragment((IrElementTransformer)this, (IrModuleFragment)declaration, (Object)data);
            }

            public IrStatement visitProperty(IrProperty declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitProperty((IrElementTransformer)this, (IrProperty)declaration, (Object)data);
            }

            public IrStatement visitScript(IrScript declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitScript((IrElementTransformer)this, (IrScript)declaration, (Object)data);
            }

            public IrStatement visitTypeAlias(IrTypeAlias declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitTypeAlias((IrElementTransformer)this, (IrTypeAlias)declaration, (Object)data);
            }

            public IrStatement visitVariable(IrVariable declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitVariable((IrElementTransformer)this, (IrVariable)declaration, (Object)data);
            }

            public IrElement visitPackageFragment(IrPackageFragment declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitPackageFragment((IrElementTransformer)this, (IrPackageFragment)declaration, (Object)data);
            }

            public IrExternalPackageFragment visitExternalPackageFragment(IrExternalPackageFragment declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment((IrElementTransformer)this, (IrExternalPackageFragment)declaration, (Object)data);
            }

            public IrFile visitFile(IrFile declaration, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFile((IrElementTransformer)this, (IrFile)declaration, (Object)data);
            }

            public IrExpression visitExpression(IrExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitExpression((IrElementTransformer)this, (IrExpression)expression2, (Object)data);
            }

            public IrBody visitBody(IrBody body, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBody((IrElementTransformer)this, (IrBody)body, (Object)data);
            }

            public IrBody visitExpressionBody(IrExpressionBody body, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitExpressionBody((IrElementTransformer)this, (IrExpressionBody)body, (Object)data);
            }

            public IrBody visitBlockBody(IrBlockBody body, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBlockBody((IrElementTransformer)this, (IrBlockBody)body, (Object)data);
            }

            public IrExpression visitDeclarationReference(IrDeclarationReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDeclarationReference((IrElementTransformer)this, (IrDeclarationReference)expression2, (Object)data);
            }

            public IrElement visitMemberAccess(IrMemberAccessExpression<?> expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitMemberAccess((IrElementTransformer)this, expression2, (Object)data);
            }

            public IrElement visitFunctionAccess(IrFunctionAccessExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFunctionAccess((IrElementTransformer)this, (IrFunctionAccessExpression)expression2, (Object)data);
            }

            public IrElement visitConstructorCall(IrConstructorCall expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstructorCall((IrElementTransformer)this, (IrConstructorCall)expression2, (Object)data);
            }

            public IrExpression visitSingletonReference(IrGetSingletonValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSingletonReference((IrElementTransformer)this, (IrGetSingletonValue)expression2, (Object)data);
            }

            public IrExpression visitGetObjectValue(IrGetObjectValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitGetObjectValue((IrElementTransformer)this, (IrGetObjectValue)expression2, (Object)data);
            }

            public IrExpression visitGetEnumValue(IrGetEnumValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitGetEnumValue((IrElementTransformer)this, (IrGetEnumValue)expression2, (Object)data);
            }

            public IrExpression visitRawFunctionReference(IrRawFunctionReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitRawFunctionReference((IrElementTransformer)this, (IrRawFunctionReference)expression2, (Object)data);
            }

            public IrExpression visitBlock(IrBlock expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBlock((IrElementTransformer)this, (IrBlock)expression2, (Object)data);
            }

            public IrExpression visitComposite(IrComposite expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitComposite((IrElementTransformer)this, (IrComposite)expression2, (Object)data);
            }

            public IrExpression visitReturnableBlock(IrReturnableBlock expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitReturnableBlock((IrElementTransformer)this, (IrReturnableBlock)expression2, (Object)data);
            }

            public IrExpression visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock((IrElementTransformer)this, (IrInlinedFunctionBlock)inlinedBlock, (Object)data);
            }

            public IrBody visitSyntheticBody(IrSyntheticBody body, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSyntheticBody((IrElementTransformer)this, (IrSyntheticBody)body, (Object)data);
            }

            public IrExpression visitBreakContinue(IrBreakContinue jump, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBreakContinue((IrElementTransformer)this, (IrBreakContinue)jump, (Object)data);
            }

            public IrExpression visitBreak(IrBreak jump, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBreak((IrElementTransformer)this, (IrBreak)jump, (Object)data);
            }

            public IrExpression visitContinue(IrContinue jump, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitContinue((IrElementTransformer)this, (IrContinue)jump, (Object)data);
            }

            public IrElement visitCallableReference(IrCallableReference<?> expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitCallableReference((IrElementTransformer)this, expression2, (Object)data);
            }

            public IrElement visitFunctionReference(IrFunctionReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFunctionReference((IrElementTransformer)this, (IrFunctionReference)expression2, (Object)data);
            }

            public IrElement visitPropertyReference(IrPropertyReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitPropertyReference((IrElementTransformer)this, (IrPropertyReference)expression2, (Object)data);
            }

            public IrElement visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementTransformer)this, (IrLocalDelegatedPropertyReference)expression2, (Object)data);
            }

            public IrExpression visitClassReference(IrClassReference expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitClassReference((IrElementTransformer)this, (IrClassReference)expression2, (Object)data);
            }

            public IrExpression visitConst(IrConst<?> expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConst((IrElementTransformer)this, expression2, (Object)data);
            }

            public IrConstantValue visitConstantValue(IrConstantValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstantValue((IrElementTransformer)this, (IrConstantValue)expression2, (Object)data);
            }

            public IrConstantValue visitConstantPrimitive(IrConstantPrimitive expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstantPrimitive((IrElementTransformer)this, (IrConstantPrimitive)expression2, (Object)data);
            }

            public IrConstantValue visitConstantObject(IrConstantObject expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstantObject((IrElementTransformer)this, (IrConstantObject)expression2, (Object)data);
            }

            public IrConstantValue visitConstantArray(IrConstantArray expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitConstantArray((IrElementTransformer)this, (IrConstantArray)expression2, (Object)data);
            }

            public IrElement visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall((IrElementTransformer)this, (IrDelegatingConstructorCall)expression2, (Object)data);
            }

            public IrExpression visitDynamicExpression(IrDynamicExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDynamicExpression((IrElementTransformer)this, (IrDynamicExpression)expression2, (Object)data);
            }

            public IrExpression visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression((IrElementTransformer)this, (IrDynamicOperatorExpression)expression2, (Object)data);
            }

            public IrExpression visitDynamicMemberExpression(IrDynamicMemberExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression((IrElementTransformer)this, (IrDynamicMemberExpression)expression2, (Object)data);
            }

            public IrElement visitEnumConstructorCall(IrEnumConstructorCall expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall((IrElementTransformer)this, (IrEnumConstructorCall)expression2, (Object)data);
            }

            public IrExpression visitErrorExpression(IrErrorExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitErrorExpression((IrElementTransformer)this, (IrErrorExpression)expression2, (Object)data);
            }

            public IrExpression visitErrorCallExpression(IrErrorCallExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression((IrElementTransformer)this, (IrErrorCallExpression)expression2, (Object)data);
            }

            public IrExpression visitFieldAccess(IrFieldAccessExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFieldAccess((IrElementTransformer)this, (IrFieldAccessExpression)expression2, (Object)data);
            }

            public IrExpression visitGetField(IrGetField expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitGetField((IrElementTransformer)this, (IrGetField)expression2, (Object)data);
            }

            public IrExpression visitSetField(IrSetField expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSetField((IrElementTransformer)this, (IrSetField)expression2, (Object)data);
            }

            public IrElement visitFunctionExpression(IrFunctionExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitFunctionExpression((IrElementTransformer)this, (IrFunctionExpression)expression2, (Object)data);
            }

            public IrExpression visitGetClass(IrGetClass expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitGetClass((IrElementTransformer)this, (IrGetClass)expression2, (Object)data);
            }

            public IrExpression visitInstanceInitializerCall(IrInstanceInitializerCall expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall((IrElementTransformer)this, (IrInstanceInitializerCall)expression2, (Object)data);
            }

            public IrExpression visitLoop(IrLoop loop, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitLoop((IrElementTransformer)this, (IrLoop)loop, (Object)data);
            }

            public IrExpression visitWhileLoop(IrWhileLoop loop, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitWhileLoop((IrElementTransformer)this, (IrWhileLoop)loop, (Object)data);
            }

            public IrExpression visitDoWhileLoop(IrDoWhileLoop loop, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop((IrElementTransformer)this, (IrDoWhileLoop)loop, (Object)data);
            }

            public IrExpression visitReturn(IrReturn expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitReturn((IrElementTransformer)this, (IrReturn)expression2, (Object)data);
            }

            public IrExpression visitStringConcatenation(IrStringConcatenation expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitStringConcatenation((IrElementTransformer)this, (IrStringConcatenation)expression2, (Object)data);
            }

            public IrExpression visitSuspensionPoint(IrSuspensionPoint expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint((IrElementTransformer)this, (IrSuspensionPoint)expression2, (Object)data);
            }

            public IrExpression visitSuspendableExpression(IrSuspendableExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression((IrElementTransformer)this, (IrSuspendableExpression)expression2, (Object)data);
            }

            public IrExpression visitThrow(IrThrow expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitThrow((IrElementTransformer)this, (IrThrow)expression2, (Object)data);
            }

            public IrExpression visitTry(IrTry aTry, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitTry((IrElementTransformer)this, (IrTry)aTry, (Object)data);
            }

            public IrCatch visitCatch(IrCatch aCatch, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitCatch((IrElementTransformer)this, (IrCatch)aCatch, (Object)data);
            }

            public IrExpression visitTypeOperator(IrTypeOperatorCall expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitTypeOperator((IrElementTransformer)this, (IrTypeOperatorCall)expression2, (Object)data);
            }

            public IrExpression visitValueAccess(IrValueAccessExpression expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitValueAccess((IrElementTransformer)this, (IrValueAccessExpression)expression2, (Object)data);
            }

            public IrExpression visitGetValue(IrGetValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitGetValue((IrElementTransformer)this, (IrGetValue)expression2, (Object)data);
            }

            public IrExpression visitSetValue(IrSetValue expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSetValue((IrElementTransformer)this, (IrSetValue)expression2, (Object)data);
            }

            public IrExpression visitVararg(IrVararg expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitVararg((IrElementTransformer)this, (IrVararg)expression2, (Object)data);
            }

            public IrSpreadElement visitSpreadElement(IrSpreadElement spread, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitSpreadElement((IrElementTransformer)this, (IrSpreadElement)spread, (Object)data);
            }

            public IrExpression visitWhen(IrWhen expression2, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitWhen((IrElementTransformer)this, (IrWhen)expression2, (Object)data);
            }

            public IrBranch visitBranch(IrBranch branch, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitBranch((IrElementTransformer)this, (IrBranch)branch, (Object)data);
            }

            public IrElseBranch visitElseBranch(IrElseBranch branch, TailCallOptimizationData data) {
                return IrElementTransformer.DefaultImpls.visitElseBranch((IrElementTransformer)this, (IrElseBranch)branch, (Object)data);
            }
        }, null);
    }

    private final IrExpression coerceToUnit(IrExpression $this$coerceToUnit) {
        return Intrinsics.areEqual((Object)$this$coerceToUnit.getType(), (Object)this.context.getIrBuiltIns().getUnitType()) ? $this$coerceToUnit : (IrExpression)BuildersKt.IrTypeOperatorCallImpl((int)$this$coerceToUnit.getStartOffset(), (int)$this$coerceToUnit.getEndOffset(), (IrType)this.context.getIrBuiltIns().getUnitType(), (IrTypeOperator)IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, (IrType)this.context.getIrBuiltIns().getUnitType(), (IrExpression)$this$coerceToUnit);
    }

    public static final /* synthetic */ JvmBackendContext access$getContext$p(TailCallOptimizationLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ IrExpression access$coerceToUnit(TailCallOptimizationLowering $this, IrExpression $receiver) {
        return $this.coerceToUnit($receiver);
    }
}

