/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.IrWhenUtils;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.WasmStringSwitchOptimizerLoweringKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u000278B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0014\u0010#\u001a\u00020\u0016*\u00020\u00142\u0006\u0010$\u001a\u00020\u0013H\u0002JL\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&*\u00020\u00142\u0014\u0010(\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0004\u0012\u00020+0)2\u001a\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010*0&0)2\u0006\u0010-\u001a\u00020.H\u0002J4\u0010/\u001a\u00020.*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u00100\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u00101\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u00010\u001bH\u0002JL\u00103\u001a\b\u0012\u0004\u0012\u00020'0&*\u00020\u00142\u0014\u0010(\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0004\u0012\u00020+0)2\u001a\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010*0&0)2\u0006\u00104\u001a\u00020\u0018H\u0002J\u001c\u00105\u001a\u00020.*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00106\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020.H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "stringHashCode", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getStringHashCode", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "stringHashCode$delegate", "Lkotlin/Lazy;", "intType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "booleanType", "createEqEqForIntVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "tempIntVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "value", "", "asEqCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tryMatchCaseToNullableStringConstant", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "condition", "addHashCodeVariable", "firstEqCall", "createSimpleBucketSelectors", "", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering$BucketSelector;", "stringConstantToMatchedCase", "", "", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering$MatchedCase;", "buckets", "transformedWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "createWhenForBucketSelectors", "bucketsSelectors", "selectorsType", "elseBranchExpression", "createBucketSelectors", "elseBranchIndex", "createTransformedWhen", "visitWhen", "MatchedCase", "BucketSelector", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmStringSwitchOptimizerLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmStringSwitchOptimizerLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,302:1\n1#2:303\n1557#3:304\n1628#3,2:305\n1628#3,3:307\n1630#3:310\n1628#3,3:311\n1557#3:314\n1628#3,2:315\n1628#3,3:317\n1630#3:320\n1598#3,4:321\n1872#3,3:325\n1485#3:342\n1510#3,3:343\n1513#3,3:353\n388#4,13:328\n98#5:341\n99#5:356\n381#6,7:346\n*S KotlinDebug\n*F\n+ 1 WasmStringSwitchOptimizerLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering\n*L\n141#1:304\n141#1:305,2\n152#1:307,3\n141#1:310\n168#1:311,3\n199#1:314\n199#1:315,2\n211#1:317,3\n199#1:320\n223#1:321,4\n240#1:325,3\n265#1:342\n265#1:343,3\n265#1:353,3\n262#1:328,13\n262#1:341\n262#1:356\n265#1:346,7\n*E\n"})
public final class WasmStringSwitchOptimizerLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final Lazy stringHashCode$delegate;
    @NotNull
    private final IrType intType;
    @NotNull
    private final IrType booleanType;

    public WasmStringSwitchOptimizerLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getWasmSymbols();
        this.stringHashCode$delegate = LazyKt.lazy(() -> WasmStringSwitchOptimizerLowering.stringHashCode_delegate$lambda$0(this));
        this.intType = this.symbols.getIrBuiltIns().getIntType();
        this.booleanType = this.symbols.getIrBuiltIns().getBooleanType();
    }

    private final IrSimpleFunctionSymbol getStringHashCode() {
        Lazy lazy = this.stringHashCode$delegate;
        return (IrSimpleFunctionSymbol)lazy.getValue();
    }

    private final IrCall createEqEqForIntVariable(IrBlockBuilder $this$createEqEqForIntVariable, IrVariable tempIntVariable, int value) {
        IrCall irCall;
        IrCall it = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$createEqEqForIntVariable), (IrSimpleFunctionSymbol)$this$createEqEqForIntVariable.getContext().getIrBuiltIns().getEqeqSymbol(), (IrType)this.booleanType, (int)0, (int)0, null, (int)28, null);
        boolean bl = false;
        it.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$createEqEqForIntVariable), (IrValueDeclaration)((IrValueDeclaration)tempIntVariable)));
        it.putValueArgument(1, (IrExpression)IrUtilsKt.toIrConst$default((Object)value, (IrType)this.intType, (int)0, (int)0, (int)6, null));
        return irCall;
    }

    private final IrCall asEqCall(IrExpression expression2) {
        Object object;
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        if (irCall != null) {
            IrCall irCall2;
            IrCall it = irCall2 = irCall;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getSymbol(), (Object)this.context.getIrBuiltIns().getEqeqSymbol()) ? irCall2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    private final IrConst<?> tryMatchCaseToNullableStringConstant(IrExpression condition) {
        IrExpression irExpression;
        IrCall irCall = this.asEqCall(condition);
        if (irCall == null) {
            return null;
        }
        IrCall eqCall = irCall;
        if (eqCall.getValueArgumentsCount() < 2) {
            return null;
        }
        IrExpression irExpression2 = eqCall.getValueArgument(0);
        IrConst irConst = irExpression2 instanceof IrConst ? (IrConst)irExpression2 : null;
        if (irConst == null && (irConst = (irExpression = eqCall.getValueArgument(1)) instanceof IrConst ? (IrConst)irExpression : null) == null) {
            return null;
        }
        IrConst constantReceiver = irConst;
        IrConstKind irConstKind = constantReceiver.getKind();
        return Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.String.INSTANCE) || Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Null.INSTANCE) ? constantReceiver : null;
    }

    private final IrVariable addHashCodeVariable(IrBlockBuilder $this$addHashCodeVariable, IrCall firstEqCall) {
        IrExpression irExpression;
        IrCall irCall;
        IrExpression subject = null;
        int subjectArgumentIndex = 0;
        IrExpression irExpression2 = firstEqCall.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression firstArgument = irExpression2;
        if (firstArgument instanceof IrConst) {
            IrExpression irExpression3 = firstEqCall.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression3);
            subject = irExpression3;
            subjectArgumentIndex = 1;
        } else {
            subject = firstArgument;
            subjectArgumentIndex = 0;
        }
        IrType subjectType = subject.getType();
        IrDeclarationParent irDeclarationParent = $this$addHashCodeVariable.getScope().getLocalDeclarationParent();
        int n = $this$addHashCodeVariable.getStartOffset();
        int n2 = $this$addHashCodeVariable.getEndOffset();
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)WasmStringSwitchOptimizerLoweringKt.access$getOPTIMISED_WHEN_SUBJECT();
        Name name = Name.identifier((String)"tmp_when_subject");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        IrVariable whenSubject = DeclarationBuildersKt.buildVariable$default((IrDeclarationParent)irDeclarationParent, (int)n, (int)n2, (IrDeclarationOrigin)irDeclarationOrigin, (Name)name, (IrType)subjectType, (boolean)false, (boolean)false, (boolean)false, (int)448, null);
        whenSubject.setInitializer(subject);
        $this$addHashCodeVariable.unaryPlus((IrStatement)whenSubject);
        firstEqCall.putValueArgument(subjectArgumentIndex, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrValueDeclaration)((IrValueDeclaration)whenSubject)));
        IrDeclarationParent irDeclarationParent2 = $this$addHashCodeVariable.getScope().getLocalDeclarationParent();
        int n3 = $this$addHashCodeVariable.getStartOffset();
        int n4 = $this$addHashCodeVariable.getEndOffset();
        IrDeclarationOrigin irDeclarationOrigin2 = (IrDeclarationOrigin)WasmStringSwitchOptimizerLoweringKt.access$getOPTIMISED_WHEN_SUBJECT();
        Name name2 = Name.identifier((String)"tmp_int_when_subject");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        IrVariable tmpIntWhenSubject = DeclarationBuildersKt.buildVariable$default((IrDeclarationParent)irDeclarationParent2, (int)n3, (int)n4, (IrDeclarationOrigin)irDeclarationOrigin2, (Name)name2, (IrType)this.intType, (boolean)false, (boolean)false, (boolean)false, (int)448, null);
        IrCall it = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrSimpleFunctionSymbol)this.getStringHashCode(), (IrType)this.intType, (int)0, (int)0, null, (int)28, null);
        boolean bl = false;
        it.setDispatchReceiver((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrValueDeclaration)((IrValueDeclaration)whenSubject)));
        IrCall getHashCode = irCall;
        if (IrTypeUtilsKt.isNullable((IrType)subjectType)) {
            IrCall irCall2;
            IrCall it2 = irCall2 = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrSimpleFunctionSymbol)$this$addHashCodeVariable.getContext().getIrBuiltIns().getEqeqeqSymbol(), (IrType)this.booleanType, (int)0, (int)0, null, (int)28, null);
            boolean bl2 = false;
            it2.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrValueDeclaration)((IrValueDeclaration)whenSubject)));
            it2.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrType)subjectType));
            IrCall stringIsNull = irCall2;
            irExpression = (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)((IrBuilderWithScope)$this$addHashCodeVariable), (IrType)this.intType, (IrExpression)((IrExpression)stringIsNull), (IrExpression)((IrExpression)IrUtilsKt.toIrConst$default((Object)0, (IrType)this.intType, (int)0, (int)0, (int)6, null)), (IrExpression)((IrExpression)getHashCode), null, (int)16, null);
        } else {
            irExpression = (IrExpression)getHashCode;
        }
        IrExpression hashCode = irExpression;
        tmpIntWhenSubject.setInitializer(hashCode);
        $this$addHashCodeVariable.unaryPlus((IrStatement)tmpIntWhenSubject);
        return tmpIntWhenSubject;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BucketSelector> createSimpleBucketSelectors(IrBlockBuilder $this$createSimpleBucketSelectors, Map<String, MatchedCase> stringConstantToMatchedCase, Map<Integer, ? extends List<String>> buckets, IrWhen transformedWhen) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = buckets.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrWhen irWhen;
            void bucket;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (((List)bucket.getValue()).size() == 1) {
                String bucketCase = (String)((List)bucket.getValue()).get(0);
                MatchedCase matchedCase = (MatchedCase)MapsKt.getValue(stringConstantToMatchedCase, (Object)bucketCase);
                irWhen = (IrWhen)ExpressionHelpersKt.irIfThen$default((IrBuilderWithScope)((IrBuilderWithScope)$this$createSimpleBucketSelectors), (IrType)transformedWhen.getType(), (IrExpression)((IrExpression)matchedCase.getCondition()), (IrExpression)((IrBranch)transformedWhen.getBranches().get(matchedCase.getBranchIndex())).getResult(), null, (int)8, null);
            } else {
                List bucketBranches = new ArrayList();
                Iterable $this$mapTo$iv = (Iterable)bucket.getValue();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void bucketCase;
                    String string = (String)item$iv;
                    Collection collection2 = bucketBranches;
                    boolean bl2 = false;
                    MatchedCase matchedCase = (MatchedCase)MapsKt.getValue(stringConstantToMatchedCase, (Object)bucketCase);
                    collection2.add(ExpressionHelpersKt.irBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createSimpleBucketSelectors), (IrExpression)((IrExpression)matchedCase.getCondition()), (IrExpression)((IrBranch)transformedWhen.getBranches().get(matchedCase.getBranchIndex())).getResult()));
                }
                irWhen = (IrWhen)ExpressionHelpersKt.irWhen((IrBuilderWithScope)((IrBuilderWithScope)$this$createSimpleBucketSelectors), (IrType)transformedWhen.getType(), (List)bucketBranches);
            }
            IrWhen selector = irWhen;
            collection.add(new BucketSelector(((Number)bucket.getKey()).intValue(), (IrExpression)selector));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrWhen createWhenForBucketSelectors(IrBlockBuilder $this$createWhenForBucketSelectors, IrVariable tempIntVariable, List<BucketSelector> bucketsSelectors, IrType selectorsType, IrExpression elseBranchExpression) {
        List allBucketsWhenBranches = new ArrayList();
        Iterable $this$mapTo$iv = bucketsSelectors;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void bucketSelector;
            BucketSelector bucketSelector2 = (BucketSelector)item$iv;
            Collection collection = allBucketsWhenBranches;
            boolean bl = false;
            IrCall condition = this.createEqEqForIntVariable($this$createWhenForBucketSelectors, tempIntVariable, bucketSelector.getHashCode());
            collection.add(ExpressionHelpersKt.irBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createWhenForBucketSelectors), (IrExpression)((IrExpression)condition), (IrExpression)bucketSelector.getSelector()));
        }
        if (elseBranchExpression != null) {
            allBucketsWhenBranches.add(ExpressionHelpersKt.irElseBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createWhenForBucketSelectors), (IrExpression)elseBranchExpression));
        }
        return (IrWhen)ExpressionHelpersKt.irWhen((IrBuilderWithScope)((IrBuilderWithScope)$this$createWhenForBucketSelectors), (IrType)selectorsType, (List)allBucketsWhenBranches);
    }

    /*
     * WARNING - void declaration
     */
    private final List<BucketSelector> createBucketSelectors(IrBlockBuilder $this$createBucketSelectors, Map<String, MatchedCase> stringConstantToMatchedCase, Map<Integer, ? extends List<String>> buckets, int elseBranchIndex) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = buckets.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrWhen irWhen;
            void bucket;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (((List)bucket.getValue()).size() == 1) {
                String bucketCase = (String)((List)bucket.getValue()).get(0);
                MatchedCase matchedCase = (MatchedCase)MapsKt.getValue(stringConstantToMatchedCase, (Object)bucketCase);
                irWhen = (IrWhen)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)((IrBuilderWithScope)$this$createBucketSelectors), (IrType)this.intType, (IrExpression)((IrExpression)matchedCase.getCondition()), (IrExpression)((IrExpression)IrUtilsKt.toIrConst$default((Object)matchedCase.getBranchIndex(), (IrType)this.intType, (int)0, (int)0, (int)6, null)), (IrExpression)((IrExpression)IrUtilsKt.toIrConst$default((Object)elseBranchIndex, (IrType)this.intType, (int)0, (int)0, (int)6, null)), null, (int)16, null);
            } else {
                List bucketBranches = new ArrayList();
                Iterable $this$mapTo$iv = (Iterable)bucket.getValue();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void bucketCase;
                    String string = (String)item$iv;
                    Collection collection2 = bucketBranches;
                    boolean bl2 = false;
                    MatchedCase matchedCase = (MatchedCase)MapsKt.getValue(stringConstantToMatchedCase, (Object)bucketCase);
                    collection2.add(ExpressionHelpersKt.irBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createBucketSelectors), (IrExpression)((IrExpression)matchedCase.getCondition()), (IrExpression)((IrExpression)IrUtilsKt.toIrConst$default((Object)matchedCase.getBranchIndex(), (IrType)this.intType, (int)0, (int)0, (int)6, null))));
                }
                bucketBranches.add(ExpressionHelpersKt.irElseBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createBucketSelectors), (IrExpression)((IrExpression)IrUtilsKt.toIrConst$default((Object)elseBranchIndex, (IrType)this.intType, (int)0, (int)0, (int)6, null))));
                irWhen = (IrWhen)ExpressionHelpersKt.irWhen((IrBuilderWithScope)((IrBuilderWithScope)$this$createBucketSelectors), (IrType)this.intType, (List)bucketBranches);
            }
            IrWhen selector = irWhen;
            collection.add(new BucketSelector(((Number)bucket.getKey()).intValue(), (IrExpression)selector));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrWhen createTransformedWhen(IrBlockBuilder $this$createTransformedWhen, IrVariable tempIntVariable, IrWhen transformedWhen) {
        List mainResultsBranches = new ArrayList();
        Iterable $this$mapIndexedTo$iv = transformedWhen.getBranches();
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            void index;
            void branch;
            int n;
            Collection collection = mainResultsBranches;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrBranch irBranch = (IrBranch)item$iv;
            int n2 = n;
            Collection collection2 = collection;
            boolean bl = false;
            collection2.add(!IrUtilsKt.isElseBranch((IrBranch)branch) ? (IrBranch)ExpressionHelpersKt.irBranch((IrBuilderWithScope)((IrBuilderWithScope)$this$createTransformedWhen), (IrExpression)((IrExpression)this.createEqEqForIntVariable($this$createTransformedWhen, tempIntVariable, (int)index)), (IrExpression)branch.getResult()) : branch);
        }
        return (IrWhen)ExpressionHelpersKt.irWhen((IrBuilderWithScope)((IrBuilderWithScope)$this$createTransformedWhen), (IrType)transformedWhen.getType(), (List)mainResultsBranches);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2) {
        void $this$groupByTo$iv$iv;
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBlockBuilder irBlockBuilder;
        Object item$iv2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = super.visitWhen(expression2);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
        IrWhen visitedWhen = (IrWhen)irExpression;
        if (visitedWhen.getBranches().size() <= 2) {
            return (IrExpression)visitedWhen;
        }
        IrCall firstEqCall = null;
        boolean isSimpleWhen = false;
        isSimpleWhen = true;
        Map stringConstantToMatchedCase = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = visitedWhen.getBranches();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv2 : $this$forEachIndexed$iv) {
            void branch;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrBranch irBranch = (IrBranch)item$iv2;
            int branchIndex = n;
            boolean bl = false;
            if (!IrUtilsKt.isElseBranch((IrBranch)branch)) {
                ArrayList conditions;
                if (IrWhenUtils.INSTANCE.matchConditions((IrFunctionSymbol)this.context.getIrBuiltIns().getOrorSymbol(), branch.getCondition()) == null) {
                    return (IrExpression)visitedWhen;
                }
                if (conditions.isEmpty()) {
                    return (IrExpression)visitedWhen;
                }
                isSimpleWhen = isSimpleWhen && conditions.size() == 1;
                Intrinsics.checkNotNullExpressionValue(conditions.iterator(), (String)"iterator(...)");
                while (irBlockBuilder.hasNext()) {
                    IrConst<?> matchedStringConstant;
                    Object e = irBlockBuilder.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    IrCall condition = (IrCall)e;
                    if (this.tryMatchCaseToNullableStringConstant((IrExpression)condition) == null) {
                        return (IrExpression)visitedWhen;
                    }
                    Object object = matchedStringConstant.getValue();
                    String matchedString = object instanceof String ? (String)object : null;
                    if (stringConstantToMatchedCase.containsKey(matchedString)) continue;
                    stringConstantToMatchedCase.put(matchedString, new MatchedCase(condition, branchIndex));
                    IrCall irCall = firstEqCall;
                    if (irCall == null) {
                        irCall = this.asEqCall((IrExpression)condition);
                    }
                    firstEqCall = irCall;
                }
                continue;
            }
            isSimpleWhen = false;
        }
        if (firstEqCall == null || stringConstantToMatchedCase.size() < 2) {
            return (IrExpression)visitedWhen;
        }
        BackendContext backendContext = (BackendContext)this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        DeclarationIrBuilder $this$visitWhen_u24lambda_u2414 = LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null);
        boolean bl = false;
        item$iv2 = (IrBuilderWithScope)$this$visitWhen_u24lambda_u2414;
        IrType resultType$iv = visitedWhen.getType();
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$visitWhen_u24lambda_u2414_u24lambda_u2413 = this_$iv$iv;
        boolean bl2 = false;
        IrVariable tempIntVariable = this.addHashCodeVariable((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, firstEqCall);
        Iterable $this$groupBy$iv = stringConstantToMatchedCase.keySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            String string = it;
            Integer key$iv$iv = string != null ? string.hashCode() : 0;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map buckets = destination$iv$iv;
        if (isSimpleWhen) {
            List<BucketSelector> bucketsSelectors = this.createSimpleBucketSelectors((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, stringConstantToMatchedCase, buckets, expression2);
            $this$visitWhen_u24lambda_u2414_u24lambda_u2413.unaryPlus((IrStatement)this.createWhenForBucketSelectors((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, tempIntVariable, bucketsSelectors, expression2.getType(), null));
        } else {
            int elseBranchIndex = expression2.getBranches().size();
            List<BucketSelector> bucketsSelectors = this.createBucketSelectors((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, stringConstantToMatchedCase, buckets, elseBranchIndex);
            IrWhen caseSelectorWhen = this.createWhenForBucketSelectors((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, tempIntVariable, bucketsSelectors, this.intType, (IrExpression)IrUtilsKt.toIrConst$default((Object)elseBranchIndex, (IrType)this.intType, (int)0, (int)0, (int)6, null));
            $this$visitWhen_u24lambda_u2414_u24lambda_u2413.unaryPlus((IrStatement)ExpressionHelpersKt.irSet$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitWhen_u24lambda_u2414_u24lambda_u2413), (IrValueDeclaration)((IrValueDeclaration)tempIntVariable), (IrExpression)((IrExpression)caseSelectorWhen), null, (int)4, null));
            $this$visitWhen_u24lambda_u2414_u24lambda_u2413.unaryPlus((IrStatement)this.createTransformedWhen((IrBlockBuilder)$this$visitWhen_u24lambda_u2414_u24lambda_u2413, tempIntVariable, expression2));
        }
        IrContainerExpression convertedBlock = this_$iv$iv.doBuild();
        return (IrExpression)convertedBlock;
    }

    private static final IrSimpleFunctionSymbol stringHashCode_delegate$lambda$0(WasmStringSwitchOptimizerLowering this$0) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction((IrClassSymbol)this$0.symbols.getIrBuiltIns().getStringClass(), (String)"hashCode");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return irSimpleFunctionSymbol;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering$BucketSelector;", "", "hashCode", "", "selector", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "<init>", "(ILorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getHashCode", "()I", "getSelector", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
    private static final class BucketSelector {
        private final int hashCode;
        @NotNull
        private final IrExpression selector;

        public BucketSelector(int hashCode, @NotNull IrExpression selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            this.hashCode = hashCode;
            this.selector = selector;
        }

        public final int getHashCode() {
            return this.hashCode;
        }

        @NotNull
        public final IrExpression getSelector() {
            return this.selector;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmStringSwitchOptimizerLowering$MatchedCase;", "", "condition", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "branchIndex", "", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;I)V", "getCondition", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getBranchIndex", "()I", "backend.wasm"})
    private static final class MatchedCase {
        @NotNull
        private final IrCall condition;
        private final int branchIndex;

        public MatchedCase(@NotNull IrCall condition, int branchIndex) {
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            this.condition = condition;
            this.branchIndex = branchIndex;
        }

        @NotNull
        public final IrCall getCondition() {
            return this.condition;
        }

        public final int getBranchIndex() {
            return this.branchIndex;
        }
    }
}

