/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0004J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleFragmentToExternalName;", "", "jsOutputNamesMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "<init>", "(Ljava/util/Map;)V", "getExternalNameFor", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileName", "packageFqn", "moduleName", "getExternalNameForExporterFile", "getSafeNameFor", "getSafeNameExporterFor", "module", "getJsOutputName", "getFileStableName", "getPackageFqn", "externalName", "outputName", "getOutputName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "stableFileName", "getStableFileName", "backend.js"})
public final class ModuleFragmentToExternalName {
    @NotNull
    private final Map<IrModuleFragment, String> jsOutputNamesMapping;

    public ModuleFragmentToExternalName(@NotNull Map<IrModuleFragment, String> jsOutputNamesMapping) {
        Intrinsics.checkNotNullParameter(jsOutputNamesMapping, (String)"jsOutputNamesMapping");
        this.jsOutputNamesMapping = jsOutputNamesMapping;
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.getOutputName(file);
        String string2 = file.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.getExternalNameFor(string, string2, this.getJsOutputName(file.getModule()));
    }

    @NotNull
    public final String getExternalNameFor(@NotNull String fileName, @NotNull String packageFqn, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return moduleName + '/' + this.getFileStableName(fileName, packageFqn);
    }

    @NotNull
    public final String getExternalNameForExporterFile(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.getOutputName(file);
        String string2 = file.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.getExternalNameForExporterFile(string, string2, this.getJsOutputName(file.getModule()));
    }

    @NotNull
    public final String getExternalNameForExporterFile(@NotNull String fileName, @NotNull String packageFqn, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return this.getExternalNameFor(fileName, packageFqn, moduleName) + ".export";
    }

    @NotNull
    public final String getSafeNameFor(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return IrModuleToJsTransformerKt.getSafeName(file.getModule()) + '/' + this.getStableFileName(file);
    }

    @NotNull
    public final String getSafeNameExporterFor(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getSafeNameFor(file) + ".export";
    }

    @NotNull
    public final String getExternalNameFor(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.getJsOutputName(module2);
    }

    private final String getJsOutputName(IrModuleFragment $this$getJsOutputName) {
        String string = this.jsOutputNamesMapping.get($this$getJsOutputName);
        if (string == null) {
            string = NameTablesKt.sanitizeName$default(IrModuleToJsTransformerKt.getSafeName($this$getJsOutputName), false, 2, null);
        }
        return string;
    }

    private final String getFileStableName(String fileName, String packageFqn) {
        String prefix = StringsKt.replace$default((String)packageFqn, (char)'.', (char)'/', (boolean)false, (int)4, null);
        return prefix + (((CharSequence)prefix).length() > 0 ? "/" : "") + fileName;
    }

    @NotNull
    public final String getPackageFqn(@NotNull String externalName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)externalName, (String)"externalName");
        int endOfModuleNamePart = StringsKt.indexOf$default((CharSequence)externalName, (char)'/', (int)0, (boolean)false, (int)6, null);
        int startOfFileNamePart = StringsKt.lastIndexOf$default((CharSequence)externalName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (endOfModuleNamePart == startOfFileNamePart) {
            string = "";
        } else {
            String string2 = externalName.substring(endOfModuleNamePart + 1, startOfFileNamePart);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }
        return string;
    }

    private final String getOutputName(IrFile $this$outputName) {
        String string = AnnotationUtilsKt.getJsFileName($this$outputName);
        if (string == null) {
            string = IrJsUtilsKt.getNameWithoutExtension($this$outputName);
        }
        return string;
    }

    private final String getStableFileName(IrFile $this$stableFileName) {
        String string = this.getOutputName($this$stableFileName);
        String string2 = $this$stableFileName.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        return this.getFileStableName(string, string2);
    }
}

