/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"fixForwardNameReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class FixForwardNameReferencesKt {
    public static final void fixForwardNameReferences(@NotNull JsNode $this$fixForwardNameReferences) {
        Intrinsics.checkNotNullParameter((Object)$this$fixForwardNameReferences, (String)"<this>");
        $this$fixForwardNameReferences.accept(new RecursiveJsVisitor($this$fixForwardNameReferences){
            private final Map<String, JsName> currentScope;
            {
                void $this$associateByTo$iv$iv;
                this.currentScope = new LinkedHashMap<K, V>();
                Map<String, JsName> map = this.currentScope;
                Iterable $this$associateBy$iv = CollectUtilsKt.collectDefinedNames($receiver, true);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    JsName jsName = (JsName)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it.getIdent(), element$iv$iv);
                }
                Map map3 = destination$iv$iv;
                map.putAll(map3);
            }

            public final Map<String, JsName> getCurrentScope() {
                return this.currentScope;
            }

            private final void restore(String ident, JsName oldName) {
                if (oldName == null) {
                    this.currentScope.remove(ident);
                } else {
                    this.currentScope.put(ident, oldName);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                List localVars = CollectionsKt.toList((Iterable)CollectUtilsKt.collectLocalVariables(x, true));
                JsName[] backup = new JsName[localVars.size()];
                Iterable $this$forEachIndexed$iv = localVars;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void localVar;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    JsName jsName = (JsName)item$iv;
                    int index = n;
                    boolean bl = false;
                    backup[index] = this.currentScope.get(localVar.getIdent());
                    this.currentScope.put(localVar.getIdent(), (JsName)localVar);
                }
                super.visitFunction(x);
                int n = ((Collection)localVars).size() + -1;
                if (0 <= n) {
                    do {
                        int index = n--;
                        String string = ((JsName)localVars.get(index)).getIdent();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
                        this.restore(string, backup[index]);
                    } while (0 <= n);
                }
            }

            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName jsName = x.getParameter().getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                JsName name = jsName;
                JsName oldName = this.currentScope.get(name.getIdent());
                this.currentScope.put(name.getIdent(), name);
                super.visitCatch(x);
                String string = name.getIdent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
                this.restore(string, oldName);
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                if (nameRef.getQualifier() == null) {
                    String string = nameRef.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
                    String ident = string;
                    JsName name = this.currentScope.get(ident);
                    if (name != null) {
                        nameRef.setName(name);
                    }
                }
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        });
    }
}

