/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookCellTagLabel;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "tooltipText", "", "durationText", "executionCount", "", "statusIcon", "Ljavax/swing/Icon;", "isExecutable", "", "cellTags", "", "cellNum", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljavax/swing/Icon;ZLjava/util/List;I)V", "getCellNum", "()I", "delimiterHeight", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "Ljava/lang/Integer;", "isCollapsed", "notebookAppearance", "Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookEditorAppearance;", "plusTagButtonSize", "tagsSpacing", "createAddTagButton", "Ljavax/swing/JButton;", "createExecutionLabel", "Ljavax/swing/JLabel;", "createTagsRow", "Ljavax/swing/Box;", "getCollapsed", "isExecutionCountDefined", "updateBackgroundColor", "", "updateUI", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookBelowCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1#2:127\n1855#3,2:128\n*S KotlinDebug\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n*L\n66#1:128,2\n*E\n"})
public final class NotebookBelowCellDelimiterPanel
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final String tooltipText;
    @Nullable
    private final String durationText;
    @Nullable
    private final Integer executionCount;
    @Nullable
    private final Icon statusIcon;
    private final boolean isExecutable;
    @NotNull
    private final List<String> cellTags;
    private final int cellNum;
    @NotNull
    private final NotebookEditorAppearance notebookAppearance;
    private boolean isCollapsed;
    private final int plusTagButtonSize;
    private final int tagsSpacing;
    private final int delimiterHeight;

    public NotebookBelowCellDelimiterPanel(@NotNull EditorImpl editor, @Nls @Nullable String tooltipText, @Nls @Nullable String durationText, @Nullable Integer executionCount, @Nullable Icon statusIcon, boolean isExecutable, @NotNull List<String> cellTags, int cellNum) {
        boolean addingTagsRow;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(cellTags, (String)"cellTags");
        super(new BorderLayout());
        this.editor = editor;
        this.tooltipText = tooltipText;
        this.durationText = durationText;
        this.executionCount = executionCount;
        this.statusIcon = statusIcon;
        this.isExecutable = isExecutable;
        this.cellTags = cellTags;
        this.cellNum = cellNum;
        this.notebookAppearance = NotebookUtilKt.getNotebookAppearance((Editor)this.editor);
        this.isCollapsed = this.getCollapsed();
        this.plusTagButtonSize = JBUI.scale((int)18);
        this.tagsSpacing = JBUI.scale((int)6);
        EditorKind editorKind = this.editor.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        boolean bl = NotebookUtilKt.isDiff(editorKind);
        if (bl) {
            n = NotebookUtilKt.getJupyterCellSpacing((Editor)this.editor) / 2;
        } else if (!bl) {
            n = NotebookUtilKt.getNotebookAppearance((Editor)this.editor).getCellBorderHeight() / 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.delimiterHeight = n;
        this.updateBackgroundColor();
        this.setBorder(BorderFactory.createEmptyBorder(this.delimiterHeight, 0, this.delimiterHeight, 0));
        EditorKind editorKind2 = this.editor.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind2, (String)"getEditorKind(...)");
        boolean addingExecutionLabel = !NotebookUtilKt.isDiff(editorKind2) && this.isExecutable && !this.isCollapsed;
        boolean bl2 = addingTagsRow = !((Collection)this.cellTags).isEmpty() && this.isExecutable && Registry.is((String)"jupyter.cell.metadata.tags", (boolean)false);
        if (addingExecutionLabel) {
            this.add((Component)this.createExecutionLabel(), "West");
        }
        if (addingTagsRow) {
            this.add((Component)this.createTagsRow(), "East");
        }
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final int getCellNum() {
        return this.cellNum;
    }

    private final JLabel createExecutionLabel() {
        JLabel jLabel;
        String string;
        Object executionCountText;
        block5: {
            Object object;
            block4: {
                object = this.executionCount;
                if (object == null) break block4;
                int it = ((Number)object).intValue();
                boolean bl = false;
                Object object2 = it > 0 ? "[" + it + "]" : "";
                object = object2;
                if (object2 != null) break block5;
            }
            object = executionCountText = "";
        }
        if ((string = this.durationText) == null) {
            string = "";
        }
        String durationLabelText = string;
        String labelText = (String)executionCountText + " " + durationLabelText;
        JLabel $this$createExecutionLabel_u24lambda_u241 = jLabel = new JLabel(labelText);
        boolean bl = false;
        $this$createExecutionLabel_u24lambda_u241.setIcon(this.statusIcon);
        $this$createExecutionLabel_u24lambda_u241.setFont(EditorUtil.getEditorFont());
        $this$createExecutionLabel_u24lambda_u241.setForeground(UIUtil.getLabelInfoForeground());
        $this$createExecutionLabel_u24lambda_u241.setToolTipText(this.tooltipText);
        return jLabel;
    }

    private final Box createTagsRow() {
        Box tagsRow = Box.createHorizontalBox();
        JButton plusActionToolbar = this.createAddTagButton();
        tagsRow.add(plusActionToolbar);
        tagsRow.add(Box.createHorizontalStrut(this.tagsSpacing));
        Iterable $this$forEach$iv = this.cellTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tag = (String)element$iv;
            boolean bl = false;
            NotebookCellTagLabel tagLabel = new NotebookCellTagLabel(tag, this.cellNum);
            tagsRow.add(tagLabel);
            tagsRow.add(Box.createHorizontalStrut(this.tagsSpacing));
        }
        Intrinsics.checkNotNull((Object)tagsRow);
        return tagsRow;
    }

    private final JButton createAddTagButton() {
        JButton jButton;
        AnAction anAction = ActionManager.getInstance().getAction("JupyterCellAddTagInlayAction");
        if (anAction == null) {
            return null;
        }
        AnAction action = anAction;
        JButton $this$createAddTagButton_u24lambda_u245 = jButton = new JButton();
        boolean bl = false;
        $this$createAddTagButton_u24lambda_u245.setIcon(AllIcons.Expui.General.Add);
        $this$createAddTagButton_u24lambda_u245.setPreferredSize(new Dimension(this.plusTagButtonSize, this.plusTagButtonSize));
        $this$createAddTagButton_u24lambda_u245.setContentAreaFilled(false);
        $this$createAddTagButton_u24lambda_u245.setFocusPainted(false);
        $this$createAddTagButton_u24lambda_u245.setBorderPainted(false);
        $this$createAddTagButton_u24lambda_u245.setCursor(Cursor.getPredefinedCursor(12));
        $this$createAddTagButton_u24lambda_u245.addActionListener(arg_0 -> NotebookBelowCellDelimiterPanel.createAddTagButton$lambda$5$lambda$4(action, this, arg_0));
        return jButton;
    }

    private final void updateBackgroundColor() {
        Color color;
        boolean bl = this.isExecutable;
        if (bl) {
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            color = this.notebookAppearance.getCodeCellBackground(editorColorsScheme);
            if (color == null) {
                Color color2 = this.editor.getColorsScheme().getDefaultBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
            }
        } else if (!bl) {
            color = this.editor.getColorsScheme().getDefaultBackground();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setBackground(color);
    }

    private final boolean getCollapsed() {
        if (!((Collection)this.cellTags).isEmpty()) {
            return false;
        }
        return !this.isExecutionCountDefined() && (this.tooltipText == null || Intrinsics.areEqual((Object)this.statusIcon, (Object)AllIcons.Expui.General.GreenCheckmark));
    }

    private final boolean isExecutionCountDefined() {
        boolean bl;
        Integer n = this.executionCount;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it > 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void updateUI() {
        if (this.editor == null) {
            return;
        }
        this.updateBackgroundColor();
        super.updateUI();
    }

    private static final Object createAddTagButton$lambda$5$lambda$4$lambda$3(NotebookBelowCellDelimiterPanel this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)CommonDataKeys.EDITOR.getName()) ? this$0.editor : (Intrinsics.areEqual((Object)string, (Object)CommonDataKeys.PROJECT.getName()) ? this$0.editor.getProject() : (Intrinsics.areEqual((Object)string, (Object)PlatformCoreDataKeys.CONTEXT_COMPONENT.getName()) ? this$0 : null));
    }

    private static final void createAddTagButton$lambda$5$lambda$4(AnAction $action, NotebookBelowCellDelimiterPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DataContext dataContext = arg_0 -> NotebookBelowCellDelimiterPanel.createAddTagButton$lambda$5$lambda$4$lambda$3(this$0, arg_0);
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$action, null, (String)"EditorInlay", (DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent event = anActionEvent;
        $action.actionPerformed(event);
    }
}

