/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ImmutableZipFileDataLoader;
import com.intellij.ide.plugins.JavaZipFileDataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.util.plugins.DataLoader;
import com.intellij.platform.util.plugins.LocalFsDataLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0007\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a0\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u001a^\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u001a\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d\u0018\u00010\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001a2\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002\u001a\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020$H\u0007\u001a.\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001d2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u000200\u001a\u001a\u00101\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001aL\u00102\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u0010/\u001a\u000200H\u0002\u001aJ\u00107\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u0010.\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\b\b\u0002\u0010'\u001a\u00020\u0013\u001aL\u00109\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\b\u00104\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0018\u0010;\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0000\u001a\u0018\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u001a\u0010>\u001a\u0004\u0018\u00010*2\u0006\u0010?\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u000bH\u0000\u001aD\u0010@\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010'\u001a\u00020\u0013H\u0002\u001a\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020*0B2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013\u001a\u001e\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00172\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0002\u001a\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00170B2\u0006\u0010G\u001a\u00020\u0017H\u0002\u001a\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020 0B2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006I"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "collectPluginFilesInClassPath", "", "loader", "Ljava/lang/ClassLoader;", "urls", "", "Ljava/net/URL;", "", "computePlatformPluginUrlAndCollectPluginUrls", "platformPrefix", "createPluginLoadingResult", "Lcom/intellij/ide/plugins/PluginLoadingResult;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "fileNameIsLikeVersionedLibraryName", "", "name", "getDescriptorsToMigrate", "dir", "Ljava/nio/file/Path;", "compatibleBuildNumber", "bundledPluginsPath", "brokenPluginVersions", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "pluginsToMigrate", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "incompatiblePlugins", "loadBundledDescriptorsAndDescriptorsFromDir", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "customPluginDir", "bundledPluginDir", "isUnitTestMode", "isRunningFromSources", "loadDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "file", "parentContext", "disabledPlugins", "isBundled", "pathResolver", "Lcom/intellij/ide/plugins/PathResolver;", "loadDescriptorFromArtifact", "loadDescriptorFromDir", "descriptorRelativePath", "pluginPath", "isEssential", "useCoreClassLoader", "loadDescriptorFromFileOrDir", "isDirectory", "loadDescriptorFromJar", "fileName", "loadDescriptors", "loadDescriptorsFromProperty", "result", "loadForCoreEnv", "pluginRoot", "loadFromPluginDir", "loadUncachedDescriptors", "", "putMoreLikelyPluginJarsFirst", "pluginDir", "filesInLibUnderPluginDir", "resolveArchives", "path", "testLoadDescriptorsFromClassPath", "intellij.platform.core.impl"})
@JvmName(name="PluginDescriptorLoader")
@ApiStatus.Internal
public final class PluginDescriptorLoader {
    private static final Logger getLOG() {
        Logger logger = PluginManagerCore.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "PluginManagerCore.getLogger()");
        return logger;
    }

    @NotNull
    public static final PluginLoadingResult createPluginLoadingResult(@Nullable BuildNumber buildNumber) {
        Map<PluginId, Set<String>> map = PluginManagerCore.getBrokenPluginVersions();
        Intrinsics.checkNotNullExpressionValue(map, "PluginManagerCore.getBrokenPluginVersions()");
        return new PluginLoadingResult(map, new Supplier(buildNumber){
            final /* synthetic */ BuildNumber $buildNumber;

            @NotNull
            public final BuildNumber get() {
                BuildNumber buildNumber = this.$buildNumber;
                if (buildNumber == null) {
                    BuildNumber buildNumber2 = PluginManagerCore.getBuildNumber();
                    buildNumber = buildNumber2;
                    Intrinsics.checkNotNullExpressionValue(buildNumber2, "PluginManagerCore.getBuildNumber()");
                }
                return buildNumber;
            }
            {
                this.$buildNumber = buildNumber;
            }
        }, false, 4, null);
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadForCoreEnv(@NotNull Path pluginRoot2, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(pluginRoot2, "pluginRoot");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        PathResolver pathResolver = PluginXmlPathResolver.DEFAULT_PATH_RESOLVER;
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, "DisabledPluginsState.disabledPlugins()");
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(set, null, false, false, false, false, 62, null);
        if (Files.isDirectory(pluginRoot2, new LinkOption[0])) {
            boolean bl = false;
            PathResolver pathResolver2 = pathResolver;
            return PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot2, "META-INF/" + fileName, null, parentContext, true, true, bl, pathResolver2);
        }
        boolean bl = false;
        Path path = null;
        return PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot2, fileName, pathResolver, parentContext, true, true, bl, path);
    }

    private static final IdeaPluginDescriptorImpl loadDescriptorFromDir(Path file2, String descriptorRelativePath, Path pluginPath, DescriptorListLoadingContext context2, boolean isBundled, boolean isEssential, boolean useCoreClassLoader, PathResolver pathResolver) {
        try {
            byte[] input = Files.readAllBytes(file2.resolve(descriptorRelativePath));
            LocalFsDataLoader dataLoader = new LocalFsDataLoader(file2);
            Intrinsics.checkNotNullExpressionValue(input, "input");
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(input, (ReadModuleContext)context2, pathResolver, (DataLoader)dataLoader, null, null, ((Object)file2).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file2;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(raw, path, isBundled, null, null, useCoreClassLoader);
            descriptor2.readExternal(raw, pathResolver, context2, false, dataLoader);
            descriptor2.jarFiles = Collections.singletonList(file2);
            return descriptor2;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e;
            }
            PluginDescriptorLoader.getLOG().warn("Cannot load " + file2.resolve(descriptorRelativePath), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IdeaPluginDescriptorImpl loadDescriptorFromJar(Path file2, String fileName, PathResolver pathResolver, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, boolean useCoreClassLoader, Path pluginPath) {
        Closeable closeable = null;
        try {
            InputStream inputStream;
            DataLoader dataLoader = null;
            ZipFilePool pool = ZipFilePool.POOL;
            if (pool == null || parentContext.transient) {
                ZipFile zipFile2 = new ZipFile(file2.toFile(), StandardCharsets.UTF_8);
                closeable = zipFile2;
                dataLoader = new JavaZipFileDataLoader(zipFile2);
            } else {
                ZipFilePool.EntryResolver entryResolver = pool.load(file2);
                Intrinsics.checkNotNullExpressionValue(entryResolver, "pool.load(file)");
                dataLoader = new ImmutableZipFileDataLoader(entryResolver, file2, pool);
            }
            if (dataLoader.load("META-INF/" + fileName) == null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
                return ideaPluginDescriptorImpl;
            }
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(inputStream, (ReadModuleContext)parentContext, pathResolver, dataLoader, null, null, ((Object)file2).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file2;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(raw, path, isBundled, null, null, useCoreClassLoader);
            descriptor2.readExternal(raw, pathResolver, parentContext, false, dataLoader);
            descriptor2.jarFiles = Collections.singletonList(descriptor2.getPluginPath());
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor2;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e instanceof XMLStreamException ? (Throwable)new RuntimeException("Cannot read " + file2, e) : e;
            }
            parentContext.result.reportCannotLoad(file2, e);
        }
        finally {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        return null;
    }
}

