/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetModel;

import com.intellij.gradle.toolingExtension.impl.model.resourceFilterModel.GradleResourceFilterModelBuilder;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.GradleSourceSetModelBuilder;
import com.intellij.gradle.toolingExtension.impl.util.GradleIdeaPluginUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleObjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
class GradleSourceSetResolutionContext {
    @Nullable
    public final String projectSourceCompatibility;
    @Nullable
    public final String projectTargetCompatibility;
    @NotNull
    public final Collection<SourceSet> testSourceSets;
    public final boolean isIdeaInheritOutputDirs;
    @Nullable
    public final File ideaOutputDir;
    @Nullable
    public final File ideaTestOutputDir;
    @NotNull
    public final Set<File> ideaSourceDirs;
    @NotNull
    public final Set<File> ideaResourceDirs;
    @NotNull
    public final Set<File> ideaTestSourceDirs;
    @NotNull
    public final Set<File> ideaTestResourceDirs;
    @NotNull
    public final Set<File> ideaGeneratedSourceDirs;
    @NotNull
    public final Set<File> unprocessedIdeaGeneratedSourceDirs;
    @NotNull
    public final Set<String> resourcesIncludes;
    @NotNull
    public final Set<String> resourcesExcludes;
    @NotNull
    public final Set<String> testResourcesIncludes;
    @NotNull
    public final Set<String> testResourcesExcludes;
    @NotNull
    public final List<DefaultExternalFilter> resourceFilters;
    @NotNull
    public final List<DefaultExternalFilter> testResourceFilters;

    GradleSourceSetResolutionContext(@NotNull Project project, @NotNull ModelBuilderContext context) {
        if (project == null) {
            GradleSourceSetResolutionContext.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleSourceSetResolutionContext.$$$reportNull$$$0(1);
        }
        this.projectSourceCompatibility = JavaPluginUtil.getSourceCompatibility(project);
        this.projectTargetCompatibility = JavaPluginUtil.getTargetCompatibility(project);
        this.testSourceSets = GradleSourceSetModelBuilder.collectTestSourceSets(project);
        IdeaModule ideaPluginModule = GradleIdeaPluginUtil.getIdeaModule(project);
        if (ideaPluginModule != null) {
            this.isIdeaInheritOutputDirs = GradleObjectUtil.notNull(ideaPluginModule.getInheritOutputDirs(), false);
            this.ideaOutputDir = ideaPluginModule.getOutputDir();
            this.ideaTestOutputDir = ideaPluginModule.getTestOutputDir();
            this.ideaSourceDirs = GradleIdeaPluginUtil.getSourceDirectories(ideaPluginModule);
            this.ideaResourceDirs = GradleIdeaPluginUtil.getResourceDirectories(ideaPluginModule);
            this.ideaTestSourceDirs = GradleIdeaPluginUtil.getTestSourceDirectories(ideaPluginModule);
            this.ideaTestResourceDirs = GradleIdeaPluginUtil.getTestResourceDirectories(ideaPluginModule);
            this.ideaGeneratedSourceDirs = GradleIdeaPluginUtil.getGeneratedSourceDirectories(ideaPluginModule);
        } else {
            this.isIdeaInheritOutputDirs = false;
            this.ideaOutputDir = null;
            this.ideaTestOutputDir = null;
            this.ideaSourceDirs = new LinkedHashSet<File>();
            this.ideaResourceDirs = new LinkedHashSet<File>();
            this.ideaTestSourceDirs = new LinkedHashSet<File>();
            this.ideaTestResourceDirs = new LinkedHashSet<File>();
            this.ideaGeneratedSourceDirs = new LinkedHashSet<File>();
        }
        this.unprocessedIdeaGeneratedSourceDirs = new LinkedHashSet<File>(this.ideaGeneratedSourceDirs);
        this.resourcesIncludes = GradleResourceFilterModelBuilder.getIncludes(project, "processResources");
        this.resourcesExcludes = GradleResourceFilterModelBuilder.getExcludes(project, "processResources");
        this.resourceFilters = GradleResourceFilterModelBuilder.getFilters(project, context, "processResources");
        this.testResourcesIncludes = GradleResourceFilterModelBuilder.getIncludes(project, "processTestResources");
        this.testResourcesExcludes = GradleResourceFilterModelBuilder.getExcludes(project, "processTestResources");
        this.testResourceFilters = GradleResourceFilterModelBuilder.getFilters(project, context, "processTestResources");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetResolutionContext";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

