/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultIntelliJSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J4\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\f\b\u0001\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/IntelliJSettingsBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "canBuild", "", "reportErrorMessage", "", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
public final class IntelliJSettingsBuilder
implements ModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)IntelliJSettings.class.getName());
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Object obj;
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        ExtensionAware extensionAware = (ExtensionAware)(ideaPlugin != null && (ideaPlugin = ideaPlugin.getModel()) != null ? ideaPlugin.getModule() : null);
        if (extensionAware != null && (obj = extensionAware.getExtensions().findByName("settings")) != null) {
            return new DefaultIntelliJSettings(obj.toString());
        }
        return null;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.intellijSettingsModel.group").withKind(Message.Kind.WARNING).withTitle("IntelliJ settings import failure").withText("Unable to build IntelliJ settings").withException(exception).reportMessage(project);
    }
}

