/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.BundleBaseKt;
import com.intellij.IntelliJResourceControl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DefaultBundleService;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B \b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007B\u0014\b\u0014\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0013\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006J%\u0010\u0019\u001a\u00020\u000b2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J-\u0010\u0019\u001a\u00020\u000b2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0005J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u0017H\u0015J8\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"2\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010$\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010%J7\u0010&\u001a\u00070\u0005\u00a2\u0006\u0002\b'2\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010$\"\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0002\u0010(J?\u0010)\u001a\u00070\u0005\u00a2\u0006\u0002\b'2\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010*\u001a\u00020+2\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010$\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010,J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\rH\u0007JH\u0010.\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b'2\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\u0010/\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b'2\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010$\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u00100J5\u00101\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b'2\u000b\u0010\u0018\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010$\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010(R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lcom/intellij/AbstractBundle;", "", "bundleClass", "Ljava/lang/Class;", "pathToBundle", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/Class;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "bundle", "Ljava/lang/ref/Reference;", "Ljava/util/ResourceBundle;", "bundleClassLoader", "Ljava/lang/ClassLoader;", "getBundleClassLoader", "()Ljava/lang/ClassLoader;", "defaultBundle", "resourceBundle", "getResourceBundle", "()Ljava/util/ResourceBundle;", "clearLocaleCache", "", "containsKey", "", "key", "findBundle", "loader", "control", "Ljava/util/ResourceBundle$Control;", "locale", "Ljava/util/Locale;", "getBundle", "isDefault", "getLazyMessage", "Ljava/util/function/Supplier;", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/function/Supplier;", "getMessage", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getPartialMessage", "unassignedParams", "", "(Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "classLoader", "messageOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrNull", "Companion", "intellij.platform.util"})
public class AbstractBundle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Reference<ResourceBundle> bundle;
    @Nullable
    private Reference<ResourceBundle> defaultBundle;
    @NotNull
    private final ClassLoader bundleClassLoader;
    @NotNull
    private final String pathToBundle;

    @ApiStatus.Internal
    @NotNull
    protected final ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    public AbstractBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        Intrinsics.checkNotNullParameter(bundleClass, "bundleClass");
        Intrinsics.checkNotNullParameter(pathToBundle, "pathToBundle");
        this.pathToBundle = pathToBundle;
        ClassLoader classLoader = bundleClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        this.bundleClassLoader = classLoader;
    }

    protected AbstractBundle(@NotNull String pathToBundle) {
        Intrinsics.checkNotNullParameter(pathToBundle, "pathToBundle");
        this.pathToBundle = pathToBundle;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        this.bundleClassLoader = classLoader;
    }

    @Contract(pure=true)
    @NotNull
    public String getMessage(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        return BundleBaseKt.messageOrDefault(this.getResourceBundle(), key, null, params);
    }

    @Contract(pure=true)
    @NotNull
    public final String getPartialMessage(@NotNull String key, int unassignedParams, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        return BundleBase.partialMessage(this.getResourceBundle(), key, unassignedParams, params);
    }

    @NotNull
    public Supplier<String> getLazyMessage(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        Object[] actualParams = params.length == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : params;
        return () -> AbstractBundle.getLazyMessage$lambda$0(this, key, actualParams);
    }

    @Nullable
    public String messageOrNull(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        return Companion.messageOrNull(this.getResourceBundle(), key, Arrays.copyOf(params, params.length));
    }

    @Nullable
    public String messageOrDefault(@NotNull String key, @Nullable String defaultValue, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        return Companion.messageOrDefault(this.getResourceBundle(), key, defaultValue, Arrays.copyOf(params, params.length));
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getResourceBundle().containsKey(key);
    }

    @NotNull
    public final ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.bundleClassLoader);
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        boolean isDefault = DefaultBundleService.isDefaultBundle();
        ResourceBundle bundle = this.getBundle(isDefault);
        if (bundle == null) {
            bundle = Companion.resolveResourceBundleWithFallback(classLoader, this.pathToBundle, (Function0<? extends ResourceBundle>)new Function0<ResourceBundle>(this, classLoader){
                final /* synthetic */ AbstractBundle this$0;
                final /* synthetic */ ClassLoader $classLoader;
                {
                    this.this$0 = $receiver;
                    this.$classLoader = $classLoader;
                    super(0);
                }

                @NotNull
                public final ResourceBundle invoke() {
                    return this.this$0.findBundle(AbstractBundle.access$getPathToBundle$p(this.this$0), this.$classLoader, IntelliJResourceControl.INSTANCE);
                }
            });
            SoftReference<ResourceBundle> ref = new SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.defaultBundle = ref;
            } else {
                this.bundle = ref;
            }
        }
        return bundle;
    }

    @ApiStatus.Internal
    @Nullable
    protected ResourceBundle getBundle(boolean isDefault) {
        Reference<ResourceBundle> reference = isDefault ? this.defaultBundle : this.bundle;
        return reference != null ? reference.get() : null;
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        Intrinsics.checkNotNullParameter(pathToBundle, "pathToBundle");
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(control, "control");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
        return resourceBundle;
    }

    @ApiStatus.Internal
    @NotNull
    protected final ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(pathToBundle, "pathToBundle");
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(locale, "locale");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, locale, loader, control);
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
        return resourceBundle;
    }

    @Deprecated(message="This method is no longer required.\n    The Locale cache now gets cleared automatically after the initialization of the language plugin.")
    public final void clearLocaleCache() {
        block0: {
            Reference<ResourceBundle> reference = this.bundle;
            if (reference == null) break block0;
            reference.clear();
        }
    }

    private static final String getLazyMessage$lambda$0(AbstractBundle this$0, String $key, Object[] $actualParams) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($key, "$key");
        Intrinsics.checkNotNull($actualParams);
        Object[] objectArray = $actualParams;
        return this$0.getMessage($key, Arrays.copyOf(objectArray, objectArray.length));
    }

    @JvmStatic
    @Contract(value="null, _, _, _ -> param3")
    @Nullable
    public static final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        return Companion.messageOrDefault(bundle, key, defaultValue, params);
    }

    @JvmStatic
    @NotNull
    public static final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return Companion.message(bundle, key, params);
    }

    @JvmStatic
    @Nullable
    public static final String messageOrNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return Companion.messageOrNull(bundle, key, params);
    }

    public static final /* synthetic */ String access$getPathToBundle$p(AbstractBundle $this) {
        return $this.pathToBundle;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0010JR\u0010\u0011\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\r2\r\u0010\u0012\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0013J=\u0010\u0014\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/AbstractBundle$Companion;", "", "()V", "control", "Ljava/util/ResourceBundle$Control;", "getControl", "()Ljava/util/ResourceBundle$Control;", "message", "", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "key", "Lorg/jetbrains/annotations/NonNls;", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrNull", "resolveResourceBundleWithFallback", "loader", "Ljava/lang/ClassLoader;", "pathToBundle", "firstTry", "Lkotlin/Function0;", "intellij.platform.util"})
    @SourceDebugExtension(value={"SMAP\nAbstractBundle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n13#2:205\n*S KotlinDebug\n*F\n+ 1 AbstractBundle.kt\ncom/intellij/AbstractBundle$Companion\n*L\n83#1:205\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        @NotNull
        public final ResourceBundle.Control getControl() {
            return IntelliJResourceControl.INSTANCE;
        }

        @JvmStatic
        @Contract(value="null, _, _, _ -> param3")
        @Nullable
        public final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
            String string2;
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(params, "params");
            if (bundle == null) {
                string2 = defaultValue;
            } else if (!bundle.containsKey(key)) {
                String string3 = defaultValue;
                if (string3 == null) {
                    string3 = BundleBaseKt.useDefaultValue(bundle, key);
                }
                string2 = BundleBaseKt.postprocessValue(bundle, string3, params);
            } else {
                string2 = BundleBaseKt.messageOrDefault(bundle, key, defaultValue, params);
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
            Intrinsics.checkNotNullParameter(bundle, "bundle");
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(params, "params");
            return BundleBaseKt.messageOrDefault(bundle, key, null, params);
        }

        @JvmStatic
        @Nullable
        public final String messageOrNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
            Intrinsics.checkNotNullParameter(bundle, "bundle");
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(params, "params");
            String value = this.messageOrDefault(bundle, key, key, Arrays.copyOf(params, params.length));
            return Intrinsics.areEqual(key, value) ? null : value;
        }

        @ApiStatus.Internal
        @NotNull
        public final ResourceBundle resolveResourceBundleWithFallback(@NotNull ClassLoader loader, @NotNull String pathToBundle, @NotNull Function0<? extends ResourceBundle> firstTry) {
            Intrinsics.checkNotNullParameter(loader, "loader");
            Intrinsics.checkNotNullParameter(pathToBundle, "pathToBundle");
            Intrinsics.checkNotNullParameter(firstTry, "firstTry");
            try {
                return firstTry.invoke();
            }
            catch (MissingResourceException e2) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(AbstractBundle.class);
                Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                logger.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
                Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
                return resourceBundle;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

