/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.AbstractBundleKt;
import com.intellij.BundleBase;
import com.intellij.l10n.LocalizationOrder;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    private static final ConcurrentMap<String, ResourceBundle> bundles = CollectionFactory.createConcurrentWeakValueMap();
    private boolean isInitializedBeforeL10n;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
        this.isInitializedBeforeL10n = !LocalizationUtil.INSTANCE.isLocalizationInitialized();
    }

    @ApiStatus.Obsolete
    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
        this.isInitializedBeforeL10n = !LocalizationUtil.INSTANCE.isLocalizationInitialized();
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        return DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, pathToBundle, DynamicBundle.getResolveLocale(), (loader, locale) -> super.findBundle(pathToBundle, (ClassLoader)loader, control, (Locale)locale));
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull String defaultPath, @NotNull Locale locale, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        if (defaultPath == null) {
            DynamicBundle.$$$reportNull$$$0(8);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(9);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(10);
        }
        Path bundlePath = FileSystems.getDefault().getPath(FileUtil.toCanonicalPath(defaultPath, '.'), new String[0]);
        ClassLoader pluginClassLoader = DefaultBundleService.isDefaultBundle() ? null : LocalizationUtil.INSTANCE.getPluginClassLoader(bundleClassLoader);
        List<Path> paths = LocalizationUtil.INSTANCE.getLocalizedPaths(bundlePath, locale);
        HashMap<LocalizationOrder, ResourceBundle> bundleOrderMap = new HashMap<LocalizationOrder, ResourceBundle>();
        if (pluginClassLoader != null) {
            bundleOrderMap.put(LocalizationOrder.DEFAULT_PLUGIN, bundleResolver.apply(pluginClassLoader, Locale.ROOT));
        }
        DynamicBundle.resolveBundleOrder(baseLoader, false, bundlePath, paths, bundleOrderMap, bundleResolver, locale);
        DynamicBundle.reorderParents(bundleOrderMap);
        Optional resourceBundleEntry = bundleOrderMap.entrySet().stream().min(Map.Entry.comparingByKey());
        if (!resourceBundleEntry.isPresent()) {
            throw new RuntimeException("No such resource bundle: " + bundlePath);
        }
        ResourceBundle bundle = (ResourceBundle)resourceBundleEntry.get().getValue();
        bundles.put(defaultPath, bundle);
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(11);
        }
        return resourceBundle;
    }

    @NotNull
    private static List<ResourceBundle> getBundlesFromLocalizationFolder(@NotNull Path pathToBundle, ClassLoader loader, @NotNull Locale locale) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(12);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(13);
        }
        List<Path> paths = LocalizationUtil.INSTANCE.getFolderLocalizedPaths(pathToBundle, locale);
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (Path path : paths) {
            try {
                ResourceBundle resourceBundle = AbstractBundleKt._doResolveBundle(loader, locale, FileUtil.toSystemIndependentName(path.toString()));
                resourceBundles.add(resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (resourceBundles.isEmpty()) {
            LOG.debug("No bundles found in: " + StringUtil.join(paths, ", "));
        }
        ArrayList<ResourceBundle> arrayList = resourceBundles;
        if (arrayList == null) {
            DynamicBundle.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static ResourceBundle getParent(@NotNull ResourceBundle bundle) throws Throwable {
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(15);
        }
        return (ResourceBundle)DynamicBundleInternal.GET_PARENT.invokeWithArguments(bundle);
    }

    private static void resolveBundleOrder(@NotNull ClassLoader loader, boolean isPluginClassLoader, @NotNull Path pathToBundle, @NotNull List<? extends Path> orderedPaths, @NotNull Map<? super LocalizationOrder, ? super ResourceBundle> bundleOrderMap, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, ? super Locale, ? extends @NotNull ResourceBundle> bundleResolver, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(16);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(17);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(18);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(19);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(20);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(21);
        }
        ResourceBundle bundle = bundleResolver.apply(loader, locale);
        try {
            while (bundle != null) {
                DynamicBundle.putBundleOrder(bundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
                bundle = DynamicBundle.getParent(bundle);
            }
        }
        catch (Throwable throwable) {
            LOG.info(throwable);
        }
        for (ResourceBundle localizedBundle : DynamicBundle.getBundlesFromLocalizationFolder(pathToBundle, loader, locale)) {
            DynamicBundle.putBundleOrder(localizedBundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
        }
    }

    private static void putBundleOrder(@NotNull ResourceBundle bundle, @NotNull Map<? super LocalizationOrder, ? super ResourceBundle> bundleOrderMap, @NotNull List<? extends Path> orderedPaths, boolean isPluginClassLoader) {
        if (bundle == null) {
            DynamicBundle.$$$reportNull$$$0(22);
        }
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(23);
        }
        if (orderedPaths == null) {
            DynamicBundle.$$$reportNull$$$0(24);
        }
        String bundlePath = FileUtil.toCanonicalPath(bundle.getBaseBundleName(), '.');
        if (isPluginClassLoader) {
            bundleOrderMap.put(LocalizationOrder.DEFAULT_PLUGIN, bundle);
        } else {
            Path path;
            LocalizationOrder localizationOrder;
            if (!bundle.getLocale().toString().isEmpty()) {
                bundlePath = bundlePath + "_" + bundle.getLocale().toString();
            }
            if ((localizationOrder = LocalizationOrder.Companion.getLocalizationOrder(orderedPaths, path = FileSystems.getDefault().getPath(bundlePath, new String[0]))) == null) {
                LOG.debug("Order cannot be defined for the bundle: " + path + "; Current locale: " + DynamicBundle.getLocale() + "; Paths for locale: " + orderedPaths);
                return;
            }
            bundleOrderMap.put(localizationOrder, bundle);
        }
    }

    private static void reorderParents(@NotNull Map<LocalizationOrder, ResourceBundle> bundleOrderMap) {
        if (bundleOrderMap == null) {
            DynamicBundle.$$$reportNull$$$0(25);
        }
        ResourceBundle resourceBundle = null;
        for (LocalizationOrder localizationOrder : LocalizationOrder.getEntries()) {
            ResourceBundle parentBundle = bundleOrderMap.get((Object)localizationOrder);
            if (parentBundle == null || parentBundle == resourceBundle) continue;
            if (resourceBundle != null) {
                try {
                    DynamicBundleInternal.SET_PARENT.bindTo(resourceBundle).invoke(parentBundle);
                }
                catch (Throwable e2) {
                    LOG.warn(e2);
                }
            }
            resourceBundle = parentBundle;
        }
    }

    @Override
    @ApiStatus.Internal
    protected ResourceBundle getBundle(boolean isDefault) {
        if (!isDefault && LocalizationUtil.INSTANCE.isLocalizationInitialized() && this.isInitializedBeforeL10n) {
            this.isInitializedBeforeL10n = false;
            return null;
        }
        return super.getBundle(isDefault);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(26);
        }
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(27);
        }
        return DynamicBundle.getResourceBundle(loader, pathToBundle);
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(28);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(29);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, DynamicBundle.getResolveLocale()));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(30);
        }
        return resourceBundle;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader, @NotNull @NonNls String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(31);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(32);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(33);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader, pathToBundle, locale));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(34);
        }
        return resourceBundle;
    }

    @Nullable
    public static ResourceBundle getPluginBundle(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DynamicBundle.$$$reportNull$$$0(35);
        }
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        String baseName = pluginDescriptor.getResourceBundleBaseName();
        return classLoader != null && baseName != null ? DynamicBundle.getResourceBundle(classLoader, baseName) : null;
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader, @NonNls @NotNull String pathToBundle, @NotNull Locale locale) {
        if (loader == null) {
            DynamicBundle.$$$reportNull$$$0(36);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(37);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(38);
        }
        ResourceBundle resourceBundle = Companion.resolveResourceBundleWithFallback(loader, pathToBundle, () -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader, pathToBundle, locale, DynamicBundle.bundleResolver(pathToBundle)));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(39);
        }
        return resourceBundle;
    }

    @NotNull
    private static @NotNull BiFunction<@NotNull ClassLoader, @NotNull Locale, @NotNull ResourceBundle> bundleResolver(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(40);
        }
        BiFunction<ClassLoader, Locale, ResourceBundle> biFunction = (loader, locale) -> AbstractBundleKt._doResolveBundle(loader, locale, pathToBundle);
        if (biFunction == null) {
            DynamicBundle.$$$reportNull$$$0(41);
        }
        return biFunction;
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class<?> callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(42);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass(2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(43);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(44);
        }
        final ResourceBundle rb = DynamicBundle.getResourceBundle(formClass.getClassLoader(), baseName);
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object get = rb.getObject(key);
                assert (get instanceof String) : "Language bundles should contain only strings";
                return BundleBase.INSTANCE.appendLocalizationSuffix((String)get, "\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = rb.getKeys();
                if (enumeration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return enumeration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleGetObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static Locale getLocale() {
        Locale locale = LocalizationUtil.INSTANCE.getLocale();
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(45);
        }
        return locale;
    }

    @NotNull
    private static Locale getResolveLocale() {
        Locale resolveLocale = DynamicBundle.getLocale();
        Locale locale = resolveLocale.equals(Locale.ENGLISH) ? Locale.ROOT : resolveLocale;
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(46);
        }
        return locale;
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable Map<String, ResourceBundle> getResourceBundles() {
        Map<String, ResourceBundle> map2 = Collections.unmodifiableMap(bundles);
        if (map2 == null) {
            DynamicBundle.$$$reportNull$$$0(47);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 17: 
            case 26: 
            case 29: 
            case 32: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClassLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
            case 9: 
            case 13: 
            case 21: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleResolver";
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/DynamicBundle";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 16: 
            case 27: 
            case 28: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderedPaths";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleOrderMap";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/DynamicBundle";
                break;
            }
            case 11: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "bundleResolver";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveLocale";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundlesFromLocalizationFolder";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundleOrder";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putBundleOrder";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reorderParents";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPluginBundle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "bundleResolver";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 14: 
            case 30: 
            case 34: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DynamicBundleInternal {
        @NotNull
        private static final MethodHandle SET_PARENT;
        @NotNull
        private static final MethodHandle GET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
                Field parentField = ResourceBundle.class.getDeclaredField("parent");
                parentField.setAccessible(true);
                GET_PARENT = MethodHandles.lookup().unreflectGetter(parentField);
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        @Attribute(value="displayName")
        public String displayName;
        public PluginDescriptor pluginDescriptor;

        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }
}

