/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenSet {
    public static final TokenSet EMPTY = new TokenSet((short)Short.MAX_VALUE, 0, null);
    public static final TokenSet ANY = TokenSet.forAllMatching(IElementType.TRUE);
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    @Nullable
    private final IElementType.Predicate myOrCondition;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max, @Nullable IElementType.Predicate orCondition) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
        this.myOrCondition = orCondition;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    @Contract(value="null -> false", pure=true)
    public boolean contains(@Nullable IElementType t2) {
        if (t2 == null) {
            return false;
        }
        short i2 = t2.getIndex();
        return 0 <= i2 && i2 <= this.myMax && this.get(i2) || this.myOrCondition != null && this.myOrCondition.matches(t2);
    }

    public IElementType @NotNull [] getTypes() {
        if (this.myOrCondition != null) {
            IElementType[] iElementTypeArray = IElementType.enumerate(this::contains);
            if (iElementTypeArray == null) {
                TokenSet.$$$reportNull$$$0(0);
            }
            return iElementTypeArray;
        }
        IElementType[] types = this.myTypes;
        if (types == null) {
            if (this.myWords.length == 0) {
                types = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i2 = (short)Math.max(1, this.myShift << 6); i2 <= this.myMax; i2 = (short)(i2 + 1)) {
                    IElementType type2;
                    if (!this.get(i2) || (type2 = IElementType.find(i2)) == null) continue;
                    list.add(type2);
                }
                types = list.toArray(IElementType.EMPTY_ARRAY);
            }
            this.myTypes = types;
        }
        if (types == null) {
            TokenSet.$$$reportNull$$$0(1);
        }
        return types;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types) {
        if (types == null) {
            TokenSet.$$$reportNull$$$0(2);
        }
        if (types.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(3);
            }
            return tokenSet;
        }
        if (types.length == 1 && types[0] == TokenType.WHITE_SPACE) {
            TokenSet tokenSet = WHITE_SPACE;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(4);
            }
            return tokenSet;
        }
        return TokenSet.doCreate(types);
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types) {
        short s2;
        if (types == null) {
            TokenSet.$$$reportNull$$$0(5);
        }
        int n2 = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type2 : types) {
            if (type2 == null) continue;
            short index = type2.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + ObjectUtils.objectInfo(type2);
            if (s2 > index) {
                s2 = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(s2 >> 6);
        TokenSet set = new TokenSet(shift, max, null);
        for (IElementType type3 : types) {
            int wordIndex;
            if (type3 == null) continue;
            short index = type3.getIndex();
            int n3 = wordIndex = (index >> 6) - shift;
            set.myWords[n3] = set.myWords[n3] | 1L << index;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(6);
        }
        return tokenSet;
    }

    public static TokenSet forAllMatching(@NotNull IElementType.Predicate condition) {
        if (condition == null) {
            TokenSet.$$$reportNull$$$0(7);
        }
        return new TokenSet((short)Short.MAX_VALUE, 0, condition);
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            TokenSet.$$$reportNull$$$0(8);
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(9);
            }
            return tokenSet;
        }
        ArrayList<IElementType.Predicate> orConditions = new ArrayList<IElementType.Predicate>();
        ContainerUtil.addIfNotNull(orConditions, sets[0].myOrCondition);
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i2 = 1; i2 < sets.length; ++i2) {
            if (shift > sets[i2].myShift) {
                shift = sets[i2].myShift;
            }
            if (max < sets[i2].myMax) {
                max = sets[i2].myMax;
            }
            ContainerUtil.addIfNotNull(orConditions, sets[i2].myOrCondition);
        }
        OrPredicate disjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : new OrPredicate(orConditions));
        TokenSet newSet = new TokenSet(shift, max, disjunction);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i3 = 0; i3 < set.myWords.length; ++i3) {
                int n2 = i3 + shiftDiff;
                newSet.myWords[n2] = newSet.myWords[n2] | set.myWords[i3];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(10);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a2, @NotNull TokenSet b2) {
        if (a2 == null) {
            TokenSet.$$$reportNull$$$0(11);
        }
        if (b2 == null) {
            TokenSet.$$$reportNull$$$0(12);
        }
        ArrayList orConditions = new ArrayList();
        ContainerUtil.addIfNotNull(orConditions, a2.myOrCondition);
        ContainerUtil.addIfNotNull(orConditions, b2.myOrCondition);
        IElementType.Predicate conjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : t2 -> Objects.requireNonNull(a2.myOrCondition).matches(t2) && Objects.requireNonNull(b2.myOrCondition).matches(t2));
        TokenSet newSet = new TokenSet((short)Math.min(a2.myShift, b2.myShift), (short)Math.max(a2.myMax, b2.myMax), conjunction);
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai2 = newSet.myShift - a2.myShift + i2;
            int bi2 = newSet.myShift - b2.myShift + i2;
            newSet.myWords[i2] = (0 <= ai2 && ai2 < a2.myWords.length ? a2.myWords[ai2] : 0L) & (0 <= bi2 && bi2 < b2.myWords.length ? b2.myWords[bi2] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(13);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a2, @NotNull TokenSet b2) {
        if (a2 == null) {
            TokenSet.$$$reportNull$$$0(14);
        }
        if (b2 == null) {
            TokenSet.$$$reportNull$$$0(15);
        }
        IElementType.Predicate difference = a2.myOrCondition == null ? null : e2 -> !b2.contains(e2) && a2.myOrCondition.matches(e2);
        TokenSet newSet = new TokenSet((short)Math.min(a2.myShift, b2.myShift), (short)Math.max(a2.myMax, b2.myMax), difference);
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai2 = newSet.myShift - a2.myShift + i2;
            int bi2 = newSet.myShift - b2.myShift + i2;
            newSet.myWords[i2] = (0 <= ai2 && ai2 < a2.myWords.length ? a2.myWords[ai2] : 0L) & ((0 <= bi2 && bi2 < b2.myWords.length ? b2.myWords[bi2] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(16);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/TokenSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "orSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "andSet";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forAllMatching";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orSet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "andSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "andNot";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrPredicate
    implements IElementType.Predicate {
        private final IElementType.Predicate[] myComponents;

        OrPredicate(List<IElementType.Predicate> components) {
            this.myComponents = (IElementType.Predicate[])components.stream().flatMap(p2 -> p2 instanceof OrPredicate ? Arrays.stream(((OrPredicate)p2).myComponents) : Stream.of(p2)).distinct().toArray(IElementType.Predicate[]::new);
        }

        @Override
        public boolean matches(@NotNull IElementType t2) {
            if (t2 == null) {
                OrPredicate.$$$reportNull$$$0(0);
            }
            for (IElementType.Predicate component : this.myComponents) {
                if (!component.matches(t2)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/tree/TokenSet$OrPredicate", "matches"));
        }
    }
}

