/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001\u001bBW\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019R&\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/indexing/impl/MapIndexStorageCaffeineCache;", "Key", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictionListener", "Ljava/util/function/BiConsumer;", "offloadIO", "", "equalityPolicy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;ZLcom/intellij/util/containers/hash/EqualityPolicy;I)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCaffeineCache$KeyWithCustomEquality;", "getCachedValues", "", "invalidateAll", "", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "KeyWithCustomEquality", "intellij.platform.util"})
final class MapIndexStorageCaffeineCache<Key, Value>
implements MapIndexStorageCache<Key, Value> {
    @NotNull
    private final EqualityPolicy<Key> equalityPolicy;
    @NotNull
    private final LoadingCache<KeyWithCustomEquality<Key>, ChangeTrackingValueContainer<Value>> cache;

    public MapIndexStorageCaffeineCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictionListener, boolean offloadIO, @NotNull EqualityPolicy<Key> equalityPolicy, int cacheSize) {
        Intrinsics.checkNotNullParameter(valueReader, "valueReader");
        Intrinsics.checkNotNullParameter(evictionListener, "evictionListener");
        Intrinsics.checkNotNullParameter(equalityPolicy, "equalityPolicy");
        this.equalityPolicy = equalityPolicy;
        CacheLoader valuesLoader = arg_0 -> MapIndexStorageCaffeineCache._init_$lambda$0(valueReader, arg_0);
        RemovalListener onEvict = (arg_0, arg_1, arg_2) -> MapIndexStorageCaffeineCache._init_$lambda$1(evictionListener, arg_0, arg_1, arg_2);
        Executor evictionExecutor = offloadIO ? ExecutorsKt.asExecutor(Dispatchers.getIO()) : MapIndexStorageCaffeineCache::_init_$lambda$2;
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize((long)cacheSize).executor(evictionExecutor).removalListener(onEvict).build(valuesLoader);
        Intrinsics.checkNotNullExpressionValue(loadingCache, "build(...)");
        this.cache = loadingCache;
    }

    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) {
        Object object = this.cache.get(new KeyWithCustomEquality<Key>(key, this.equalityPolicy));
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        return (ChangeTrackingValueContainer)object;
    }

    @Override
    @Nullable
    public ChangeTrackingValueContainer<Value> readIfCached(Key key) {
        return (ChangeTrackingValueContainer)this.cache.getIfPresent(new KeyWithCustomEquality<Key>(key, this.equalityPolicy));
    }

    @Override
    @NotNull
    public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
        return this.cache.asMap().values();
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    private static final ChangeTrackingValueContainer _init_$lambda$0(Function $valueReader, KeyWithCustomEquality wrappedKey) {
        Intrinsics.checkNotNullParameter($valueReader, "$valueReader");
        return (ChangeTrackingValueContainer)$valueReader.apply(wrappedKey.getKey());
    }

    private static final void _init_$lambda$1(BiConsumer $evictionListener, KeyWithCustomEquality wrappedKey, ChangeTrackingValueContainer container, RemovalCause cause) {
        Intrinsics.checkNotNullParameter($evictionListener, "$evictionListener");
        if (container != null && wrappedKey != null) {
            $evictionListener.accept(wrappedKey.getKey(), container);
        }
    }

    private static final void _init_$lambda$2(Runnable it) {
        it.run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/impl/MapIndexStorageCaffeineCache$KeyWithCustomEquality;", "K", "", "key", "equality", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "(Ljava/lang/Object;Lcom/intellij/util/containers/hash/EqualityPolicy;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "intellij.platform.util"})
    private static final class KeyWithCustomEquality<K> {
        private final K key;
        @NotNull
        private final EqualityPolicy<K> equality;

        public KeyWithCustomEquality(K key, @NotNull EqualityPolicy<K> equality) {
            Intrinsics.checkNotNullParameter(equality, "equality");
            this.key = key;
            this.equality = equality;
        }

        public final K getKey() {
            return this.key;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.util.indexing.impl.MapIndexStorageCaffeineCache.KeyWithCustomEquality<K of com.intellij.util.indexing.impl.MapIndexStorageCaffeineCache.KeyWithCustomEquality>");
            KeyWithCustomEquality cfr_ignored_0 = (KeyWithCustomEquality)other;
            return this.equality.isEqual(this.key, ((KeyWithCustomEquality)other).key);
        }

        public int hashCode() {
            return this.equality.getHashCode(this.key);
        }
    }
}

