/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.sisu.bean.BeanLifecycle;

final class LifecycleBuilder {
    private final List<Method> startMethods = new ArrayList<Method>();
    private final List<Method> stopMethods = new ArrayList<Method>();
    private final List<Class<?>> hierarchy = new ArrayList();

    LifecycleBuilder() {
    }

    public synchronized BeanLifecycle build(Class<?> clazz) {
        try {
            Class<?> c2 = clazz;
            while (c2 != null && c2 != Object.class) {
                this.addLifecycleMethods(c2);
                c2 = c2.getSuperclass();
            }
            if (this.startMethods.isEmpty() && this.stopMethods.isEmpty()) {
                BeanLifecycle beanLifecycle = BeanLifecycle.NO_OP;
                return beanLifecycle;
            }
            BeanLifecycle beanLifecycle = new BeanLifecycle(this.startMethods, this.stopMethods);
            return beanLifecycle;
        }
        finally {
            this.startMethods.clear();
            this.stopMethods.clear();
            this.hierarchy.clear();
        }
    }

    private void addLifecycleMethods(Class<?> clazz) {
        boolean foundStartMethod = false;
        boolean foundStopMethod = false;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Method m2 = methodArray[n3];
            if (LifecycleBuilder.isCandidateMethod(m2)) {
                if (m2.isAnnotationPresent(PostConstruct.class)) {
                    foundStartMethod = true;
                    if (!this.isOverridden(m2)) {
                        this.startMethods.add(m2);
                    }
                } else if (m2.isAnnotationPresent(PreDestroy.class)) {
                    foundStopMethod = true;
                    if (!this.isOverridden(m2)) {
                        this.stopMethods.add(m2);
                    }
                }
                if (foundStartMethod && foundStopMethod) break;
            }
            ++n3;
        }
        this.hierarchy.add(clazz);
    }

    private boolean isOverridden(Method method) {
        String name = method.getName();
        int i2 = this.hierarchy.size() - 1;
        while (i2 >= 0) {
            Method[] methodArray = this.hierarchy.get(i2).getDeclaredMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method m2 = methodArray[n3];
                if (name.equals(m2.getName()) && LifecycleBuilder.isCandidateMethod(m2)) {
                    int modifiers = m2.getModifiers();
                    if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && (Modifier.isPrivate(modifiers) || !LifecycleBuilder.samePackage(method, m2))) break;
                    return true;
                }
                ++n3;
            }
            --i2;
        }
        return false;
    }

    private static boolean isCandidateMethod(Method method) {
        int modifiers;
        if (!(method.getReturnType() != Void.TYPE || Modifier.isStatic(modifiers = method.getModifiers()) || Modifier.isAbstract(modifiers) || method.isSynthetic())) {
            return method.getParameterTypes().length == 0;
        }
        return false;
    }

    private static boolean samePackage(Method lhs, Method rhs) {
        return lhs.getDeclaringClass().getPackage().equals(rhs.getDeclaringClass().getPackage());
    }
}

