/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00102\u00060\u0001j\u0002`\u0002:\u0001\u0010B\u0011\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "timestamp", "", "getTimestamp", "()J", "wasStartedInLimitedSetup", "", "getWasStartedInLimitedSetup", "()Z", "Companion", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$DaemonAnalysisStarted;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$EditorEdited;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$EditorOpened;", "intellij.performanceTesting"})
abstract class ExceptionWithTime
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String message;
    private final long timestamp;

    private ExceptionWithTime(String message) {
        super(message);
        this.message = message;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public abstract boolean getWasStartedInLimitedSetup();

    public /* synthetic */ ExceptionWithTime(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u0006\u0010\u0005\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion;", "", "()V", "createForAnalysisStart", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "isStartedInDumbMode", "", "createForEditedEditor", "fileEditor", "createForOpenedEditor", "createIntersectionErrorIfNeeded", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "previousSessionStartTrace", "getLogHighlightingMessage", "", "currentTime", "", "exceptionWithTime", "markAnalysisFinished", "", "DaemonAnalysisStarted", "EditorEdited", "EditorOpened", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExceptionWithTime createForOpenedEditor(@NotNull TextEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return new EditorOpened(editor2);
        }

        @NotNull
        public final ExceptionWithTime createForEditedEditor(@NotNull TextEditor fileEditor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            return new EditorEdited(fileEditor);
        }

        @NotNull
        public final ExceptionWithTime createForAnalysisStart(@NotNull TextEditor editor2, boolean isStartedInDumbMode2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return new DaemonAnalysisStarted(editor2, isStartedInDumbMode2);
        }

        public final void markAnalysisFinished(@Nullable ExceptionWithTime exceptionWithTime) {
            block0: {
                DaemonAnalysisStarted daemonAnalysisStarted = exceptionWithTime instanceof DaemonAnalysisStarted ? (DaemonAnalysisStarted)exceptionWithTime : null;
                if (daemonAnalysisStarted == null) break block0;
                daemonAnalysisStarted.markAnalysisFinished();
            }
        }

        @NotNull
        public final String getLogHighlightingMessage(long currentTime, @NotNull TextEditor editor2, @Nullable ExceptionWithTime exceptionWithTime) {
            String string;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ExceptionWithTime exceptionWithTime2 = exceptionWithTime;
            if (exceptionWithTime2 == null) {
                string = "Editor " + editor2 + " wasn't opened, and highlighting didn't start, but it finished, and the editor was highlighted";
            } else if (exceptionWithTime2 instanceof DaemonAnalysisStarted) {
                string = "Total highlighting time is : " + (currentTime - ((DaemonAnalysisStarted)exceptionWithTime).getTimestamp()) + " ms for " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2);
            } else if (exceptionWithTime2 instanceof EditorOpened) {
                string = "Total time from opening to highlighting is : " + (currentTime - ((EditorOpened)exceptionWithTime).getTimestamp()) + " ms; \ndaemon start was not reported for editor " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2);
            } else if (exceptionWithTime2 instanceof EditorEdited) {
                string = "Total time from editing to highlighting is : " + (currentTime - ((EditorEdited)exceptionWithTime).getTimestamp()) + " ms; \ndaemon start was not reported for editor " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Nullable
        public final AssertionError createIntersectionErrorIfNeeded(@NotNull FileEditor editor2, @Nullable ExceptionWithTime previousSessionStartTrace) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (previousSessionStartTrace instanceof DaemonAnalysisStarted && ((DaemonAnalysisStarted)previousSessionStartTrace).isNotFinished()) {
                AssertionError err = new AssertionError((Object)"Overlapping highlighting sessions");
                ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)new Exception("Current daemon start trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription(editor2) + " )"));
                ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)previousSessionStartTrace);
                return err;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$DaemonAnalysisStarted;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "wasStartedInLimitedSetup", "", "(Lcom/intellij/openapi/fileEditor/TextEditor;Z)V", "analysisFinished", "getWasStartedInLimitedSetup", "()Z", "isNotFinished", "markAnalysisFinished", "", "intellij.performanceTesting"})
        private static final class DaemonAnalysisStarted
        extends ExceptionWithTime {
            private final boolean wasStartedInLimitedSetup;
            private boolean analysisFinished;

            public DaemonAnalysisStarted(@NotNull TextEditor editor2, boolean wasStartedInLimitedSetup) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                super("Previous daemon start trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2) + ")", (DefaultConstructorMarker)null);
                this.wasStartedInLimitedSetup = wasStartedInLimitedSetup;
            }

            @Override
            public boolean getWasStartedInLimitedSetup() {
                return this.wasStartedInLimitedSetup;
            }

            public final void markAnalysisFinished() {
                this.analysisFinished = true;
            }

            public final boolean isNotFinished() {
                return !this.analysisFinished;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$EditorEdited;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "wasStartedInLimitedSetup", "", "getWasStartedInLimitedSetup", "()Z", "intellij.performanceTesting"})
        private static final class EditorEdited
        extends ExceptionWithTime {
            public EditorEdited(@NotNull TextEditor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                super("Previous editor edited trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2) + ")", (DefaultConstructorMarker)null);
            }

            @Override
            public boolean getWasStartedInLimitedSetup() {
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime$Companion$EditorOpened;", "Lcom/jetbrains/performancePlugin/commands/ExceptionWithTime;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "wasStartedInLimitedSetup", "", "getWasStartedInLimitedSetup", "()Z", "intellij.performanceTesting"})
        private static final class EditorOpened
        extends ExceptionWithTime {
            public EditorOpened(@NotNull TextEditor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                super("Previous editor opening trace (editor = " + WaitForFinishedCodeAnalysisKt.access$getDescription((FileEditor)editor2) + ")", (DefaultConstructorMarker)null);
            }

            @Override
            public boolean getWasStartedInLimitedSetup() {
                return true;
            }
        }
    }
}

