/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImplKt;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.commands.OpenFileCommandOptions;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerListener;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerResult;
import com.sampullara.cli.Args;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014J,\u0010\r\u001a\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0018\u00010\u0003\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/OpenFileCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "setFilePath", "projectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NonNls;", "span", "Lio/opentelemetry/api/trace/Span;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nOpenFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFileCommand.kt\ncom/jetbrains/performancePlugin/commands/OpenFileCommand\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,103:1\n72#2:104\n*S KotlinDebug\n*F\n+ 1 OpenFileCommand.kt\ncom/jetbrains/performancePlugin/commands/OpenFileCommand\n*L\n79#1:104\n*E\n"})
public final class OpenFileCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "openFile";
    @NotNull
    public static final String PREFIX = "%openFile";
    @NotNull
    public static final String SPAN_NAME = "firstCodeAnalysis";

    public OpenFileCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @Override
    @NotNull
    protected String getName() {
        return NAME;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof doExecute.1)) ** GOTO lbl-1000
        var19_3 = var2_2;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ OpenFileCommand this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doExecute(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                arguments = this.extractCommandArgument("%openFile");
                Intrinsics.checkNotNull((Object)arguments);
                v0 = options = OpenFileCommand.Companion.getOptions(arguments);
                v1 = v0 != null ? v0.file : null;
                if (v1 == null) {
                    v2 = this.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                    var7_8 = new char[]{' '};
                    v1 = (String)StringsKt.split$default((CharSequence)v2, (char[])var7_8, (boolean)false, (int)4, (int)2, null).get(1);
                }
                filePath = StringsKt.replace$default((String)v1, (String)"SPACE_SYMBOL", (String)" ", (boolean)false, (int)4, null);
                v3 = options;
                v4 = v3 != null ? v3.timeout : null;
                timeout = v4 == null ? 0L : v4;
                v5 = options;
                v6 = v5 != null ? v5.suppressErrors : null;
                suppressErrors = v6 == null ? false : v6;
                var10_12 = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)var10_12, (String)"getProject(...)");
                project = var10_12;
                v7 = OpenFileCommand.Companion.findFile(filePath, project);
                if (v7 == null) {
                    var13_14 = new Object[]{filePath};
                    v8 = PerformanceTestingBundle.message("command.file.not.found", var13_14);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"message(...)");
                    var12_16 = v8;
                    throw new IllegalStateException(var12_16.toString());
                }
                file = v7;
                connection = project.getMessageBus().simpleConnect();
                spanRef = new Ref();
                projectPath = project.getBasePath();
                job = DaemonCodeAnalyzerListener.listen$default(DaemonCodeAnalyzerListener.INSTANCE, connection, spanRef, timeout, null, 8, null);
                if (suppressErrors) {
                    job.suppressErrors();
                }
                spanRef.set((Object)this.startSpan("firstCodeAnalysis"));
                var15_20 = spanRef.get();
                Intrinsics.checkNotNullExpressionValue((Object)var15_20, (String)"get(...)");
                this.setFilePath(projectPath, (Span)var15_20, file);
                $continuation.L$0 = options;
                $continuation.L$1 = project;
                $continuation.L$2 = file;
                $continuation.L$3 = spanRef;
                $continuation.L$4 = job;
                $continuation.J$0 = timeout;
                $continuation.label = 1;
                v9 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                    int label;
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ProjectUtil.focusProjectWindow((Project)this.$project, (boolean)true);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v9 == var20_5) {
                    return var20_5;
                }
                ** GOTO lbl69
            }
            case 1: {
                timeout = $continuation.J$0;
                job = (DaemonCodeAnalyzerResult)$continuation.L$4;
                spanRef = (Ref)$continuation.L$3;
                file = (VirtualFile)$continuation.L$2;
                project = (Project)$continuation.L$1;
                options = (OpenFileCommandOptions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl69:
                // 2 sources

                $this$serviceAsync$iv = (ComponentManager)project;
                $i$f$serviceAsync = false;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = options;
                $continuation.L$1 = file;
                $continuation.L$2 = spanRef;
                $continuation.L$3 = job;
                $continuation.L$4 = null;
                $continuation.J$0 = timeout;
                $continuation.label = 2;
                v10 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(FileEditorManager.class, (Continuation)$continuation);
                if (v10 == var20_5) {
                    return var20_5;
                }
                ** GOTO lbl93
            }
            case 2: {
                $i$f$serviceAsync = false;
                timeout = $continuation.J$0;
                job = (DaemonCodeAnalyzerResult)$continuation.L$3;
                spanRef = (Ref)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                options = (OpenFileCommandOptions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl93:
                // 2 sources

                Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.ex.FileEditorManagerEx");
                $continuation.L$0 = options;
                $continuation.L$1 = file;
                $continuation.L$2 = spanRef;
                $continuation.L$3 = job;
                $continuation.J$0 = timeout;
                $continuation.label = 3;
                v11 = ((FileEditorManagerEx)v10).openFile(file, new FileEditorOpenOptions(false, false, false, true, false, 0, false, null, false, 503, null), (Continuation)$continuation);
                if (v11 == var20_5) {
                    return var20_5;
                }
                ** GOTO lbl112
            }
            case 3: {
                timeout = $continuation.J$0;
                job = (DaemonCodeAnalyzerResult)$continuation.L$3;
                spanRef = (Ref)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                options = (OpenFileCommandOptions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl112:
                // 2 sources

                fileEditor = (FileEditorComposite)v11;
                if (options != null && !options.disableCodeAnalysis.booleanValue()) {
                    $continuation.L$0 = options;
                    $continuation.L$1 = file;
                    $continuation.L$2 = spanRef;
                    $continuation.L$3 = job;
                    $continuation.J$0 = timeout;
                    $continuation.label = 4;
                    v12 = FileEditorManagerImplKt.waitForFullyCompleted((FileEditorComposite)fileEditor, (Continuation)$continuation);
                    if (v12 == var20_5) {
                        return var20_5;
                    }
                }
                ** GOTO lbl132
            }
            case 4: {
                timeout = $continuation.J$0;
                job = (DaemonCodeAnalyzerResult)$continuation.L$3;
                spanRef = (Ref)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                options = (OpenFileCommandOptions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl132:
                // 2 sources

                job.onError((Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>((Ref<Span>)spanRef){
                    final /* synthetic */ Ref<Span> $spanRef;
                    {
                        this.$spanRef = $spanRef;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Span span = (Span)this.$spanRef.get();
                            if (span == null) break block0;
                            span.setAttribute("timeout", "true");
                        }
                    }
                }));
                job.withErrorMessage("Timeout on open file " + file.getPath() + " more than " + timeout + " seconds");
                if (options == null || options.disableCodeAnalysis.booleanValue()) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 5;
                v13 = job.waitForComplete((Continuation<? super Unit>)$continuation);
                if (v13 == var20_5) {
                    return var20_5;
                }
                ** GOTO lbl147
            }
            case 5: {
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl147:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setFilePath(String projectPath, Span span, VirtualFile file) {
        if (projectPath != null) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            span.setAttribute("filePath", StringsKt.replaceFirst$default((String)string, (String)projectPath, (String)"", (boolean)false, (int)4, null));
        } else {
            span.setAttribute("filePath", file.getPath());
        }
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findFile(@NotNull String filePath, @NotNull Project project) {
        return Companion.findFile(filePath, project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/performancePlugin/commands/OpenFileCommand$Companion;", "", "()V", "NAME", "", "Lorg/jetbrains/annotations/NonNls;", "PREFIX", "SPAN_NAME", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "project", "Lcom/intellij/openapi/project/Project;", "getOptions", "Lcom/jetbrains/performancePlugin/commands/OpenFileCommandOptions;", "arguments", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nOpenFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFileCommand.kt\ncom/jetbrains/performancePlugin/commands/OpenFileCommand$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n1#2:104\n37#3,2:105\n*S KotlinDebug\n*F\n+ 1 OpenFileCommand.kt\ncom/jetbrains/performancePlugin/commands/OpenFileCommand$Companion\n*L\n48#1:105,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VirtualFile findFile(@NotNull String filePath, @NotNull Project project) {
            VirtualFile virtualFile;
            block5: {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (StringsKt.contains$default((CharSequence)filePath, (CharSequence)"!/", (boolean)false, (int)2, null)) {
                    virtualFile = JarFileSystem.getInstance().findFileByPath(filePath);
                } else if (FileUtil.isAbsolute((String)filePath)) {
                    virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
                } else {
                    for (VirtualFile it : (Iterable)BaseProjectDirectories.Companion.getBaseDirectories(project)) {
                        boolean bl = false;
                        VirtualFile virtualFile2 = it.findFileByRelativePath(filePath);
                        if (virtualFile2 == null) continue;
                        virtualFile = virtualFile2;
                        break block5;
                    }
                    virtualFile = null;
                }
            }
            return virtualFile;
        }

        @Nullable
        public final OpenFileCommandOptions getOptions(@NotNull String arguments) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Object object2 = this;
            try {
                OpenFileCommandOptions openFileCommandOptions;
                Companion $this$getOptions_u24lambda_u242 = object2;
                boolean bl = false;
                OpenFileCommandOptions $this$getOptions_u24lambda_u242_u24lambda_u241 = openFileCommandOptions = new OpenFileCommandOptions();
                boolean bl2 = false;
                String[] stringArray = new String[]{" "};
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)arguments, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Args.parse((Object)$this$getOptions_u24lambda_u242_u24lambda_u241, (String[])thisCollection$iv.toArray(new String[0]));
                object = Result.constructor-impl((Object)openFileCommandOptions);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            return (OpenFileCommandOptions)(Result.isFailure-impl((Object)object2) ? null : object2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

