/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.robot;

import com.intellij.driver.model.RemoteMouseButton;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.performancePlugin.remotedriver.RobotUtilsKt;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.core.BasicRobot;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentPrinter;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.Scrolling;
import org.assertj.swing.core.Settings;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.keystroke.KeyStrokeMap;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Modifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0019J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020 H\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0019J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0019J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J\u001c\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00192\n\u0010/\u001a\u000200\"\u00020\u0019H\u0002J\u0010\u00101\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u0012\u00102\u001a\u00020\u000e2\n\u0010/\u001a\u000200\"\u00020\u0019J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u0019H\u0002J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u0019H\u0002J\u001a\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020,2\b\b\u0002\u0010:\u001a\u00020\u0019H\u0002J\n\u0010;\u001a\u0004\u0018\u00010<H\u0016J\b\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020\nH\u0016J\b\u0010D\u001a\u00020\nH\u0016J\b\u0010E\u001a\u00020\nH\u0002J\u0010\u0010F\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010G\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010H\u001a\u00020IJ\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010L\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010L\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u0019H\u0016J\u0010\u0010L\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010L\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u0019H\u0016J,\u0010O\u001a\u00020\u000e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J*\u0010P\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010M\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u00192\b\b\u0002\u0010Q\u001a\u00020\u0019H\u0002J*\u0010R\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J*\u0010S\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J#\u0010T\u001a\u0004\u0018\u0001HU\"\u0004\b\u0000\u0010U2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002HU0\u0010H\u0002\u00a2\u0006\u0002\u0010VJ0\u0010W\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020 2\b\b\u0002\u0010X\u001a\u00020\u00192\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0002J\u001c\u0010Y\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00192\n\u0010Z\u001a\u000200\"\u00020\u0019H\u0016J\u0014\u0010[\u001a\u00020\u000e2\n\u0010'\u001a\u000200\"\u00020\u0019H\u0016J\u0010\u0010\\\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u001a\u0010]\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00192\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u001a\u0010a\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u00192\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u000e\u0010b\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J \u0010b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020 H\u0016J\u0016\u0010b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020 H\u0016J\u0010\u0010b\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020 H\u0016J&\u0010c\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J0\u0010c\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010 2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J&\u0010c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010 2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u001c\u0010c\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010 2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\b\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010g\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u000e\u0010h\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010h\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020 H\u0016J\b\u0010i\u001a\u00020\u000eH\u0016J\b\u0010j\u001a\u00020\u000eH\u0016J\u0010\u0010k\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010l\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u0019H\u0016J\u0010\u0010l\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J&\u0010m\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010n\u001a\u00020\u001b2\u0006\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u0019J\b\u0010q\u001a\u00020rH\u0016J\u000e\u0010s\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020uJ \u0010v\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020u2\u0006\u00109\u001a\u00020,2\b\b\u0002\u0010:\u001a\u00020\u0019J\u0010\u0010w\u001a\u00020<2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010w\u001a\u00020<2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010x\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020$H\u0016J\u0018\u0010x\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020$2\u0006\u0010z\u001a\u00020{H\u0016J\"\u0010x\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020$2\b\u0010z\u001a\u0004\u0018\u00010{2\u0006\u0010|\u001a\u00020\nH\u0016J\u0010\u0010}\u001a\u00020\u000e2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0015\u0010\u0080\u0001\u001a\u00020\u00192\n\u0010/\u001a\u000200\"\u00020\u0019H\u0002J\t\u0010\u0081\u0001\u001a\u00020\nH\u0002J\t\u0010\u0082\u0001\u001a\u00020\u000eH\u0016J\r\u0010\u0083\u0001\u001a\u00020 *\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot;", "Lorg/assertj/swing/core/Robot;", "()V", "basicRobot", "Lorg/assertj/swing/core/BasicRobot;", "fastRobot", "Ljava/awt/Robot;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "myAwareClick", "", "waitConst", "", "awareClick", "", "body", "Lkotlin/Function0;", "cleanUp", "cleanUpWithoutDisposingWindows", "click", "component", "Ljava/awt/Component;", "mouseButton", "Lcom/intellij/driver/model/RemoteMouseButton;", "counts", "", "point", "Ljava/awt/Point;", "c", "where", "button", "times", "Lorg/assertj/swing/core/MouseButton;", "clickWithRetry", "close", "w", "Ljava/awt/Window;", "doubleClick", "doubleKey", "p0", "doublePressKeyAndHold", "key", "enterText", "text", "", "fastPressAndReleaseKey", "keyCode", "modifiers", "", "fastPressAndReleaseKeyWithoutModifiers", "fastPressAndReleaseModifiers", "fastPressKey", "fastPressModifiers", "modifierMask", "fastReleaseKey", "fastReleaseModifiers", "fastTyping", "string", "delayBetweenShortcutAndTypingMs", "findActivePopupMenu", "Ljavax/swing/JPopupMenu;", "finder", "Lorg/assertj/swing/core/ComponentFinder;", "focus", "focusAndWaitForFocusGain", "hierarchy", "Lorg/assertj/swing/hierarchy/ComponentHierarchy;", "isActive", "isDragging", "isEdt", "isReadyForInput", "jitter", "makeScreenshot", "", "screenshotArea", "Ljava/awt/Rectangle;", "moveMouse", "x", "y", "moveMouseAndClick", "moveMouseWithAttempts", "attempts", "myEdtAwareClick", "myInnerClick", "performOnEdt", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "postClickEvent", "clickCount", "pressAndReleaseKey", "p1", "pressAndReleaseKeys", "pressKey", "pressKeyWhileRunning", "runnable", "Ljava/lang/Runnable;", "pressModifiers", "pressModifiersWhileRunning", "pressMouse", "pressMouseWhileRunning", "printer", "Lorg/assertj/swing/core/ComponentPrinter;", "releaseKey", "releaseModifiers", "releaseMouse", "releaseMouseButtons", "requireNoJOptionPaneIsShowing", "rightClick", "rotateMouseWheel", "selectAndDrag", "from", "to", "delayMs", "settings", "Lorg/assertj/swing/core/Settings;", "shortcut", "keyStoke", "Ljavax/swing/KeyStroke;", "shortcutAndTypeString", "showPopupMenu", "showWindow", "window", "dimension", "Ljava/awt/Dimension;", "p2", "type", "char", "", "unify", "useInputEvents", "waitForIdle", "toAssertJ", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nSmoothRobot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,587:1\n23#2:588\n1#3:589\n970#4:590\n1041#4,3:591\n13330#5,2:594\n1549#6:596\n1620#6,3:597\n1855#6,2:600\n*S KotlinDebug\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot\n*L\n40#1:588\n455#1:590\n455#1:591,3\n458#1:594,2\n511#1:596\n511#1:597,3\n512#1:600,2\n*E\n"})
public final class SmoothRobot
implements Robot {
    @NotNull
    private final BasicRobot basicRobot;
    @NotNull
    private final Logger logger;
    private final long waitConst;
    private boolean myAwareClick;
    @NotNull
    private final java.awt.Robot fastRobot;

    public SmoothRobot() {
        Robot robot = BasicRobot.robotWithCurrentAwtHierarchyWithoutScreenLock();
        Intrinsics.checkNotNull((Object)robot, (String)"null cannot be cast to non-null type org.assertj.swing.core.BasicRobot");
        this.basicRobot = (BasicRobot)robot;
        SmoothRobot $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SmoothRobot.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.waitConst = 30L;
        this.fastRobot = new java.awt.Robot();
        this.settings().delayBetweenEvents(10);
        this.basicRobot.settings().simpleWaitForIdle(true);
    }

    @Override
    public void moveMouse(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Point where = AWT.visibleCenterOf(component);
        if (component instanceof JComponent) {
            Scrolling.scrollToVisible(this, (JComponent)component);
            where = AWT.visibleCenterOf(component);
        }
        Point point = where;
        Intrinsics.checkNotNull((Object)point);
        this.moveMouse(component, point);
    }

    @Override
    public void moveMouse(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Point translatedPoint = GuiActionRunner.execute(() -> SmoothRobot.moveMouse$lambda$0(component, point));
        if (translatedPoint == null) {
            boolean bl = false;
            String string = "Translated point should be not null";
            throw new IllegalArgumentException(string.toString());
        }
        this.moveMouse(translatedPoint.x, translatedPoint.y);
    }

    @Override
    public void moveMouse(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.moveMouse(point.x, point.y);
    }

    @Override
    public void click(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.click(component, MouseButton.LEFT_BUTTON);
    }

    private final MouseButton toAssertJ(RemoteMouseButton $this$toAssertJ) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toAssertJ.ordinal()]) {
            case 1 -> MouseButton.LEFT_BUTTON;
            case 2 -> MouseButton.MIDDLE_BUTTON;
            case 3 -> MouseButton.RIGHT_BUTTON;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void click(@NotNull Component component, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.click(component, this.toAssertJ(mouseButton));
    }

    @Override
    public void click(@NotNull Component component, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.click(component, mouseButton, 1);
    }

    public final void click(@NotNull Component component, @NotNull RemoteMouseButton mouseButton, int counts) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.click(component, this.toAssertJ(mouseButton), counts);
    }

    @Override
    public void click(@NotNull Component component, @NotNull MouseButton mouseButton, int counts) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.clickWithRetry(component, mouseButton, counts);
    }

    private final void clickWithRetry(Component component, MouseButton mouseButton, int counts) {
        if (this.useInputEvents()) {
            SmoothRobot.postClickEvent$default(this, component, mouseButton, counts, null, 8, null);
            return;
        }
        if (component.getMouseListeners().length == 0) {
            this.moveMouse(component);
            this.basicRobot.click(component, mouseButton, counts);
            return;
        }
        int attempt = 0;
        boolean finished = false;
        while (attempt < 3 && !finished) {
            CountDownLatch clickLatch = new CountDownLatch(1);
            MouseAdapter mouseListener2 = new MouseAdapter(clickLatch, this, component){
                final /* synthetic */ CountDownLatch $clickLatch;
                final /* synthetic */ SmoothRobot this$0;
                final /* synthetic */ Component $component;
                {
                    this.$clickLatch = $clickLatch;
                    this.this$0 = $receiver;
                    this.$component = $component;
                }

                public void mouseClicked(@Nullable MouseEvent e) {
                    this.$clickLatch.countDown();
                    SmoothRobot.access$getLogger$p(this.this$0).info("Mouse clicked on " + this.$component);
                }

                public void mouseReleased(@Nullable MouseEvent e) {
                    this.mouseClicked(e);
                }

                public void mousePressed(@Nullable MouseEvent e) {
                    this.mouseClicked(e);
                }
            };
            component.addMouseListener(mouseListener2);
            this.moveMouse(component);
            ApplicationManager.getApplication().invokeAndWait(SmoothRobot::clickWithRetry$lambda$2, ModalityState.any());
            this.basicRobot.click(component, mouseButton, counts);
            boolean clicked = clickLatch.await(3L, TimeUnit.SECONDS);
            if (!clicked) {
                this.logger.warn("Repeating click. Click was unsuccessful on " + component);
                ++attempt;
                component.removeMouseListener(mouseListener2);
                continue;
            }
            finished = true;
            component.removeMouseListener(mouseListener2);
        }
    }

    @Override
    public void click(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.click(component, point, MouseButton.LEFT_BUTTON, 1);
    }

    @Override
    public void showWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.basicRobot.showWindow(window);
    }

    @Override
    public void showWindow(@NotNull Window window, @NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.basicRobot.showWindow(window, dimension);
    }

    @Override
    public void showWindow(@NotNull Window window, @Nullable Dimension dimension, boolean p2) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.basicRobot.showWindow(window, dimension, p2);
    }

    @Override
    public boolean isActive() {
        return this.basicRobot.isActive();
    }

    @Override
    public void pressAndReleaseKey(int p0, int ... p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.basicRobot.pressAndReleaseKey(p0, Arrays.copyOf(p1, p1.length));
    }

    @Override
    @NotNull
    public JPopupMenu showPopupMenu(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        JPopupMenu jPopupMenu = this.basicRobot.showPopupMenu(component);
        Intrinsics.checkNotNullExpressionValue((Object)jPopupMenu, (String)"showPopupMenu(...)");
        return jPopupMenu;
    }

    @Override
    @NotNull
    public JPopupMenu showPopupMenu(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        JPopupMenu jPopupMenu = this.basicRobot.showPopupMenu(component, point);
        Intrinsics.checkNotNullExpressionValue((Object)jPopupMenu, (String)"showPopupMenu(...)");
        return jPopupMenu;
    }

    @Override
    public void jitter(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.basicRobot.jitter(component);
    }

    @Override
    public void jitter(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.basicRobot.jitter(component, point);
    }

    @Override
    public void pressModifiers(int p0) {
        this.basicRobot.pressModifiers(p0);
    }

    public final void pressMouse(@NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(this.toAssertJ(mouseButton));
    }

    @Override
    public void pressMouse(@NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.basicRobot.pressMouse(mouseButton);
    }

    @Override
    public void pressMouse(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.moveMouse(component, point);
        this.basicRobot.pressMouse(component, point);
    }

    public final void pressMouse(@NotNull Component component, @NotNull Point point, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(component, point, this.toAssertJ(mouseButton));
    }

    @Override
    public void pressMouse(@NotNull Component component, @NotNull Point point, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.moveMouse(component, point);
        this.basicRobot.pressMouse(component, point, mouseButton);
    }

    public final void pressMouse(@NotNull Point point, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(point, this.toAssertJ(mouseButton));
    }

    @Override
    public void pressMouse(@NotNull Point point, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.moveMouse(point);
        this.basicRobot.pressMouse(point, mouseButton);
    }

    @Override
    @NotNull
    public ComponentHierarchy hierarchy() {
        ComponentHierarchy componentHierarchy = this.basicRobot.hierarchy();
        Intrinsics.checkNotNullExpressionValue((Object)componentHierarchy, (String)"hierarchy(...)");
        return componentHierarchy;
    }

    @Override
    public void releaseKey(int p0) {
        this.basicRobot.releaseKey(p0);
    }

    @Override
    public boolean isDragging() {
        return this.basicRobot.isDragging();
    }

    @Override
    @NotNull
    public ComponentPrinter printer() {
        ComponentPrinter componentPrinter = this.basicRobot.printer();
        Intrinsics.checkNotNullExpressionValue((Object)componentPrinter, (String)"printer(...)");
        return componentPrinter;
    }

    @Override
    public void type(char c) {
        this.basicRobot.type(c);
    }

    @Override
    public void requireNoJOptionPaneIsShowing() {
        this.basicRobot.requireNoJOptionPaneIsShowing();
    }

    @Override
    public void cleanUp() {
        this.basicRobot.cleanUp();
    }

    public final void releaseMouse(@NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.releaseMouse(this.toAssertJ(mouseButton));
    }

    @Override
    public void releaseMouse(@NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)mouseButton), (String)"mouseButton");
        this.basicRobot.releaseMouse(mouseButton);
    }

    @Override
    public void pressKey(int p0) {
        this.basicRobot.pressKey(p0);
    }

    public final void doubleKey(int p0) {
        this.fastRobot.keyPress(p0);
        this.fastRobot.keyRelease(p0);
        Thread.sleep(10L);
        this.fastRobot.keyPress(p0);
        this.fastRobot.keyRelease(p0);
    }

    public final void doublePressKeyAndHold(int key) {
        this.fastRobot.keyPress(key);
        this.fastRobot.keyRelease(key);
        Thread.sleep(10L);
        this.fastRobot.keyPress(key);
    }

    @Override
    @NotNull
    public Settings settings() {
        Settings settings = this.basicRobot.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings(...)");
        return settings;
    }

    @Override
    public void enterText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.basicRobot.enterText(text2);
    }

    @Override
    public void releaseMouseButtons() {
        this.basicRobot.releaseMouseButtons();
    }

    @Override
    public void rightClick(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.useInputEvents()) {
            SmoothRobot.postClickEvent$default(this, component, MouseButton.RIGHT_BUTTON, 0, null, 12, null);
        } else {
            this.moveMouse(component);
            this.basicRobot.rightClick(component);
        }
    }

    @Override
    public void focus(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.basicRobot.focus(component);
    }

    @Override
    public void doubleClick(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.moveMouse(component);
        this.basicRobot.doubleClick(component);
    }

    @Override
    public void cleanUpWithoutDisposingWindows() {
        this.basicRobot.cleanUpWithoutDisposingWindows();
    }

    @Override
    public boolean isReadyForInput(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.basicRobot.isReadyForInput(component);
    }

    @Override
    public void focusAndWaitForFocusGain(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.basicRobot.focusAndWaitForFocusGain(component);
    }

    @Override
    public void releaseModifiers(int p0) {
        this.basicRobot.releaseModifiers(p0);
    }

    @Override
    @Nullable
    public JPopupMenu findActivePopupMenu() {
        return this.basicRobot.findActivePopupMenu();
    }

    @Override
    public void rotateMouseWheel(@NotNull Component component, int p1) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.basicRobot.rotateMouseWheel(component, p1);
    }

    @Override
    public void rotateMouseWheel(int p0) {
        this.basicRobot.rotateMouseWheel(p0);
    }

    @Override
    public void pressAndReleaseKeys(int ... p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this.basicRobot.pressAndReleaseKeys(Arrays.copyOf(p0, p0.length));
    }

    @Override
    @NotNull
    public ComponentFinder finder() {
        ComponentFinder componentFinder = this.basicRobot.finder();
        Intrinsics.checkNotNullExpressionValue((Object)componentFinder, (String)"finder(...)");
        return componentFinder;
    }

    @Override
    public void waitForIdle() {
        if (this.myAwareClick) {
            Thread.sleep(50L);
        } else {
            Pause.pause(this.waitConst);
            if (!this.isEdt()) {
                this.basicRobot.waitForIdle();
            }
        }
    }

    @Override
    public void close(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        this.basicRobot.close(w);
        this.basicRobot.waitForIdle();
    }

    @Override
    public void moveMouse(int x, int y) {
        long pauseConstMs = this.settings().delayBetweenEvents();
        int n = 20;
        Point start = MouseInfo.getPointerInfo().getLocation();
        double dx = (double)(x - start.x) / (double)n;
        double dy = (double)(y - start.y) / (double)n;
        int step = 1;
        while (true) {
            try {
                Pause.pause(pauseConstMs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.basicRobot.moveMouse((int)((double)start.x + dx * ((Math.log(1.0 * (double)step / (double)n) - Math.log(1.0 / (double)n)) * (double)n / (0.0 - Math.log(1.0 / (double)n)))), (int)((double)start.y + dy * ((Math.log(1.0 * (double)step / (double)n) - Math.log(1.0 / (double)n)) * (double)n / (0.0 - Math.log(1.0 / (double)n)))));
            if (step == n) break;
            ++step;
        }
        this.basicRobot.moveMouse(x, y);
    }

    @Override
    public void moveMouse(@NotNull Component c, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        SmoothRobot.moveMouseWithAttempts$default(this, c, x, y, 0, 8, null);
    }

    public final void click(@NotNull Component c, @NotNull Point where, @NotNull RemoteMouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(c, where, this.toAssertJ(button), times);
    }

    @Override
    public void click(@NotNull Component c, @NotNull Point where, @NotNull MouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)((Object)button), (String)"button");
        if (this.useInputEvents()) {
            this.postClickEvent(c, button, times, where);
        } else {
            this.moveMouseAndClick(c, where, button, times);
        }
    }

    public final void click(@NotNull Point where, @NotNull RemoteMouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(where, this.toAssertJ(button), times);
    }

    @Override
    public void click(@NotNull Point where, @NotNull MouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)((Object)button), (String)"button");
        this.moveMouseAndClick(null, where, button, times);
    }

    @Override
    public void pressKeyWhileRunning(int keyCode, @Nullable Runnable runnable) {
        this.basicRobot.pressKeyWhileRunning(keyCode, runnable);
    }

    @Override
    public void pressMouseWhileRunning(@Nullable MouseButton button, @Nullable Runnable runnable) {
        this.basicRobot.pressMouseWhileRunning(button, runnable);
    }

    @Override
    public void pressMouseWhileRunning(@Nullable Component c, @Nullable Point where, @Nullable Runnable runnable) {
        this.basicRobot.pressMouseWhileRunning(c, where, runnable);
    }

    @Override
    public void pressMouseWhileRunning(@Nullable Component c, @Nullable Point where, @Nullable MouseButton button, @Nullable Runnable runnable) {
        this.basicRobot.pressMouseWhileRunning(c, where, button, runnable);
    }

    @Override
    public void pressMouseWhileRunning(@Nullable Point where, @Nullable MouseButton button, @Nullable Runnable runnable) {
        this.basicRobot.pressMouseWhileRunning(where, button, runnable);
    }

    @Override
    public void pressModifiersWhileRunning(int modifierMask, @Nullable Runnable runnable) {
        this.basicRobot.pressModifiersWhileRunning(modifierMask, runnable);
    }

    private final void fastPressAndReleaseKey(int keyCode, int ... modifiers) {
        int unifiedModifiers = this.unify(Arrays.copyOf(modifiers, modifiers.length));
        int updatedModifiers = Modifiers.updateModifierWithKeyCode(keyCode, unifiedModifiers);
        this.fastPressModifiers(updatedModifiers);
        if (updatedModifiers == unifiedModifiers) {
            this.fastPressKey(keyCode);
            this.fastReleaseKey(keyCode);
        }
        this.fastReleaseModifiers(updatedModifiers);
    }

    public final void fastPressAndReleaseModifiers(int ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        int unifiedModifiers = this.unify(Arrays.copyOf(modifiers, modifiers.length));
        this.fastPressModifiers(unifiedModifiers);
        Pause.pause(50L);
        this.fastReleaseModifiers(unifiedModifiers);
    }

    private final void fastPressAndReleaseKeyWithoutModifiers(int keyCode) {
        this.fastPressKey(keyCode);
        this.fastReleaseKey(keyCode);
    }

    public final void shortcut(@NotNull KeyStroke keyStoke) {
        Intrinsics.checkNotNullParameter((Object)keyStoke, (String)"keyStoke");
        int[] nArray = new int[]{keyStoke.getModifiers()};
        this.fastPressAndReleaseKey(keyStoke.getKeyCode(), nArray);
    }

    public final void shortcutAndTypeString(@NotNull KeyStroke keyStoke, @NotNull String string, int delayBetweenShortcutAndTypingMs) {
        Intrinsics.checkNotNullParameter((Object)keyStoke, (String)"keyStoke");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int[] nArray = new int[]{keyStoke.getModifiers()};
        this.fastPressAndReleaseKey(keyStoke.getKeyCode(), nArray);
        this.fastTyping(string, delayBetweenShortcutAndTypingMs);
    }

    public static /* synthetic */ void shortcutAndTypeString$default(SmoothRobot smoothRobot, KeyStroke keyStroke, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        smoothRobot.shortcutAndTypeString(keyStroke, string, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void fastTyping(String string, int delayBetweenShortcutAndTypingMs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CharSequence charSequence = string;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KeyStroke keyStroke = KeyStrokeMap.keyStrokeFor((char)it);
            if (keyStroke == null) {
                throw new Exception("Unable to get keystroke for char '" + (char)it + "'");
            }
            collection.add(keyStroke.getKeyCode());
        }
        int[] keyCodeArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        if (delayBetweenShortcutAndTypingMs > 0) {
            Pause.pause(delayBetweenShortcutAndTypingMs);
        }
        int[] $this$forEach$iv = keyCodeArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.fastPressAndReleaseKeyWithoutModifiers(it);
            Pause.pause(50L);
        }
    }

    static /* synthetic */ void fastTyping$default(SmoothRobot smoothRobot, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        smoothRobot.fastTyping(string, n);
    }

    @NotNull
    public final byte[] makeScreenshot() {
        return this.makeScreenshot(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] makeScreenshot(Rectangle screenshotArea) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream b = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)this.fastRobot.createScreenCapture(screenshotArea), "png", b);
            byArray = b.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    private final boolean isEdt() {
        return SwingUtilities.isEventDispatchThread();
    }

    private final void moveMouseAndClick(Component c, Point where, MouseButton button, int times) {
        Component component = c;
        if (component != null) {
            this.moveMouse(component, where.x, where.y);
        } else {
            this.moveMouse(where.x, where.y);
        }
        Pause.pause(this.waitConst);
        this.myEdtAwareClick(button, times, where, c);
    }

    static /* synthetic */ void moveMouseAndClick$default(SmoothRobot smoothRobot, Component component, Point point, MouseButton mouseButton, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            component = null;
        }
        smoothRobot.moveMouseAndClick(component, point, mouseButton, n);
    }

    private final void moveMouseWithAttempts(Component c, int x, int y, int attempts) {
        if (attempts == 0) {
            return;
        }
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        RobotUtilsKt.waitFor$default(duration, duration2, null, (Function0)new Function0<Boolean>(this, c){
            final /* synthetic */ SmoothRobot this$0;
            final /* synthetic */ Component $c;
            {
                this.this$0 = $receiver;
                this.$c = $c;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Object object = SmoothRobot.access$performOnEdt(this.this$0, (Function0)new Function0<Boolean>(this.$c){
                    final /* synthetic */ Component $c;
                    {
                        this.$c = $c;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$c.isShowing();
                    }
                });
                Intrinsics.checkNotNull((Object)object);
                return (Boolean)object;
            }
        }, 4, null);
        Object t = this.performOnEdt((Function0)new Function0<Point>(c, x, y){
            final /* synthetic */ Component $c;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            {
                this.$c = $c;
                this.$x = $x;
                this.$y = $y;
                super(0);
            }

            public final Point invoke() {
                return AWT.translate(this.$c, this.$x, this.$y);
            }
        });
        if (t == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Point componentLocation2 = (Point)t;
        this.moveMouse(componentLocation2.x, componentLocation2.y);
        Object t2 = this.performOnEdt((Function0)new Function0<Point>(c, x, y){
            final /* synthetic */ Component $c;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            {
                this.$c = $c;
                this.$x = $x;
                this.$y = $y;
                super(0);
            }

            public final Point invoke() {
                return AWT.translate(this.$c, this.$x, this.$y);
            }
        });
        if (t2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Point componentLocationAfterMove2 = (Point)t2;
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        if (mouseLocation.x != componentLocationAfterMove2.x || mouseLocation.y != componentLocationAfterMove2.y) {
            this.moveMouseWithAttempts(c, x, y, attempts - 1);
        }
    }

    static /* synthetic */ void moveMouseWithAttempts$default(SmoothRobot smoothRobot, Component component, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 3;
        }
        smoothRobot.moveMouseWithAttempts(component, n, n2, n3);
    }

    private final void myInnerClick(MouseButton button, int times, Point point, Component component) {
        if (component == null) {
            this.basicRobot.click(point, button, times);
        } else {
            this.basicRobot.click(component, point, button, times);
        }
    }

    private final void fastPressKey(int keyCode) {
        this.fastRobot.keyPress(keyCode);
    }

    private final void fastReleaseKey(int keyCode) {
        this.fastRobot.keyRelease(keyCode);
    }

    /*
     * WARNING - void declaration
     */
    private final void fastPressModifiers(int modifierMask) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int[] keys = Modifiers.keysFor(modifierMask);
        int keysSize = keys.length;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)keysSize);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(keys[it]);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.fastPressKey(it);
        }
    }

    private final void fastReleaseModifiers(int modifierMask) {
        int[] modifierKeys = Modifiers.keysFor(modifierMask);
        int n = modifierKeys.length + -1;
        if (0 <= n) {
            do {
                int i = n--;
                this.fastReleaseKey(modifierKeys[i]);
            } while (0 <= n);
        }
    }

    private final void myEdtAwareClick(MouseButton button, int times, Point point, Component component) {
        if (this.isEdt()) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, button, times, point, component){
                final /* synthetic */ SmoothRobot this$0;
                final /* synthetic */ MouseButton $button;
                final /* synthetic */ int $times;
                final /* synthetic */ Point $point;
                final /* synthetic */ Component $component;
                {
                    this.this$0 = $receiver;
                    this.$button = $button;
                    this.$times = $times;
                    this.$point = $point;
                    this.$component = $component;
                    super(0);
                }

                public final void invoke() {
                    SmoothRobot.access$myInnerClick(this.this$0, this.$button, this.$times, this.$point, this.$component);
                }
            }), (int)31, null);
        } else {
            this.myInnerClick(button, times, point, component);
        }
        this.waitForIdle();
    }

    private final <T> T performOnEdt(Function0<? extends T> body) {
        return GuiActionRunner.execute(new GuiQuery<T>(body){
            final /* synthetic */ Function0<T> $body;
            {
                this.$body = $body;
            }

            protected T executeInEDT() {
                return (T)this.$body.invoke();
            }
        });
    }

    private final void awareClick(Function0<Unit> body) {
        this.myAwareClick = true;
        body.invoke();
        this.myAwareClick = false;
    }

    private final int unify(int ... modifiers) {
        int unified = 0;
        if (!(modifiers.length == 0)) {
            unified = modifiers[0];
            int n = modifiers.length;
            for (int i = 1; i < n; ++i) {
                unified |= modifiers[i];
            }
        }
        return unified;
    }

    private final void postClickEvent(Component component, MouseButton button, int clickCount, Point where) {
        int awtMouseButton = switch (WhenMappings.$EnumSwitchMapping$1[button.ordinal()]) {
            case 1 -> 1;
            case 2 -> 3;
            case 3 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        };
        IdeEventQueue eventQueue = IdeEventQueue.Companion.getInstance();
        Window window = SwingUtilities.getWindowAncestor(component);
        Point point = where;
        if (point == null) {
            point = AWT.visibleCenterOf(component);
        }
        Point clickPoint = SwingUtilities.convertPoint(component, point, window);
        for (int i = 0; i < clickCount; ++i) {
            int it = i;
            boolean bl = false;
            MouseEvent mousePressedEvent = new MouseEvent(window, 501, System.currentTimeMillis(), 0, clickPoint.x, clickPoint.y, 1, awtMouseButton == 3, awtMouseButton);
            eventQueue.postEvent((AWTEvent)mousePressedEvent);
            MouseEvent mouseReleasedEvent = new MouseEvent(window, 502, System.currentTimeMillis(), 0, clickPoint.x, clickPoint.y, 1, false, awtMouseButton);
            eventQueue.postEvent((AWTEvent)mouseReleasedEvent);
        }
    }

    static /* synthetic */ void postClickEvent$default(SmoothRobot smoothRobot, Component component, MouseButton mouseButton, int n, Point point, int n2, Object object) {
        if ((n2 & 2) != 0) {
            mouseButton = MouseButton.LEFT_BUTTON;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            point = null;
        }
        smoothRobot.postClickEvent(component, mouseButton, n, point);
    }

    public final void selectAndDrag(@NotNull Component component, @NotNull Point from, @NotNull Point to, int delayMs) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.moveMouse(component, from);
        this.click(component, from);
        this.pressMouse(RemoteMouseButton.LEFT);
        Thread.sleep(delayMs);
        this.moveMouse(component, to);
        Thread.sleep(delayMs);
        this.releaseMouse(RemoteMouseButton.LEFT);
    }

    private final boolean useInputEvents() {
        return Boolean.parseBoolean(System.getProperty("driver.robot.use.input.events"));
    }

    private static final Point moveMouse$lambda$0(Component $component, Point $point) {
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)$point, (String)"$point");
        return AWT.translate($component, $point.x, $point.y);
    }

    private static final void clickWithRetry$lambda$2() {
    }

    public static final /* synthetic */ Logger access$getLogger$p(SmoothRobot $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$performOnEdt(SmoothRobot $this, Function0 body) {
        return $this.performOnEdt(body);
    }

    public static final /* synthetic */ void access$myInnerClick(SmoothRobot $this, MouseButton button, int times, Point point, Component component) {
        $this.myInnerClick(button, times, point, component);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RemoteMouseButton.values().length];
            try {
                nArray[RemoteMouseButton.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteMouseButton.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteMouseButton.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MouseButton.values().length];
            try {
                nArray[MouseButton.LEFT_BUTTON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.RIGHT_BUTTON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.MIDDLE_BUTTON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

