/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u000bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/graph/collapsing/BranchFilterController;", "Lcom/intellij/vcs/log/graph/impl/facade/CascadeController;", "delegateLinearGraphController", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "idsOfVisibleBranches", "", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Ljava/util/Set;)V", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "compiledGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "getCompiledGraph", "()Lcom/intellij/vcs/log/graph/api/LinearGraph;", "visibility", "Lcom/intellij/vcs/log/graph/utils/UnsignedBitSet;", "convertToDelegate", "Lcom/intellij/vcs/log/graph/api/elements/GraphElement;", "graphElement", "delegateGraphChanged", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAnswer;", "delegateAnswer", "performAction", "", "action", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAction;", "update", "intellij.platform.vcs.log.graph.impl"})
public final class BranchFilterController
extends CascadeController {
    @NotNull
    private CollapsedGraph collapsedGraph;
    @NotNull
    private final UnsignedBitSet visibility;

    public BranchFilterController(@NotNull LinearGraphController delegateLinearGraphController, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @Nullable Set<Integer> idsOfVisibleBranches) {
        Intrinsics.checkNotNullParameter((Object)delegateLinearGraphController, (String)"delegateLinearGraphController");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        super(delegateLinearGraphController, permanentGraphInfo);
        LinearGraph linearGraph = permanentGraphInfo.getLinearGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getLinearGraph(...)");
        this.visibility = GraphUtilKt.getReachableNodes(linearGraph, idsOfVisibleBranches);
        this.collapsedGraph = this.update();
    }

    private final CollapsedGraph update() {
        CollapsedGraph collapsedGraph = CollapsedGraph.newInstance(this.getDelegateController().getCompiledGraph(), this.visibility);
        Intrinsics.checkNotNullExpressionValue((Object)collapsedGraph, (String)"newInstance(...)");
        return collapsedGraph;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        Intrinsics.checkNotNullParameter((Object)delegateAnswer, (String)"delegateAnswer");
        if (delegateAnswer.getGraphChanges() != null) {
            this.collapsedGraph = this.update();
        }
        return delegateAnswer;
    }

    @Nullable
    protected Void performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return null;
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        LinearGraph linearGraph = this.collapsedGraph.getCompiledGraph();
        Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getCompiledGraph(...)");
        return linearGraph;
    }

    @Override
    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        Intrinsics.checkNotNullParameter((Object)graphElement, (String)"graphElement");
        return CollapsedController.convertToDelegate(graphElement, this.collapsedGraph);
    }
}

