/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNodeType;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetter;
import com.intellij.vcs.log.graph.api.printer.GraphPrintElement;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.PrintElementPresentationManagerImpl;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.print.GraphElementComparatorByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004)*+,B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl;", "CommitId", "", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "graphController", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "permanentGraph", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "colorGenerator", "Lcom/intellij/vcs/log/graph/api/printer/GraphColorGetter;", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/graph/api/printer/GraphColorGetter;)V", "isShowLongEdges", "", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "getLinearGraph", "()Lcom/intellij/vcs/log/graph/api/LinearGraph;", "getPermanentGraph", "()Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "presentationManager", "Lcom/intellij/vcs/log/graph/impl/facade/PrintElementPresentationManagerImpl;", "printElementGenerator", "Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;", "buildSimpleGraphInfo", "Lcom/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo;", "visibleRow", "", "visibleRange", "getActionController", "Lcom/intellij/vcs/log/graph/actions/ActionController;", "getRecommendedWidth", "getRowInfo", "Lcom/intellij/vcs/log/graph/RowInfo;", "getVisibleCommitCount", "getVisibleRowIndex", "commitId", "(Ljava/lang/Object;)Ljava/lang/Integer;", "toString", "", "updatePrintElementGenerator", "", "ActionControllerImpl", "GraphAnswerImpl", "LinearGraphActionImpl", "RowInfoImpl", "intellij.platform.vcs.log.graph.impl"})
public final class VisibleGraphImpl<CommitId>
implements VisibleGraph<CommitId> {
    @NotNull
    private final LinearGraphController graphController;
    @NotNull
    private final PermanentGraphInfo<CommitId> permanentGraph;
    @NotNull
    private final GraphColorGetter colorGenerator;
    private PrintElementPresentationManagerImpl<CommitId> presentationManager;
    private PrintElementGeneratorImpl printElementGenerator;
    private boolean isShowLongEdges;

    public VisibleGraphImpl(@NotNull LinearGraphController graphController, @NotNull PermanentGraphInfo<CommitId> permanentGraph, @NotNull GraphColorGetter colorGenerator) {
        Intrinsics.checkNotNullParameter((Object)graphController, (String)"graphController");
        Intrinsics.checkNotNullParameter(permanentGraph, (String)"permanentGraph");
        Intrinsics.checkNotNullParameter((Object)colorGenerator, (String)"colorGenerator");
        this.graphController = graphController;
        this.permanentGraph = permanentGraph;
        this.colorGenerator = colorGenerator;
        this.updatePrintElementGenerator();
    }

    @NotNull
    public final PermanentGraphInfo<CommitId> getPermanentGraph() {
        return this.permanentGraph;
    }

    public int getVisibleCommitCount() {
        return this.graphController.getCompiledGraph().nodesCount();
    }

    @NotNull
    public RowInfo<CommitId> getRowInfo(int visibleRow) {
        boolean bl;
        int nodeId = this.graphController.getCompiledGraph().getNodeId(visibleRow);
        boolean bl2 = bl = nodeId >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new RowInfoImpl(nodeId, visibleRow);
    }

    @Nullable
    public Integer getVisibleRowIndex(@NotNull CommitId commitId2) {
        Intrinsics.checkNotNullParameter(commitId2, (String)"commitId");
        int nodeId = this.permanentGraph.getPermanentCommitsInfo().getNodeId(commitId2);
        return this.graphController.getCompiledGraph().getNodeIndex(nodeId);
    }

    @NotNull
    public ActionController<CommitId> getActionController() {
        return new ActionControllerImpl();
    }

    public final void updatePrintElementGenerator() {
        this.presentationManager = new PrintElementPresentationManagerImpl<CommitId>(this.permanentGraph, this.getLinearGraph(), this.colorGenerator);
        GraphElementComparatorByLayoutIndex comparator2 = new GraphElementComparatorByLayoutIndex(arg_0 -> VisibleGraphImpl.updatePrintElementGenerator$lambda$0((Function1)new Function1<Integer, Integer>(this){
            final /* synthetic */ VisibleGraphImpl<CommitId> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(int nodeIndex) {
                int nodeId = this.this$0.getLinearGraph().getNodeId(nodeIndex);
                if (nodeId < 0) {
                    return nodeId;
                }
                return this.this$0.getPermanentGraph().getPermanentGraphLayout().getLayoutIndex(nodeId);
            }
        }, arg_0));
        LinearGraph linearGraph = this.getLinearGraph();
        PrintElementPresentationManagerImpl<CommitId> printElementPresentationManagerImpl = this.presentationManager;
        if (printElementPresentationManagerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"presentationManager");
            printElementPresentationManagerImpl = null;
        }
        this.printElementGenerator = new PrintElementGeneratorImpl(linearGraph, printElementPresentationManagerImpl, this.isShowLongEdges, comparator2);
    }

    @NotNull
    public final SimpleGraphInfo<CommitId> buildSimpleGraphInfo(int visibleRow, int visibleRange) {
        SimpleGraphInfo<CommitId> simpleGraphInfo = SimpleGraphInfo.build(this.graphController.getCompiledGraph(), this.permanentGraph.getPermanentGraphLayout(), this.permanentGraph.getPermanentCommitsInfo(), this.permanentGraph.getLinearGraph().nodesCount(), this.permanentGraph.getBranchNodeIds(), visibleRow, visibleRange);
        Intrinsics.checkNotNullExpressionValue(simpleGraphInfo, (String)"build(...)");
        return simpleGraphInfo;
    }

    public int getRecommendedWidth() {
        PrintElementGeneratorImpl printElementGeneratorImpl = this.printElementGenerator;
        if (printElementGeneratorImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"printElementGenerator");
            printElementGeneratorImpl = null;
        }
        return printElementGeneratorImpl.getRecommendedWidth();
    }

    @NotNull
    public final LinearGraph getLinearGraph() {
        return this.graphController.getCompiledGraph();
    }

    @NotNull
    public String toString() {
        List commits2 = new ArrayList();
        int n = this.getVisibleCommitCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getRowInfo(i).getCommit();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
            commits2.add(object);
        }
        return "VisibleGraph[" + CollectionsKt.joinToString$default((Iterable)commits2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    private static final Integer updatePrintElementGenerator$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0019\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl;", "Lcom/intellij/vcs/log/graph/actions/ActionController;", "(Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl;)V", "areLongEdgesHidden", "", "convert", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAction;", "graphAction", "Lcom/intellij/vcs/log/graph/actions/GraphAction;", "Lcom/intellij/vcs/log/graph/actions/GraphAnswer;", "answer", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAnswer;", "selectionChanged", "convertToNodeId", "", "nodeIndex", "(Ljava/lang/Integer;)Ljava/lang/Integer;", "isActionSupported", "action", "performAction", "performArrowAction", "setLongEdgesHidden", "", "longEdgesHidden", "intellij.platform.vcs.log.graph.impl"})
    @SourceDebugExtension(value={"SMAP\nVisibleGraphImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisibleGraphImpl.kt\ncom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$ActionControllerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
    private final class ActionControllerImpl
    implements ActionController<CommitId> {
        private final Integer convertToNodeId(Integer nodeIndex) {
            return nodeIndex == null ? null : Integer.valueOf(VisibleGraphImpl.this.graphController.getCompiledGraph().getNodeId(nodeIndex));
        }

        private final GraphAnswer<CommitId> performArrowAction(LinearGraphController.LinearGraphAction action) {
            GraphPrintElement affectedElement = action.getAffectedElement();
            if (!(affectedElement instanceof EdgePrintElement)) {
                return null;
            }
            EdgePrintElement edgePrintElement = (EdgePrintElement)affectedElement;
            if (!edgePrintElement.hasArrow()) {
                return null;
            }
            GraphElement graphElement = affectedElement.getGraphElement();
            GraphEdge graphEdge = graphElement instanceof GraphEdge ? (GraphEdge)graphElement : null;
            if (graphEdge == null) {
                return null;
            }
            GraphEdge edge = graphEdge;
            Integer targetId = null;
            if (edge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                boolean bl;
                boolean bl2 = bl = edgePrintElement.getType() == EdgePrintElement.Type.DOWN;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                targetId = edge.getTargetId();
            }
            if (edge.getType().isNormalEdge()) {
                Integer n = targetId = edgePrintElement.getType() == EdgePrintElement.Type.DOWN ? this.convertToNodeId(edge.getDownNodeIndex()) : this.convertToNodeId(edge.getUpNodeIndex());
            }
            if (targetId == null) {
                return null;
            }
            if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                PrintElementPresentationManagerImpl printElementPresentationManagerImpl = VisibleGraphImpl.this.presentationManager;
                if (printElementPresentationManagerImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"presentationManager");
                    printElementPresentationManagerImpl = null;
                }
                boolean selectionChanged = printElementPresentationManagerImpl.setSelectedElement(affectedElement);
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(true), VisibleGraphImpl.this.getPermanentGraph().getPermanentCommitsInfo().getCommitId(targetId), null, false, selectionChanged);
            }
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                PrintElementPresentationManagerImpl printElementPresentationManagerImpl = VisibleGraphImpl.this.presentationManager;
                if (printElementPresentationManagerImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"presentationManager");
                    printElementPresentationManagerImpl = null;
                }
                boolean selectionChanged = printElementPresentationManagerImpl.setSelectedElements(SetsKt.emptySet());
                return new GraphAnswerImpl(LinearGraphUtils.getCursor(false), VisibleGraphImpl.this.getPermanentGraph().getPermanentCommitsInfo().getCommitId(targetId), null, true, selectionChanged);
            }
            return null;
        }

        @NotNull
        public GraphAnswer<CommitId> performAction(@NotNull GraphAction graphAction) {
            boolean selectionChanged;
            Intrinsics.checkNotNullParameter((Object)graphAction, (String)"graphAction");
            LinearGraphController.LinearGraphAction action = this.convert(graphAction);
            GraphAnswer graphAnswer = this.performArrowAction(action);
            if (graphAnswer != null) {
                return graphAnswer;
            }
            LinearGraphController.LinearGraphAnswer answer = VisibleGraphImpl.this.graphController.performLinearGraphAction(action);
            if (answer.getSelectedNodeIds() != null) {
                PrintElementPresentationManagerImpl printElementPresentationManagerImpl = VisibleGraphImpl.this.presentationManager;
                if (printElementPresentationManagerImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"presentationManager");
                    printElementPresentationManagerImpl = null;
                }
                Set<Integer> set = answer.getSelectedNodeIds();
                Intrinsics.checkNotNull(set);
                v2 = printElementPresentationManagerImpl.setSelectedElements(set);
            } else {
                PrintElementPresentationManagerImpl printElementPresentationManagerImpl = VisibleGraphImpl.this.presentationManager;
                if (printElementPresentationManagerImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"presentationManager");
                    printElementPresentationManagerImpl = null;
                }
                v2 = selectionChanged = printElementPresentationManagerImpl.setSelectedElements(SetsKt.emptySet());
            }
            if (answer.getGraphChanges() != null) {
                VisibleGraphImpl.this.updatePrintElementGenerator();
            }
            return this.convert(answer, selectionChanged);
        }

        public boolean areLongEdgesHidden() {
            return !VisibleGraphImpl.this.isShowLongEdges;
        }

        public void setLongEdgesHidden(boolean longEdgesHidden) {
            VisibleGraphImpl.this.isShowLongEdges = !longEdgesHidden;
            VisibleGraphImpl.this.updatePrintElementGenerator();
        }

        private final LinearGraphController.LinearGraphAction convert(GraphAction graphAction) {
            GraphPrintElement graphPrintElement;
            PrintElement printElement = graphAction.getAffectedElement();
            if (printElement != null) {
                PrintElement printElement2 = printElement;
                VisibleGraphImpl visibleGraphImpl = VisibleGraphImpl.this;
                PrintElement affectedElement = printElement2;
                boolean bl = false;
                if (affectedElement instanceof GraphPrintElement) {
                    graphPrintElement = (GraphPrintElement)affectedElement;
                } else {
                    Object v3;
                    block7: {
                        PrintElementGeneratorImpl printElementGeneratorImpl = visibleGraphImpl.printElementGenerator;
                        if (printElementGeneratorImpl == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"printElementGenerator");
                            printElementGeneratorImpl = null;
                        }
                        Iterable iterable = printElementGeneratorImpl.getPrintElements(affectedElement.getRowIndex());
                        for (Object t : iterable) {
                            GraphPrintElement it = (GraphPrintElement)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)affectedElement)) continue;
                            v3 = t;
                            break block7;
                        }
                        v3 = null;
                    }
                    if ((graphPrintElement = (GraphPrintElement)v3) == null) {
                        throw new IllegalStateException("Not found graphElement for this printElement: " + affectedElement);
                    }
                }
            } else {
                graphPrintElement = null;
            }
            GraphPrintElement printElement3 = graphPrintElement;
            return new LinearGraphActionImpl(printElement3, graphAction.getType());
        }

        private final GraphAnswer<CommitId> convert(LinearGraphController.LinearGraphAnswer answer, boolean selectionChanged) {
            Runnable runnable;
            Runnable runnable2 = answer.getGraphUpdater();
            if (runnable2 != null) {
                Runnable runnable3 = runnable2;
                VisibleGraphImpl visibleGraphImpl = VisibleGraphImpl.this;
                Runnable it = runnable3;
                boolean bl = false;
                runnable = () -> ActionControllerImpl.convert$lambda$3$lambda$2(it, visibleGraphImpl);
            } else {
                runnable = null;
            }
            Runnable updater = runnable;
            return new GraphAnswerImpl<Object>(answer.getCursorToSet(), null, updater, false, selectionChanged);
        }

        public boolean isActionSupported(@NotNull GraphAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (action.getType() == GraphAction.Type.BUTTON_COLLAPSE || action.getType() == GraphAction.Type.BUTTON_EXPAND) {
                return !(VisibleGraphImpl.this.graphController instanceof FilteredController);
            }
            return super.isActionSupported(action);
        }

        private static final void convert$lambda$3$lambda$2(Runnable $it, VisibleGraphImpl this$0) {
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $it.run();
            this$0.updatePrintElementGenerator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\b\u001a\u00020\tH\u0016J\u000f\u0010\r\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$GraphAnswerImpl;", "CommitId", "Lcom/intellij/vcs/log/graph/actions/GraphAnswer;", "cursor", "Ljava/awt/Cursor;", "commitToJump", "updater", "Ljava/lang/Runnable;", "doJump", "", "isRepaintRequired", "(Ljava/awt/Cursor;Ljava/lang/Object;Ljava/lang/Runnable;ZZ)V", "Ljava/lang/Object;", "getCommitToJump", "()Ljava/lang/Object;", "getCursorToSet", "getGraphUpdater", "intellij.platform.vcs.log.graph.impl"})
    private static final class GraphAnswerImpl<CommitId>
    implements GraphAnswer<CommitId> {
        @Nullable
        private final Cursor cursor;
        @Nullable
        private final CommitId commitToJump;
        @Nullable
        private final Runnable updater;
        private final boolean doJump;
        private final boolean isRepaintRequired;

        public GraphAnswerImpl(@Nullable Cursor cursor, @Nullable CommitId commitToJump, @Nullable Runnable updater, boolean doJump, boolean isRepaintRequired) {
            this.cursor = cursor;
            this.commitToJump = commitToJump;
            this.updater = updater;
            this.doJump = doJump;
            this.isRepaintRequired = isRepaintRequired;
        }

        @Nullable
        public Cursor getCursorToSet() {
            return this.cursor;
        }

        @Nullable
        public CommitId getCommitToJump() {
            return this.commitToJump;
        }

        @Nullable
        public Runnable getGraphUpdater() {
            return this.updater;
        }

        public boolean doJump() {
            return this.doJump;
        }

        public boolean isRepaintRequired() {
            return this.isRepaintRequired;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$LinearGraphActionImpl;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAction;", "affectedElement", "Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "type", "Lcom/intellij/vcs/log/graph/actions/GraphAction$Type;", "(Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;Lcom/intellij/vcs/log/graph/actions/GraphAction$Type;)V", "getAffectedElement", "()Lcom/intellij/vcs/log/graph/api/printer/GraphPrintElement;", "getType", "()Lcom/intellij/vcs/log/graph/actions/GraphAction$Type;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.vcs.log.graph.impl"})
    public static final class LinearGraphActionImpl
    implements LinearGraphController.LinearGraphAction {
        @Nullable
        private final GraphPrintElement affectedElement;
        @NotNull
        private final GraphAction.Type type;

        public LinearGraphActionImpl(@Nullable GraphPrintElement affectedElement, @NotNull GraphAction.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.affectedElement = affectedElement;
            this.type = type;
        }

        @Override
        @Nullable
        public GraphPrintElement getAffectedElement() {
            return this.affectedElement;
        }

        @NotNull
        public GraphAction.Type getType() {
            return this.type;
        }

        @Nullable
        public final GraphPrintElement component1() {
            return this.affectedElement;
        }

        @NotNull
        public final GraphAction.Type component2() {
            return this.type;
        }

        @NotNull
        public final LinearGraphActionImpl copy(@Nullable GraphPrintElement affectedElement, @NotNull GraphAction.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new LinearGraphActionImpl(affectedElement, type);
        }

        public static /* synthetic */ LinearGraphActionImpl copy$default(LinearGraphActionImpl linearGraphActionImpl, GraphPrintElement graphPrintElement, GraphAction.Type type, int n, Object object) {
            if ((n & 1) != 0) {
                graphPrintElement = linearGraphActionImpl.affectedElement;
            }
            if ((n & 2) != 0) {
                type = linearGraphActionImpl.type;
            }
            return linearGraphActionImpl.copy(graphPrintElement, type);
        }

        @NotNull
        public String toString() {
            return "LinearGraphActionImpl(affectedElement=" + this.affectedElement + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.affectedElement == null ? 0 : this.affectedElement.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinearGraphActionImpl)) {
                return false;
            }
            LinearGraphActionImpl linearGraphActionImpl = (LinearGraphActionImpl)other;
            if (!Intrinsics.areEqual((Object)this.affectedElement, (Object)linearGraphActionImpl.affectedElement)) {
                return false;
            }
            return this.type == linearGraphActionImpl.type;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl$RowInfoImpl;", "Lcom/intellij/vcs/log/graph/RowInfo;", "nodeId", "", "visibleRow", "(Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl;II)V", "getAdjacentRows", "", "parent", "", "getCommit", "()Ljava/lang/Object;", "getOneOfHeads", "getPrintElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "getRowType", "Lcom/intellij/vcs/log/graph/RowType;", "intellij.platform.vcs.log.graph.impl"})
    private final class RowInfoImpl
    implements RowInfo<CommitId> {
        private final int nodeId;
        private final int visibleRow;

        public RowInfoImpl(int nodeId, int visibleRow) {
            this.nodeId = nodeId;
            this.visibleRow = visibleRow;
        }

        @NotNull
        public CommitId getCommit() {
            Object CommitId2 = VisibleGraphImpl.this.getPermanentGraph().getPermanentCommitsInfo().getCommitId(this.nodeId);
            Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
            return CommitId2;
        }

        @NotNull
        public CommitId getOneOfHeads() {
            int headNodeId = VisibleGraphImpl.this.getPermanentGraph().getPermanentGraphLayout().getOneOfHeadNodeIndex(this.nodeId);
            Object CommitId2 = VisibleGraphImpl.this.getPermanentGraph().getPermanentCommitsInfo().getCommitId(headNodeId);
            Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
            return CommitId2;
        }

        @NotNull
        public Collection<PrintElement> getPrintElements() {
            PrintElementGeneratorImpl printElementGeneratorImpl = VisibleGraphImpl.this.printElementGenerator;
            if (printElementGeneratorImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"printElementGenerator");
                printElementGeneratorImpl = null;
            }
            return printElementGeneratorImpl.getPrintElements(this.visibleRow);
        }

        @NotNull
        public RowType getRowType() {
            GraphNodeType graphNodeType = VisibleGraphImpl.this.graphController.getCompiledGraph().getGraphNode(this.visibleRow).getType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)graphNodeType), (String)"getType(...)");
            GraphNodeType nodeType = graphNodeType;
            return switch (WhenMappings.$EnumSwitchMapping$0[nodeType.ordinal()]) {
                case 1 -> RowType.NORMAL;
                case 2 -> RowType.UNMATCHED;
                default -> throw new UnsupportedOperationException("Unsupported node type: " + nodeType);
            };
        }

        @NotNull
        public List<Integer> getAdjacentRows(boolean parent) {
            List<Integer> list;
            if (parent) {
                List<Integer> list2 = LinearGraphUtils.getDownNodes(VisibleGraphImpl.this.graphController.getCompiledGraph(), this.visibleRow);
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getDownNodes(...)");
            } else {
                List<Integer> list3 = LinearGraphUtils.getUpNodes(VisibleGraphImpl.this.graphController.getCompiledGraph(), this.visibleRow);
                list = list3;
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getUpNodes(...)");
            }
            return list;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GraphNodeType.values().length];
                try {
                    nArray[GraphNodeType.USUAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GraphNodeType.UNMATCHED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

