/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.Rename;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001bJ\u0006\u0010&\u001a\u00020\u0000J'\u0010&\u001a\u00020\u00002\u0018\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u0010H\u0000\u00a2\u0006\u0002\b(J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020$0\u000eJ\u0012\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010+\u001a\u00020,H\u0002J0\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u001bH&J,\u00101\u001a\u0002022$\u00103\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020204J\u001c\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b2\u0006\u0010#\u001a\u00020\u0003H&J\u0006\u00106\u001a\u000207J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017J\u001e\u00109\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\u0006\u0010:\u001a\u00020$J\u001e\u0010;\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\u0006\u0010<\u001a\u00020$J!\u0010=\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002020>H\u0000\u00a2\u0006\u0002\b?J<\u0010=\u001a\u0002022\u001e\u0010@\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b0\u000e2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002020>H\u0002J\u0014\u0010A\u001a\u0002022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00120BR\u0086\u0001\u0010\b\u001az\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b \n*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\u000b0\u000b \n*;\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u0003\u0012$\u0012\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b \n*\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006C"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryData;", "", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/FilePath;)V", "startPaths", "", "(Ljava/util/Collection;)V", "affectedCommits", "", "kotlin.jvm.PlatformType", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/data/index/ChangeKind;", "Lorg/jetbrains/annotations/NotNull;", "", "commitToRename", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "", "Lcom/intellij/vcs/log/history/Rename;", "getCommitToRename$intellij_platform_vcs_log_impl", "()Lcom/intellij/util/containers/MultiMap;", "files", "", "getFiles", "()Ljava/util/Set;", "hasRenames", "", "getHasRenames", "()Z", "isEmpty", "getStartPaths$intellij_platform_vcs_log_impl", "()Ljava/util/Collection;", "affects", "commit", "path", "Lcom/intellij/vcs/log/history/CommitFileState;", "verify", "build", "oldRenames", "build$intellij_platform_vcs_log_impl", "buildFileStatesMap", "findRename", "ad", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "Lcom/intellij/vcs/log/history/EdgeData;", "parent", "child", "isChildPath", "forEach", "", "action", "Lkotlin/Function3;", "getAffectedCommits", "getCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getCommitsWithRenames", "getFileStateInChildRevision", "parentState", "getFileStateInParentRevision", "childState", "iterateUnmatchedAdditionsDeletions", "Lkotlin/Function1;", "iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl", "commits", "removeAll", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,502:1\n1285#2,4:503\n1620#2,3:507\n215#3,2:510\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryData\n*L\n243#1:503,4\n358#1:507,3\n372#1:510,2\n*E\n"})
public abstract class FileHistoryData {
    @NotNull
    private final Collection<FilePath> startPaths;
    @NotNull
    private final Map<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> affectedCommits;
    @NotNull
    private final MultiMap<UnorderedPair<Integer>, Rename> commitToRename;

    public FileHistoryData(@NotNull Collection<? extends FilePath> startPaths) {
        Intrinsics.checkNotNullParameter(startPaths, (String)"startPaths");
        this.startPaths = startPaths;
        Map map = CollectionFactory.createCustomHashingStrategyMap(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createCustomHashingStrategyMap(...)");
        this.affectedCommits = map;
        this.commitToRename = new MultiMap();
    }

    @NotNull
    public final Collection<FilePath> getStartPaths$intellij_platform_vcs_log_impl() {
        return this.startPaths;
    }

    @NotNull
    public final MultiMap<UnorderedPair<Integer>, Rename> getCommitToRename$intellij_platform_vcs_log_impl() {
        return this.commitToRename;
    }

    public final boolean isEmpty() {
        return this.affectedCommits.isEmpty();
    }

    public final boolean getHasRenames() {
        return !this.commitToRename.isEmpty();
    }

    @NotNull
    public final Set<FilePath> getFiles() {
        return this.affectedCommits.keySet();
    }

    public FileHistoryData(@NotNull FilePath startPath) {
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        this(CollectionsKt.listOf((Object)startPath));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileHistoryData build$intellij_platform_vcs_log_impl(@NotNull MultiMap<UnorderedPair<Integer>, Rename> oldRenames) {
        Intrinsics.checkNotNullParameter(oldRenames, (String)"oldRenames");
        Set set = CollectionFactory.createCustomHashingStrategySet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCustomHashingStrategySet(...)");
        Set newPaths = set;
        newPaths.addAll(this.startPaths);
        while (!((Collection)newPaths).isEmpty()) {
            Map commits2;
            Intrinsics.checkNotNullExpressionValue((Object)CollectionFactory.createCustomHashingStrategyMap(FileHistoryKt.FILE_PATH_HASHING_STRATEGY), (String)"createCustomHashingStrategyMap(...)");
            Iterable $this$associateWithTo$iv = newPaths;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                void it;
                FilePath filePath = (FilePath)element$iv;
                Object t = element$iv;
                Map map = commits2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = this.getAffectedCommits((FilePath)it);
                map.put(t, int2ObjectMap);
            }
            this.affectedCommits.putAll(commits2);
            newPaths.clear();
            this.iterateUnmatchedAdditionsDeletions(commits2, (Function1<? super AdditionDeletion, Unit>)((Function1)new Function1<AdditionDeletion, Unit>(oldRenames, this, (Set<FilePath>)newPaths){
                final /* synthetic */ MultiMap<UnorderedPair<Integer>, Rename> $oldRenames;
                final /* synthetic */ FileHistoryData this$0;
                final /* synthetic */ Set<FilePath> $newPaths;
                {
                    this.$oldRenames = $oldRenames;
                    this.this$0 = $receiver;
                    this.$newPaths = $newPaths;
                    super(1);
                }

                public final void invoke(@NotNull AdditionDeletion ad) {
                    Rename rename;
                    Rename rename2;
                    Object v1;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
                        Collection collection = this.$oldRenames.get(ad.getCommits());
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                        Iterable iterable = collection;
                        for (T t : iterable) {
                            Rename it = (Rename)t;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!ad.matches(it)) continue;
                            v1 = t;
                            break block4;
                        }
                        v1 = null;
                    }
                    if ((rename2 = (Rename)v1) == null) {
                        rename2 = FileHistoryData.access$findRename(this.this$0, ad);
                    }
                    if ((rename = rename2) != null) {
                        this.this$0.getCommitToRename$intellij_platform_vcs_log_impl().putValue(ad.getCommits(), (Object)rename);
                        FilePath filePath = rename.getOtherPath(ad);
                        Intrinsics.checkNotNull((Object)filePath);
                        FilePath otherPath2 = filePath;
                        if (!FileHistoryData.access$getAffectedCommits$p(this.this$0).containsKey(otherPath2)) {
                            this.$newPaths.add(otherPath2);
                        }
                    }
                }
            }));
        }
        return this;
    }

    private final Rename findRename(AdditionDeletion ad) {
        Rename rename;
        EdgeData<FilePath> edgeData = this.findRename(ad.getParent(), ad.getChild(), ad.getFilePath(), ad.isAddition());
        if (edgeData != null) {
            EdgeData<FilePath> files = edgeData;
            boolean bl = false;
            rename = new Rename((FilePath)files.parent, (FilePath)files.child, ad.getParent(), ad.getChild());
        } else {
            rename = null;
        }
        return rename;
    }

    @NotNull
    public final FileHistoryData build() {
        MultiMap multiMap = MultiMap.empty();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
        return this.build$intellij_platform_vcs_log_impl((MultiMap<UnorderedPair<Integer>, Rename>)multiMap);
    }

    private final void iterateUnmatchedAdditionsDeletions(Map<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<ChangeKind>>> commits2, Function1<? super AdditionDeletion, Unit> action) {
        FileHistoryKt.forEach(commits2, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)new Function3<FilePath, Integer, Int2ObjectMap<ChangeKind>, Unit>(this, action){
            final /* synthetic */ FileHistoryData this$0;
            final /* synthetic */ Function1<AdditionDeletion, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull FilePath path, int commit, @NotNull Int2ObjectMap<ChangeKind> changes) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                ObjectSet objectSet = changes.int2ObjectEntrySet();
                Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"int2ObjectEntrySet(...)");
                Iterable iterable = (Iterable)objectSet;
                FileHistoryData fileHistoryData = this.this$0;
                Function1<AdditionDeletion, Unit> function1 = this.$action;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    boolean bl;
                    AdditionDeletion ad;
                    block4: {
                        Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)element$iv;
                        boolean bl2 = false;
                        int parent = entry.getIntKey();
                        ChangeKind change = (ChangeKind)((Object)entry.getValue());
                        if (parent == commit || change != ChangeKind.ADDED && change != ChangeKind.REMOVED) continue;
                        ad = new AdditionDeletion(path, commit, parent, change == ChangeKind.ADDED);
                        Collection collection = fileHistoryData.getCommitToRename$intellij_platform_vcs_log_impl().get(ad.getCommits());
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                        Iterable $this$any$iv = collection;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv2 : $this$any$iv) {
                                Rename rename = (Rename)element$iv2;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)rename);
                                if (!ad.matches(rename)) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    function1.invoke((Object)ad);
                }
                ProgressManager.checkCanceled();
            }
        }));
    }

    public final void iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl(@NotNull Function1<? super AdditionDeletion, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.iterateUnmatchedAdditionsDeletions(this.affectedCommits, (Function1<? super AdditionDeletion, Unit>)((Function1)new Function1<AdditionDeletion, Unit>(action){
            final /* synthetic */ Function1<AdditionDeletion, Unit> $action;
            {
                this.$action = $action;
                super(1);
            }

            public final void invoke(@NotNull AdditionDeletion it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$action.invoke((Object)it);
            }
        }));
    }

    @NotNull
    public final CommitFileState getFileStateInParentRevision(int commit, int parent, @NotNull CommitFileState childState) {
        Intrinsics.checkNotNullParameter((Object)childState, (String)"childState");
        FilePath childFilePath = childState.getFilePath();
        Int2ObjectMap int2ObjectMap = this.affectedCommits.get(childFilePath);
        ChangeKind changeKind = int2ObjectMap != null && (int2ObjectMap = (Int2ObjectMap)int2ObjectMap.get(commit)) != null ? (ChangeKind)((Object)int2ObjectMap.get(parent)) : null;
        if (changeKind == null) {
            return childState;
        }
        ChangeKind changeKind2 = changeKind;
        if (changeKind2 == ChangeKind.NOT_CHANGED) {
            return childState;
        }
        Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection renames2 = collection;
        if (!childState.getDeleted()) {
            FilePath otherPath2 = (FilePath)FileHistoryKt.access$firstNotNull(renames2, (Function1)new Function1<Rename, FilePath>(commit, childFilePath){
                final /* synthetic */ int $commit;
                final /* synthetic */ FilePath $childFilePath;
                {
                    this.$commit = $commit;
                    this.$childFilePath = $childFilePath;
                    super(1);
                }

                @Nullable
                public final FilePath invoke(Rename rename) {
                    return rename.getOtherPath(this.$commit, this.$childFilePath);
                }
            });
            if (otherPath2 != null) {
                return new CommitFileState(otherPath2);
            }
            return new CommitFileState(childFilePath, changeKind2 == ChangeKind.ADDED);
        }
        if (changeKind2 == ChangeKind.REMOVED && FileHistoryKt.access$firstNotNull(renames2, (Function1)new Function1<Rename, FilePath>(parent, childFilePath){
            final /* synthetic */ int $parent;
            final /* synthetic */ FilePath $childFilePath;
            {
                this.$parent = $parent;
                this.$childFilePath = $childFilePath;
                super(1);
            }

            @Nullable
            public final FilePath invoke(Rename rename) {
                return rename.getOtherPath(this.$parent, this.$childFilePath);
            }
        }) != null) {
            return childState;
        }
        return new CommitFileState(childFilePath, changeKind2 != ChangeKind.REMOVED);
    }

    @NotNull
    public final CommitFileState getFileStateInChildRevision(int commit, int parent, @NotNull CommitFileState parentState) {
        Intrinsics.checkNotNullParameter((Object)parentState, (String)"parentState");
        FilePath parentFilePath = parentState.getFilePath();
        Int2ObjectMap int2ObjectMap = this.affectedCommits.get(parentFilePath);
        ChangeKind changeKind = int2ObjectMap != null && (int2ObjectMap = (Int2ObjectMap)int2ObjectMap.get(commit)) != null ? (ChangeKind)((Object)int2ObjectMap.get(parent)) : null;
        if (changeKind == null) {
            return parentState;
        }
        ChangeKind changeKind2 = changeKind;
        if (changeKind2 == ChangeKind.NOT_CHANGED) {
            return parentState;
        }
        Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection renames2 = collection;
        if (!parentState.getDeleted()) {
            FilePath otherPath2 = (FilePath)FileHistoryKt.access$firstNotNull(renames2, (Function1)new Function1<Rename, FilePath>(parent, parentFilePath){
                final /* synthetic */ int $parent;
                final /* synthetic */ FilePath $parentFilePath;
                {
                    this.$parent = $parent;
                    this.$parentFilePath = $parentFilePath;
                    super(1);
                }

                @Nullable
                public final FilePath invoke(Rename rename) {
                    return rename.getOtherPath(this.$parent, this.$parentFilePath);
                }
            });
            if (otherPath2 != null) {
                return new CommitFileState(otherPath2);
            }
            return new CommitFileState(parentFilePath, changeKind2 == ChangeKind.REMOVED);
        }
        if (changeKind2 == ChangeKind.ADDED && FileHistoryKt.access$firstNotNull(renames2, (Function1)new Function1<Rename, FilePath>(commit, parentFilePath){
            final /* synthetic */ int $commit;
            final /* synthetic */ FilePath $parentFilePath;
            {
                this.$commit = $commit;
                this.$parentFilePath = $parentFilePath;
                super(1);
            }

            @Nullable
            public final FilePath invoke(Rename rename) {
                return rename.getOtherPath(this.$commit, this.$parentFilePath);
            }
        }) != null) {
            return parentState;
        }
        return new CommitFileState(parentFilePath, changeKind2 != ChangeKind.ADDED);
    }

    public final boolean affects(int commit, @NotNull CommitFileState path, boolean verify) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Int2ObjectMap<Int2ObjectMap<ChangeKind>> int2ObjectMap = this.affectedCommits.get(path.getFilePath());
        Int2ObjectMap int2ObjectMap2 = int2ObjectMap != null ? (Int2ObjectMap)int2ObjectMap.get(commit) : null;
        if (int2ObjectMap2 == null) {
            return false;
        }
        Int2ObjectMap changes = int2ObjectMap2;
        if (path.getDeleted()) {
            if (!changes.containsValue((Object)ChangeKind.REMOVED)) {
                return false;
            }
            if (!verify) {
                return true;
            }
            for (Int2ObjectMap.Entry entry : changes.int2ObjectEntrySet()) {
                int parent = entry.getIntKey();
                Collection collection = this.commitToRename.get((Object)new UnorderedPair((Object)commit, (Object)parent));
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                if (FileHistoryKt.access$firstNotNull(collection, (Function1)new Function1<Rename, FilePath>(parent, path){
                    final /* synthetic */ int $parent;
                    final /* synthetic */ CommitFileState $path;
                    {
                        this.$parent = $parent;
                        this.$path = $path;
                        super(1);
                    }

                    @Nullable
                    public final FilePath invoke(Rename rename) {
                        return rename.getOtherPath(this.$parent, this.$path.getFilePath());
                    }
                }) == null) continue;
                return false;
            }
            return true;
        }
        return !changes.containsValue((Object)ChangeKind.REMOVED);
    }

    public static /* synthetic */ boolean affects$default(FileHistoryData fileHistoryData, int n, CommitFileState commitFileState, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: affects");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return fileHistoryData.affects(n, commitFileState, bl);
    }

    @NotNull
    public final IntSet getCommits() {
        IntOpenHashSet result2 = new IntOpenHashSet();
        FileHistoryKt.forEach(this.affectedCommits, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)new Function3<FilePath, Integer, Int2ObjectMap<ChangeKind>, Unit>(result2){
            final /* synthetic */ IntOpenHashSet $result;
            {
                this.$result = $result;
                super(3);
            }

            public final void invoke(@NotNull FilePath filePath, int commit, @NotNull Int2ObjectMap<ChangeKind> int2ObjectMap) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(int2ObjectMap, (String)"<anonymous parameter 2>");
                this.$result.add(commit);
            }
        }));
        return (IntSet)result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Integer> getCommitsWithRenames() {
        void var2_2;
        void $this$mapTo$iv;
        Collection collection = this.commitToRename.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable iterable = collection;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void rename;
            Rename rename2 = (Rename)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(rename.getChildCommit());
        }
        return (Set)var2_2;
    }

    @NotNull
    public final Map<Integer, CommitFileState> buildFileStatesMap() {
        Map result2 = new LinkedHashMap();
        FileHistoryKt.forEach(this.affectedCommits, (Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)new Function3<FilePath, Integer, Int2ObjectMap<ChangeKind>, Unit>((Map<Integer, CommitFileState>)result2){
            final /* synthetic */ Map<Integer, CommitFileState> $result;
            {
                this.$result = $result;
                super(3);
            }

            public final void invoke(@NotNull FilePath filePath, int commit, @NotNull Int2ObjectMap<ChangeKind> changes) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Integer n = commit;
                this.$result.put(n, new CommitFileState(filePath, changes.containsValue((Object)((Object)ChangeKind.REMOVED))));
            }
        }));
        return result2;
    }

    public final void forEach(@NotNull Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        FileHistoryKt.forEach(this.affectedCommits, action);
    }

    public final void removeAll(@NotNull List<Integer> commits2) {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Map<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> $this$forEach$iv = this.affectedCommits;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> element$iv;
            Map.Entry<FilePath, Int2ObjectMap<Int2ObjectMap<ChangeKind>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> commitsMap = entry.getValue();
            Intrinsics.checkNotNull(commitsMap);
            FileHistoryKt.removeAll(commitsMap, commits2);
        }
    }

    @Nullable
    public abstract EdgeData<FilePath> findRename(int var1, int var2, @NotNull FilePath var3, boolean var4);

    @NotNull
    public abstract Int2ObjectMap<Int2ObjectMap<ChangeKind>> getAffectedCommits(@NotNull FilePath var1);

    public static final /* synthetic */ Rename access$findRename(FileHistoryData $this, AdditionDeletion ad) {
        return $this.findRename(ad);
    }

    public static final /* synthetic */ Map access$getAffectedCommits$p(FileHistoryData $this) {
        return $this.affectedCommits;
    }
}

