/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.UnsupportedHistoryFiltersException;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryEditorDiffPreview;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryModel;
import com.intellij.vcs.log.history.FileHistorySpeedSearch;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.ComponentQuickActionProvider;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileHistoryPanel
extends JPanel
implements UiDataProvider,
Disposable {
    @NotNull
    @NonNls
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FileHistoryModel myFileHistoryModel;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final FileHistorySpeedSearch mySpeedSearch;
    @NotNull
    private final CommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final FrameDiffPreview myFrameDiffPreview;
    @NotNull
    private final FileHistoryEditorDiffPreview myEditorDiffPreview;
    @NotNull
    private final History myHistory;

    FileHistoryPanel(final @NotNull AbstractVcsLogUi logUi2, @NotNull FileHistoryModel fileHistoryModel, final @NotNull FileHistoryFilterUi filterUi, @NotNull VcsLogData logData, @NotNull FilePath filePath, @NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager, @NotNull Disposable disposable) {
        if (logUi2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(0);
        }
        if (fileHistoryModel == null) {
            FileHistoryPanel.$$$reportNull$$$0(1);
        }
        if (filterUi == null) {
            FileHistoryPanel.$$$reportNull$$$0(2);
        }
        if (logData == null) {
            FileHistoryPanel.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            FileHistoryPanel.$$$reportNull$$$0(4);
        }
        if (root == null) {
            FileHistoryPanel.$$$reportNull$$$0(5);
        }
        if (colorManager == null) {
            FileHistoryPanel.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            FileHistoryPanel.$$$reportNull$$$0(7);
        }
        this.myProject = logData.getProject();
        this.myFilePath = filePath;
        this.myRoot = root;
        this.myFileHistoryModel = fileHistoryModel;
        this.myProperties = logUi2.getProperties();
        this.myGraphTable = new VcsLogGraphTable(logUi2.getId(), logData, logUi2.getProperties(), colorManager, () -> logUi2.requestMore(EmptyRunnable.INSTANCE), disposable){

            @Override
            protected void updateEmptyText() {
                VisiblePack visiblePack = this.getModel().getVisiblePack();
                if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                    VisiblePack.ErrorVisiblePack errorVisiblePack = (VisiblePack.ErrorVisiblePack)visiblePack;
                    Throwable error = errorVisiblePack.getError();
                    this.setErrorEmptyText(error, VcsLogBundle.message("file.history.error.status", new Object[0]));
                    if (error instanceof UnsupportedHistoryFiltersException) {
                        this.appendActionToEmptyText(VcsLogBundle.message("file.history.reset.filters.status.action", new Object[0]), () -> filterUi.resetFiltersToDefault());
                    } else {
                        this.appendActionToEmptyText(VcsLogBundle.message("vcs.log.refresh.status.action", new Object[0]), () -> logUi2.getRefresher().onRefresh());
                    }
                } else {
                    this.getEmptyText().setText(VcsLogBundle.message("file.history.empty.status", new Object[0]));
                }
            }
        };
        this.mySpeedSearch = new FileHistorySpeedSearch(this.myProject, logData.getIndex(), logData.getStorage(), this.myGraphTable);
        this.mySpeedSearch.setupListeners();
        this.myDetailsPanel = new CommitDetailsListPanel(this.myProject, this, (Function0<CommitDetailsPanel>)((Function0)() -> new CommitDetailsPanel((Function1<? super CommitId, Unit>)((Function1)commit -> {
            VcsLogContentUtil.runInMainLog(this.myProject, (Consumer<? super MainVcsLogUi>)((Consumer)ui2 -> VcsLogNavigationUtil.jumpToCommit(ui2, commit.getHash(), commit.getRoot(), false, true)));
            return Unit.INSTANCE;
        }))));
        VcsLogCommitSelectionListenerForDetails.install(this.myGraphTable, this.myDetailsPanel, this, VcsLogColorManagerFactory.create(Collections.singleton(this.myRoot)));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        JComponent tableWithProgress = VcsLogUiUtil.installScrollingAndProgress(this.myGraphTable, this);
        this.myDetailsSplitter.setFirstComponent(tableWithProgress);
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(this.myProperties.get(CommonUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null)));
        this.myEditorDiffPreview = new FileHistoryEditorDiffPreview(this.myProject, this);
        Disposer.register((Disposable)this, (Disposable)this.myEditorDiffPreview);
        this.myToolbar = this.createActionsToolbar(filterUi);
        JBPanel tablePanel = new JBPanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                return VcsLogUiUtil.expandToFitToolbar(super.getMinimumSize(), FileHistoryPanel.this.myToolbar);
            }
        };
        tablePanel.add((Component)this.myDetailsSplitter, (Object)"Center");
        tablePanel.add((Component)this.myToolbar, (Object)"North");
        this.setLayout(new BorderLayout());
        this.myFrameDiffPreview = new FrameDiffPreview(this.myProperties, (JComponent)tablePanel, "vcs.history.diff.splitter.proportion", 0.7f, this){

            @Override
            @NotNull
            protected DiffEditorViewer createViewer() {
                FileHistoryDiffProcessor processor = FileHistoryPanel.this.createDiffPreview(false);
                processor.setToolbarVerticalSizeReferent(FileHistoryPanel.this.myToolbar);
                FileHistoryDiffProcessor fileHistoryDiffProcessor = processor;
                if (fileHistoryDiffProcessor == null) {
                    3.$$$reportNull$$$0(0);
                }
                return fileHistoryDiffProcessor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryPanel$3", "createViewer"));
            }
        };
        this.add((Component)this.myFrameDiffPreview.getMainComponent(), "Center");
        PopupHandler.installPopupMenu((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        this.invokeOnDoubleClick(ActionManager.getInstance().getAction("Diff.ShowDiff"), tableWithProgress);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(logUi2, this.myGraphTable);
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ComponentsListFocusTraversalPolicy(){

            @NotNull
            protected List<Component> getOrderedComponents() {
                List list = ContainerUtil.skipNulls(Arrays.asList(FileHistoryPanel.this.myGraphTable, FileHistoryPanel.this.myFrameDiffPreview.getPreferredFocusedComponent(), FileHistoryPanel.this.myToolbar));
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/history/FileHistoryPanel$4", "getOrderedComponents"));
            }
        });
    }

    private void invokeOnDoubleClick(@NotNull AnAction action, @NotNull JComponent component2) {
        if (action == null) {
            FileHistoryPanel.$$$reportNull$$$0(8);
        }
        if (component2 == null) {
            FileHistoryPanel.$$$reportNull$$$0(9);
        }
        new AnActionWrapper(action){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (e.getInputEvent() instanceof MouseEvent && FileHistoryPanel.this.myGraphTable.isResizingColumns()) {
                    return;
                }
                super.actionPerformed(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/history/FileHistoryPanel$5", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, component2);
    }

    @NotNull
    private JComponent createActionsToolbar(@NotNull FileHistoryFilterUi filterUi) {
        if (filterUi == null) {
            FileHistoryPanel.$$$reportNull$$$0(10);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)filterUi.createActionGroup());
        toolbarGroup.addSeparator();
        AnAction toolbarActions = CustomActionsSchema.getInstance().getCorrectedAction("Vcs.FileHistory.Toolbar");
        toolbarGroup.add(Objects.requireNonNull(toolbarActions));
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("Vcs.FileHistory.Toolbar", (ActionGroup)toolbarGroup, true);
        toolbar2.setTargetComponent((JComponent)((Object)this.myGraphTable));
        DefaultActionGroup rightToolbarGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.FileHistory.Toolbar.RightCorner")});
        ActionToolbar rightCornerToolbar = ActionManager.getInstance().createActionToolbar("Vcs.FileHistory.Toolbar", (ActionGroup)rightToolbarGroup, true);
        rightCornerToolbar.setTargetComponent((JComponent)((Object)this.myGraphTable));
        BorderLayoutPanel panel = new BorderLayoutPanel();
        GuiUtils.installVisibilityReferent((JComponent)panel, (JComponent)toolbar2.getComponent());
        panel.addToCenter((Component)toolbar2.getComponent());
        panel.addToRight((Component)rightCornerToolbar.getComponent());
        BorderLayoutPanel borderLayoutPanel = panel;
        if (borderLayoutPanel == null) {
            FileHistoryPanel.$$$reportNull$$$0(11);
        }
        return borderLayoutPanel;
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            FileHistoryPanel.$$$reportNull$$$0(12);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            FileHistoryPanel.$$$reportNull$$$0(13);
        }
        return jComponent;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        if (visiblePack == null) {
            FileHistoryPanel.$$$reportNull$$$0(14);
        }
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
        this.mySpeedSearch.setVisiblePack(visiblePack);
    }

    public void showDetails(boolean show) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(show ? this.myDetailsPanel : null)));
    }

    @NotNull
    FileHistoryDiffProcessor createDiffPreview(boolean isInEditor) {
        final FileHistoryDiffProcessor diffPreview = new FileHistoryDiffProcessor(this.myProject, (Function0<? extends Change>)((Function0)() -> this.getSelectedChange()), isInEditor, this);
        ListSelectionListener selectionListener = e -> {
            int[] selection = this.myGraphTable.getSelectedRows();
            ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(), o -> !Arrays.equals(selection, this.myGraphTable.getSelectedRows()) || Disposer.isDisposed((Disposable)diffPreview));
        };
        this.myGraphTable.getSelectionModel().addListSelectionListener(selectionListener);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(selectionListener));
        TableModelListener modelListener = e -> {
            if (e.getColumn() < 0) {
                ApplicationManager.getApplication().invokeLater(() -> diffPreview.updatePreview(), o -> Disposer.isDisposed((Disposable)diffPreview));
            }
        };
        UiNotifyConnector.installOn((Component)diffPreview.getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                diffPreview.updatePreview();
            }
        });
        this.myGraphTable.getModel().addTableModelListener(modelListener);
        Disposer.register((Disposable)diffPreview, () -> this.myGraphTable.getModel().removeTableModelListener(modelListener));
        FileHistoryDiffProcessor fileHistoryDiffProcessor = diffPreview;
        if (fileHistoryDiffProcessor == null) {
            FileHistoryPanel.$$$reportNull$$$0(15);
        }
        return fileHistoryDiffProcessor;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Change change;
        if (sink == null) {
            FileHistoryPanel.$$$reportNull$$$0(16);
        }
        if ((change = this.getSelectedChange()) != null) {
            Change[] changes = new Change[]{change};
            sink.set(VcsDataKeys.CHANGES, (Object)changes);
            sink.set(VcsDataKeys.SELECTED_CHANGES, (Object)changes);
        }
        sink.set(VcsLogInternalDataKeys.LOG_UI_PROPERTIES, (Object)this.myProperties);
        sink.set(VcsDataKeys.FILE_PATH, (Object)this.myFilePath);
        sink.set(VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS, Collections.singleton(this.myRoot));
        sink.set(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION, (Object)false);
        sink.set(VcsLogInternalDataKeys.LOG_DIFF_HANDLER, (Object)this.myFileHistoryModel.getDiffHandler());
        sink.set(EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW, (Object)this.myEditorDiffPreview);
        sink.set(VcsLogInternalDataKeys.FILE_HISTORY_MODEL, (Object)this.myFileHistoryModel.createSnapshot());
        sink.set(QuickActionProvider.KEY, (Object)new ComponentQuickActionProvider(this));
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
        sink.set(History.KEY, (Object)this.myHistory);
        List details = this.myGraphTable.getSelection().getCachedMetadata();
        FileHistoryModel model = this.myFileHistoryModel.createSnapshot();
        sink.lazy(VcsDataKeys.VCS_FILE_REVISION, () -> {
            if (details.isEmpty()) {
                return null;
            }
            return model.createRevision((VcsCommitMetadata)ContainerUtil.getFirstItem((List)details));
        });
        sink.lazy(VcsDataKeys.VCS_FILE_REVISIONS, () -> {
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ContainerUtil.mapNotNull((Collection)details, model::createRevision).toArray(new VcsFileRevision[0]);
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> ((FilePath)this.myFilePath).getVirtualFile());
        sink.lazy(VcsDataKeys.VCS_VIRTUAL_FILE, () -> {
            if (details.isEmpty()) {
                return null;
            }
            VcsCommitMetadata detail2 = Objects.requireNonNull((VcsCommitMetadata)ContainerUtil.getFirstItem((List)details));
            return FileHistoryUtil.createVcsVirtualFile(model.createRevision(detail2));
        });
    }

    @Nullable
    Change getSelectedChange() {
        return this.myFileHistoryModel.getSelectedChange(this.myGraphTable.getSelectedRows());
    }

    @NotNull
    FilePath getFilePath() {
        FilePath filePath = this.myFilePath;
        if (filePath == null) {
            FileHistoryPanel.$$$reportNull$$$0(17);
        }
        return filePath;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHistoryModel";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffPreview";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnDoubleClick";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createActionsToolbar";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 15, 17 -> new IllegalStateException(string);
        };
    }
}

