/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryLogUiProvider;
import com.intellij.vcs.log.history.FileHistoryTabsManager;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J2\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider;", "Lcom/intellij/vcs/log/history/FileHistoryLogUiProvider;", "()V", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,203:1\n1#2:204\n31#3,2:205\n*S KotlinDebug\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider\n*L\n158#1:205,2\n*E\n"})
final class VcsLogSingleFileHistoryProvider
implements FileHistoryLogUiProvider {
    @NotNull
    public static final VcsLogSingleFileHistoryProvider INSTANCE = new VcsLogSingleFileHistoryProvider();

    private VcsLogSingleFileHistoryProvider() {
    }

    @Override
    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled() || paths.size() != 1) {
            return false;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.single((Iterable)paths));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (correctedPath.isDirectory()) {
            return false;
        }
        Object object = VcsProjectLog.Companion.getInstance(project).getDataManager();
        VcsLogProvider logProvider = object != null && (object = ((VcsLogData)object).getLogProviders()) != null ? (VcsLogProvider)object.get(root) : null;
        return VcsLogFileHistoryProviderImplKt.isNewFileHistoryAvailable(project, logProvider);
    }

    @Override
    @Nullable
    public VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber, boolean selectRow) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.size() != 1) {
            return null;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        FilePath path = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (path.isDirectory()) {
            return null;
        }
        String string = revisionNumber;
        if (string != null) {
            String it = string;
            boolean bl = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(project, paths, hash2);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager2 = vcsLogManager;
        FileHistoryUi fileHistoryUi2 = VcsLogTabLocation.Companion.findLogUi(logManager2, VcsLogTabLocation.TOOL_WINDOW, FileHistoryUi.class, true, (Function1)new Function1<FileHistoryUi, Boolean>(path, hash2){
            final /* synthetic */ FilePath $path;
            final /* synthetic */ Hash $hash;
            {
                this.$path = $path;
                this.$hash = $hash;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FileHistoryUi ui2) {
                Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
                return ui2.matches(this.$path, this.$hash);
            }
        });
        boolean bl = firstTime = fileHistoryUi2 == null;
        if (firstTime) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FileHistoryTabsManager> serviceClass$iv = FileHistoryTabsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            fileHistoryUi2 = ((FileHistoryTabsManager)object).openFileHistoryTab(logManager2, path, root, hash2);
        }
        if (selectRow) {
            FileHistoryUi fileHistoryUi3 = fileHistoryUi2;
            Intrinsics.checkNotNull((Object)fileHistoryUi3);
            VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager2, hash2, root, fileHistoryUi3, firstTime);
        }
        return fileHistoryUi2;
    }
}

