/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesKt;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import com.intellij.vcs.log.util.GraphOptionsUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ-\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010%J*\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0015\u0010(\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b)R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;Lcom/intellij/vcs/log/impl/VcsLogManager;)V", "futureToolWindow", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/wm/ToolWindow;", "isLogDisposing", "", "tabs", "", "", "getTabs", "()Ljava/util/Set;", "createTabs", "", "createTabs$intellij_platform_vcs_log_impl", "disposeTabs", "disposeTabs$intellij_platform_vcs_log_impl", "getPersistentVcsLogUiFactory", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "tabId", "location", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "openAnotherLogTab", "openEditorLogTab", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "focus", "(Ljava/lang/String;ZLcom/intellij/vcs/log/VcsLogFilterCollection;)[Lcom/intellij/openapi/fileEditor/FileEditor;", "openToolWindowLogTab", "toolWindow", "toolWindowShown", "toolWindowShown$intellij_platform_vcs_log_impl", "Companion", "PersistentVcsLogUiFactory", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,196:1\n494#2,7:197\n494#2,7:204\n187#3,3:211\n*S KotlinDebug\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n*L\n53#1:197,7\n54#1:204,7\n56#1:211,3\n*E\n"})
public final class VcsLogTabsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogProjectTabsProperties uiProperties;
    @NotNull
    private final VcsLogManager logManager;
    private boolean isLogDisposing;
    @NotNull
    private final CompletableFuture<ToolWindow> futureToolWindow;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TabGroupId TAB_GROUP_ID;

    public VcsLogTabsManager(@NotNull Project project, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull VcsLogManager logManager2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        this.project = project;
        this.uiProperties = uiProperties;
        this.logManager = logManager2;
        this.futureToolWindow = new CompletableFuture();
    }

    @ApiStatus.Internal
    @NotNull
    public final Set<String> getTabs() {
        return this.uiProperties.getTabs().keySet();
    }

    public final void createTabs$intellij_platform_vcs_log_impl() {
        boolean bl;
        Set<String> toolWindowTabs;
        Set<String> editorTabs;
        block9: {
            Map<String, VcsLogTabLocation> savedTabs = this.uiProperties.getTabs();
            if (savedTabs.isEmpty()) {
                return;
            }
            Map<String, VcsLogTabLocation> $this$filterValues$iv = savedTabs;
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv.entrySet()) {
                VcsLogTabLocation vcsLogTabLocation = entry.getValue();
                boolean bl2 = false;
                if (!(vcsLogTabLocation == VcsLogTabLocation.EDITOR)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            editorTabs = ((Map)result$iv).keySet();
            Map<String, VcsLogTabLocation> $this$filterValues$iv2 = savedTabs;
            boolean $i$f$filterValues2 = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv2 = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv2.entrySet()) {
                VcsLogTabLocation it2 = entry.getValue();
                boolean bl3 = false;
                if (!(it2 == VcsLogTabLocation.TOOL_WINDOW)) continue;
                result$iv2.put(entry.getKey(), entry.getValue());
            }
            toolWindowTabs = ((Map)result$iv2).keySet();
            Map<String, VcsLogTabLocation> $this$any$iv = savedTabs;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, VcsLogTabLocation>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, VcsLogTabLocation> entry;
                    Map.Entry<String, VcsLogTabLocation> entry2 = entry = iterator.next();
                    boolean bl4 = false;
                    if (!(entry2.getValue() == VcsLogTabLocation.STANDALONE)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            LOG.warn("Reopening standalone tabs is not supported");
        }
        if (!((Collection)editorTabs).isEmpty()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), (Function0)((Function0)new Function0<Unit>(this, editorTabs){
                final /* synthetic */ VcsLogTabsManager this$0;
                final /* synthetic */ Set<String> $editorTabs;
                {
                    this.this$0 = $receiver;
                    this.$editorTabs = $editorTabs;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    if (VcsLogTabsManager.access$getLogManager$p(this.this$0).isDisposed()) {
                        return;
                    }
                    VcsLogTabsManager.access$getLOG$cp().debug("Reopening editor tabs with ids: " + this.$editorTabs);
                    Iterable iterable = this.$editorTabs;
                    VcsLogTabsManager vcsLogTabsManager = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        VcsLogTabsManager.access$openEditorLogTab(vcsLogTabsManager, it, false, null);
                    }
                }
            }));
        }
        if (!((Collection)toolWindowTabs).isEmpty()) {
            this.futureToolWindow.thenAccept(arg_0 -> VcsLogTabsManager.createTabs$lambda$3((Function1)new Function1<ToolWindow, Unit>(this, toolWindowTabs){
                final /* synthetic */ VcsLogTabsManager this$0;
                final /* synthetic */ Set<String> $toolWindowTabs;
                {
                    this.this$0 = $receiver;
                    this.$toolWindowTabs = $toolWindowTabs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(ToolWindow toolWindow) {
                    void $this$forEach$iv;
                    if (!VcsLogTabsManager.access$getLOG$cp().assertTrue(!VcsLogTabsManager.access$getLogManager$p(this.this$0).isDisposed(), (Object)"Attempting to open tabs on disposed VcsLogManager")) {
                        return;
                    }
                    VcsLogTabsManager.access$getLOG$cp().debug("Reopening toolwindow tabs with ids: " + this.$toolWindowTabs);
                    Iterable iterable = this.$toolWindowTabs;
                    VcsLogTabsManager vcsLogTabsManager = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)toolWindow);
                        VcsLogTabsManager.access$openToolWindowLogTab(vcsLogTabsManager, toolWindow, it, false, null);
                    }
                }
            }, arg_0));
        }
        ToolWindowManager.Companion.getInstance(this.project).invokeLater(() -> VcsLogTabsManager.createTabs$lambda$5(this));
    }

    public final void disposeTabs$intellij_platform_vcs_log_impl() {
        this.isLogDisposing = true;
    }

    public final void toolWindowShown$intellij_platform_vcs_log_impl(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.futureToolWindow.complete(toolWindow);
    }

    @NotNull
    public final MainVcsLogUi openAnotherLogTab(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogTabLocation location) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        String tabId = VcsLogTabsManager.Companion.generateTabId(this.logManager);
        this.uiProperties.resetState(tabId);
        if (location == VcsLogTabLocation.EDITOR) {
            FileEditor[] editors = this.openEditorLogTab(tabId, true, filters);
            MainVcsLogUi mainVcsLogUi = VcsLogEditorUtil.findVcsLogUi(editors, MainVcsLogUi.class);
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            return mainVcsLogUi;
        }
        if (location == VcsLogTabLocation.TOOL_WINDOW) {
            ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindowOrThrow$intellij_platform_vcs_log_impl(this.project);
            this.futureToolWindow.complete(toolWindow);
            return this.openToolWindowLogTab(toolWindow, tabId, true, filters);
        }
        throw new UnsupportedOperationException("Only log in editor or tool window is supported");
    }

    private final FileEditor[] openEditorLogTab(String tabId, boolean focus, VcsLogFilterCollection filters) {
        VirtualFile file = VcsLogVirtualFileSystem.Holder.getInstance().createVcsLogFile(this.project, tabId, filters);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).openFile(file, focus, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        return fileEditorArray;
    }

    private final MainVcsLogUi openToolWindowLogTab(ToolWindow toolWindow, String tabId, boolean focus, VcsLogFilterCollection filters) {
        VcsLogManager.VcsLogUiFactory<MainVcsLogUi> factory = this.getPersistentVcsLogUiFactory(tabId, VcsLogTabLocation.TOOL_WINDOW, filters);
        MainVcsLogUi ui2 = VcsLogContentUtil.INSTANCE.openLogTab$intellij_platform_vcs_log_impl(this.logManager, factory, toolWindow, TAB_GROUP_ID, VcsLogTabsManager::openToolWindowLogTab$lambda$6, focus);
        Companion.onDisplayNameChange(ui2, (Function0<Unit>)((Function0)new Function0<Unit>(this, ui2){
            final /* synthetic */ VcsLogTabsManager this$0;
            final /* synthetic */ MainVcsLogUi $ui;
            {
                this.this$0 = $receiver;
                this.$ui = $ui;
                super(0);
            }

            public final void invoke() {
                VcsLogContentUtil.updateLogUiName(VcsLogTabsManager.access$getProject$p(this.this$0), this.$ui);
            }
        }));
        return ui2;
    }

    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    public final VcsLogManager.VcsLogUiFactory<MainVcsLogUi> getPersistentVcsLogUiFactory(@NotNull String tabId, @NotNull VcsLogTabLocation location, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> vcsLogUiFactory = this.logManager.getMainLogUiFactory(tabId, filters);
        Intrinsics.checkNotNullExpressionValue(vcsLogUiFactory, (String)"getMainLogUiFactory(...)");
        return new PersistentVcsLogUiFactory(vcsLogUiFactory, location);
    }

    private static final void createTabs$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createTabs$lambda$5(VcsLogTabsManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.logManager.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindow$intellij_platform_vcs_log_impl(this$0.project);
        if (toolWindow == null) {
            VcsLogTabsManager $this$createTabs_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            LOG.error("Could not find tool window by id Version Control");
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2.isVisible()) {
            this$0.futureToolWindow.complete(toolWindow2);
        }
    }

    private static final String openToolWindowLogTab$lambda$6(MainVcsLogUi u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return VcsLogTabsManager.Companion.generateShortDisplayName(u);
    }

    private static final String TAB_GROUP_ID$lambda$7() {
        return VcsLogBundle.message("vcs.log.tab.name", new Object[0]);
    }

    @JvmStatic
    @NotNull
    public static final String generateDisplayName(@NotNull VcsLogUiEx ui2) {
        return Companion.generateDisplayName(ui2);
    }

    public static final /* synthetic */ VcsLogManager access$getLogManager$p(VcsLogTabsManager $this) {
        return $this.logManager;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ FileEditor[] access$openEditorLogTab(VcsLogTabsManager $this, String tabId, boolean focus, VcsLogFilterCollection filters) {
        return $this.openEditorLogTab(tabId, focus, filters);
    }

    public static final /* synthetic */ MainVcsLogUi access$openToolWindowLogTab(VcsLogTabsManager $this, ToolWindow toolWindow, String tabId, boolean focus, VcsLogFilterCollection filters) {
        return $this.openToolWindowLogTab(toolWindow, tabId, focus, filters);
    }

    static {
        Logger logger = Logger.getInstance(VcsLogTabsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TAB_GROUP_ID = new TabGroupId("Log", VcsLogTabsManager::TAB_GROUP_ID$lambda$7, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0015\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u0010\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u000b\u0010\u0015\u001a\u00070\u000b\u00a2\u0006\u0002\b\fJ\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u001aR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TAB_GROUP_ID", "Lcom/intellij/ui/content/TabGroupId;", "getTAB_GROUP_ID", "()Lcom/intellij/ui/content/TabGroupId;", "generateDisplayName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "generateShortDisplayName", "generateTabId", "Lorg/jetbrains/annotations/NonNls;", "manager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "getFullName", "shortName", "onDisplayNameChange", "", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "block", "Lkotlin/Function0;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n766#2:197\n857#2,2:198\n1549#2:200\n1620#2,3:201\n*S KotlinDebug\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager$Companion\n*L\n156#1:197\n156#1:198,2\n177#1:200\n177#1:201,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TabGroupId getTAB_GROUP_ID() {
            return TAB_GROUP_ID;
        }

        /*
         * WARNING - void declaration
         */
        private final String generateShortDisplayName(VcsLogUiEx ui2) {
            void $this$filterTo$iv$iv;
            VcsLogUiProperties vcsLogUiProperties = ui2.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties, (String)"getProperties(...)");
            VcsLogUiProperties.VcsLogUiProperty<PermanentGraph.Options> vcsLogUiProperty = MainVcsLogUiProperties.GRAPH_OPTIONS;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"GRAPH_OPTIONS");
            PermanentGraph.Options options = VcsLogUiPropertiesKt.getOrNull(vcsLogUiProperties, vcsLogUiProperty);
            Object object = options;
            if (object == null || (object = GraphOptionsUtil.getPresentationForTabTitle(object)) == null) {
                object = "";
            }
            Object optionsPresentation = object;
            VcsLogFilterCollection vcsLogFilterCollection = ui2.getFilterUi().getFilters();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
            VcsLogFilterCollection filters = vcsLogFilterCollection;
            String filtersPresentation = filters.isEmpty() ? "" : VcsLogFiltersKt.getPresentation(filters, ((CharSequence)optionsPresentation).length() > 0);
            Object[] objectArray = new String[]{optionsPresentation, filtersPresentation};
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String presentation = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            String string = StringUtil.shortenTextWithEllipsis((String)presentation, (int)150, (int)20);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }

        @NotNull
        public final String getFullName(@NotNull String shortName) {
            Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
            String string = ContentUtilEx.getFullName((String)VcsLogBundle.message("vcs.log.tab.name", new Object[0]), (String)shortName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String generateDisplayName(@NotNull VcsLogUiEx ui2) {
            Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
            return this.getFullName(this.generateShortDisplayName(ui2));
        }

        public final void onDisplayNameChange(@NotNull MainVcsLogUi $this$onDisplayNameChange, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$onDisplayNameChange, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this$onDisplayNameChange.getFilterUi().addFilterListener(() -> Companion.onDisplayNameChange$lambda$1(block));
            MainVcsLogUiProperties mainVcsLogUiProperties = $this$onDisplayNameChange.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUiProperties, (String)"getProperties(...)");
            VcsLogUiPropertiesKt.onPropertyChange(mainVcsLogUiProperties, $this$onDisplayNameChange, (Function1)new Function1<VcsLogUiProperties.VcsLogUiProperty<?>, Unit>(block){
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(@NotNull VcsLogUiProperties.VcsLogUiProperty<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    if (Intrinsics.areEqual(it, MainVcsLogUiProperties.GRAPH_OPTIONS)) {
                        this.$block.invoke();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final String generateTabId(VcsLogManager manager) {
            void $this$mapTo$iv$iv;
            List<? extends VcsLogUi> list = manager.getLogUis();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getLogUis(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsLogUi vcsLogUi = (VcsLogUi)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String newId = null;
            do {
                Intrinsics.checkNotNullExpressionValue((Object)UUID.randomUUID().toString(), (String)"toString(...)");
            } while (existingIds.contains(newId));
            return newId;
        }

        private static final void onDisplayNameChange$lambda$1(Function0 $block) {
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            $block.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory;", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "factory", "logTabLocation", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "(Lcom/intellij/vcs/log/impl/VcsLogTabsManager;Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;Lcom/intellij/vcs/log/impl/VcsLogTabLocation;)V", "createLogUi", "project", "Lcom/intellij/openapi/project/Project;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "intellij.platform.vcs.log.impl"})
    private final class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory;
        @NotNull
        private final VcsLogTabLocation logTabLocation;

        public PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory, VcsLogTabLocation logTabLocation) {
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)((Object)logTabLocation), (String)"logTabLocation");
            this.factory = factory;
            this.logTabLocation = logTabLocation;
        }

        @Override
        @NotNull
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            MainVcsLogUi ui2 = this.factory.createLogUi(project, logData);
            VcsLogProjectTabsProperties vcsLogProjectTabsProperties = VcsLogTabsManager.this.uiProperties;
            String string = ui2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            vcsLogProjectTabsProperties.addTab(string, this.logTabLocation);
            Disposer.register((Disposable)ui2, () -> PersistentVcsLogUiFactory.createLogUi$lambda$0(VcsLogTabsManager.this, ui2));
            Intrinsics.checkNotNull((Object)ui2);
            return ui2;
        }

        private static final void createLogUi$lambda$0(VcsLogTabsManager this$0, MainVcsLogUi $ui) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.project.isDisposed() || this$0.isLogDisposing) {
                return;
            }
            VcsLogProjectTabsProperties vcsLogProjectTabsProperties = this$0.uiProperties;
            String string = $ui.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            vcsLogProjectTabsProperties.removeTab(string);
        }
    }
}

