/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.util.GraphOptionsUtil;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003&'(B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016J\"\u0010\u0019\u001a\u0002H\u0016\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u001c\u0010\u001f\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0004J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J \u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001d2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cH\u0016J*\u0010#\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010$\u001a\u0002H\u0016H\u0096\u0002\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl;", "S", "Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$State;", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "appSettings", "Lcom/intellij/vcs/log/impl/VcsLogApplicationSettings;", "(Lcom/intellij/vcs/log/impl/VcsLogApplicationSettings;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logUiState", "getLogUiState", "()Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$State;", "addChangeListener", "", "listener", "parent", "Lcom/intellij/openapi/Disposable;", "exists", "", "T", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "get", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;)Ljava/lang/Object;", "getFilterValues", "", "", "filterName", "onPropertyChanged", "removeChangeListener", "saveFilterValues", "values", "set", "value", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;Ljava/lang/Object;)V", "Companion", "State", "TextFilterSettings", "intellij.platform.vcs.log.impl"})
public abstract class VcsLogUiPropertiesImpl<S extends State>
implements MainVcsLogUiProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogApplicationSettings appSettings;
    @NotNull
    private final EventDispatcher<VcsLogUiProperties.PropertiesChangeListener> eventDispatcher;
    @NotNull
    private static final Set<VcsLogUiProperties.VcsLogUiProperty<? extends Object>> SUPPORTED_PROPERTIES;

    public VcsLogUiPropertiesImpl(@NotNull VcsLogApplicationSettings appSettings) {
        Intrinsics.checkNotNullParameter((Object)appSettings, (String)"appSettings");
        this.appSettings = appSettings;
        EventDispatcher eventDispatcher = EventDispatcher.create(VcsLogUiProperties.PropertiesChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
    }

    @NotNull
    protected abstract S getLogUiState();

    @Override
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        Comparable<Boolean> comparable;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.appSettings.exists(property)) {
            return this.appSettings.get(property);
        }
        S state = this.getLogUiState();
        VcsLogUiProperties.VcsLogUiProperty<T> vcsLogUiProperty = property;
        if (vcsLogUiProperty instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Boolean bl = ((State)state).getHighlighters().get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId());
            comparable = bl != null ? bl : true;
        } else if (vcsLogUiProperty instanceof TableColumnWidthProperty) {
            Integer n = ((State)state).getColumnIdWidth().get(property.getName());
            comparable = n != null ? n : -1;
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DETAILS)) {
            comparable = ((State)state).isShowDetails();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.SHOW_LONG_EDGES)) {
            comparable = ((State)state).isShowLongEdges();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_ROOT_NAMES)) {
            comparable = ((State)state).isShowRootNames();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES)) {
            comparable = ((State)state).isShowOnlyAffectedChanges();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.GRAPH_OPTIONS)) {
            int bekSortType = ((State)state).getBekSortType();
            if (bekSortType != 0) {
                PermanentGraph.Options migratedOptions = bekSortType == 2 ? (PermanentGraph.Options)PermanentGraph.Options.LinearBek.INSTANCE : (PermanentGraph.Options)new PermanentGraph.Options.Base(PermanentGraph.SortType.Bek);
                ((State)state).setGraphOptions(GraphOptionsUtil.INSTANCE.toStringList$intellij_platform_vcs_log_impl(migratedOptions));
                ((State)state).setBekSortType(0);
                comparable = migratedOptions;
            } else {
                comparable = GraphOptionsUtil.INSTANCE.toGraphOptions$intellij_platform_vcs_log_impl(((State)state).getGraphOptions());
                if (comparable == null) {
                    comparable = (PermanentGraph.Options)PermanentGraph.Options.Default;
                }
            }
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)) {
            comparable = ((State)this.getLogUiState()).getTextFilterSettings().isMatchCase();
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.TEXT_FILTER_REGEX)) {
            comparable = ((State)this.getLogUiState()).getTextFilterSettings().isRegex();
        } else {
            throw new UnsupportedOperationException("Property " + property + " does not exist");
        }
        Boolean result2 = comparable;
        return (T)result2;
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, T value) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.appSettings.exists(property)) {
            this.appSettings.set(property, value);
            return;
        }
        VcsLogUiProperties.VcsLogUiProperty<T> vcsLogUiProperty = property;
        if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_DETAILS)) {
            S s = this.getLogUiState();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ((State)s).setShowDetails((Boolean)value);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.SHOW_LONG_EDGES)) {
            S s = this.getLogUiState();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ((State)s).setShowLongEdges((Boolean)value);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, CommonUiProperties.SHOW_ROOT_NAMES)) {
            S s = this.getLogUiState();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ((State)s).setShowRootNames((Boolean)value);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES)) {
            S s = this.getLogUiState();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ((State)s).setShowOnlyAffectedChanges((Boolean)value);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.GRAPH_OPTIONS)) {
            S s = this.getLogUiState();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.PermanentGraph.Options");
            ((State)s).setGraphOptions(GraphOptionsUtil.INSTANCE.toStringList$intellij_platform_vcs_log_impl((PermanentGraph.Options)value));
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.TEXT_FILTER_REGEX)) {
            TextFilterSettings textFilterSettings = ((State)this.getLogUiState()).getTextFilterSettings();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            textFilterSettings.setRegex((Boolean)value);
        } else if (Intrinsics.areEqual(vcsLogUiProperty, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)) {
            TextFilterSettings textFilterSettings = ((State)this.getLogUiState()).getTextFilterSettings();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            textFilterSettings.setMatchCase((Boolean)value);
        } else if (vcsLogUiProperty instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Map<String, Boolean> map = ((State)this.getLogUiState()).getHighlighters();
            String string = ((MainVcsLogUiProperties.VcsLogHighlighterProperty)property).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string2 = string;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            Boolean bl = (Boolean)value;
            map.put(string2, bl);
        } else if (vcsLogUiProperty instanceof TableColumnWidthProperty) {
            Map<String, Integer> map = ((State)this.getLogUiState()).getColumnIdWidth();
            String string = property.getName();
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
            map.put(string, (Integer)value);
        } else {
            throw new UnsupportedOperationException("Property " + property + " does not exist");
        }
        this.onPropertyChanged(property);
    }

    protected final <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ((VcsLogUiProperties.PropertiesChangeListener)this.eventDispatcher.getMulticaster()).onPropertyChanged(property);
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.appSettings.exists(property) || SUPPORTED_PROPERTIES.contains(property) || property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty || property instanceof TableColumnWidthProperty;
    }

    @Override
    public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        if (values != null) {
            ((State)this.getLogUiState()).getFilters().put(filterName, values);
        } else {
            ((State)this.getLogUiState()).getFilters().remove(filterName);
        }
    }

    @Override
    @Nullable
    public List<String> getFilterValues(@NotNull String filterName) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        return ((State)this.getLogUiState()).getFilters().get(filterName);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener2);
        this.appSettings.addChangeListener(listener2);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.eventDispatcher.addListener((EventListener)listener2, parent);
        this.appSettings.addChangeListener(listener2, parent);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener2);
        this.appSettings.removeChangeListener(listener2);
    }

    static {
        Object[] objectArray = new VcsLogUiProperties.VcsLogUiProperty[]{CommonUiProperties.SHOW_DETAILS, MainVcsLogUiProperties.SHOW_LONG_EDGES, MainVcsLogUiProperties.GRAPH_OPTIONS, CommonUiProperties.SHOW_ROOT_NAMES, MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, MainVcsLogUiProperties.TEXT_FILTER_REGEX};
        SUPPORTED_PROPERTIES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R<\u0010\u0003\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\u00010\u0001 \u0006*\u0014\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$Companion;", "", "()V", "SUPPORTED_PROPERTIES", "", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "kotlin.jvm.PlatformType", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR.\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00110\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000fR\u001c\u0010\u001d\u001a\u00020\u001a8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\u001a8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R\u001c\u0010#\u001a\u00020\u001a8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u001c\u0010%\u001a\u00020\u001a8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001c\u0010'\u001a\u00020(8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$State;", "", "()V", "bekSortType", "", "getBekSortType", "()I", "setBekSortType", "(I)V", "columnIdWidth", "", "", "getColumnIdWidth", "()Ljava/util/Map;", "setColumnIdWidth", "(Ljava/util/Map;)V", "filters", "", "getFilters", "setFilters", "graphOptions", "getGraphOptions", "()Ljava/util/List;", "setGraphOptions", "(Ljava/util/List;)V", "highlighters", "", "getHighlighters", "setHighlighters", "isShowDetails", "()Z", "setShowDetails", "(Z)V", "isShowLongEdges", "setShowLongEdges", "isShowOnlyAffectedChanges", "setShowOnlyAffectedChanges", "isShowRootNames", "setShowRootNames", "textFilterSettings", "Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$TextFilterSettings;", "getTextFilterSettings", "()Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$TextFilterSettings;", "setTextFilterSettings", "(Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$TextFilterSettings;)V", "intellij.platform.vcs.log.impl"})
    public static class State {
        private boolean isShowDetails = true;
        private boolean isShowLongEdges;
        private int bekSortType;
        @NotNull
        private List<String> graphOptions = GraphOptionsUtil.INSTANCE.toStringList$intellij_platform_vcs_log_impl((PermanentGraph.Options)PermanentGraph.Options.Default);
        private boolean isShowRootNames;
        private boolean isShowOnlyAffectedChanges;
        @NotNull
        private Map<String, Boolean> highlighters = new TreeMap();
        @NotNull
        private Map<String, List<String>> filters = new TreeMap();
        @NotNull
        private TextFilterSettings textFilterSettings = new TextFilterSettings();
        @NotNull
        private Map<String, Integer> columnIdWidth = new HashMap();

        @OptionTag(value="SHOW_DETAILS_IN_CHANGES")
        public final boolean isShowDetails() {
            return this.isShowDetails;
        }

        public final void setShowDetails(boolean bl) {
            this.isShowDetails = bl;
        }

        @OptionTag(value="LONG_EDGES_VISIBLE")
        public final boolean isShowLongEdges() {
            return this.isShowLongEdges;
        }

        public final void setShowLongEdges(boolean bl) {
            this.isShowLongEdges = bl;
        }

        @OptionTag(value="BEK_SORT_TYPE")
        public final int getBekSortType() {
            return this.bekSortType;
        }

        public final void setBekSortType(int n) {
            this.bekSortType = n;
        }

        @OptionTag(value="GRAPH_OPTIONS")
        @NotNull
        public final List<String> getGraphOptions() {
            return this.graphOptions;
        }

        public final void setGraphOptions(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.graphOptions = list;
        }

        @OptionTag(value="SHOW_ROOT_NAMES")
        public final boolean isShowRootNames() {
            return this.isShowRootNames;
        }

        public final void setShowRootNames(boolean bl) {
            this.isShowRootNames = bl;
        }

        @OptionTag(value="SHOW_ONLY_AFFECTED_CHANGES")
        public final boolean isShowOnlyAffectedChanges() {
            return this.isShowOnlyAffectedChanges;
        }

        public final void setShowOnlyAffectedChanges(boolean bl) {
            this.isShowOnlyAffectedChanges = bl;
        }

        @OptionTag(value="HIGHLIGHTERS")
        @NotNull
        public final Map<String, Boolean> getHighlighters() {
            return this.highlighters;
        }

        public final void setHighlighters(@NotNull Map<String, Boolean> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.highlighters = map;
        }

        @OptionTag(value="FILTERS")
        @NotNull
        public final Map<String, List<String>> getFilters() {
            return this.filters;
        }

        public final void setFilters(@NotNull Map<String, List<String>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.filters = map;
        }

        @OptionTag(value="TEXT_FILTER_SETTINGS")
        @NotNull
        public final TextFilterSettings getTextFilterSettings() {
            return this.textFilterSettings;
        }

        public final void setTextFilterSettings(@NotNull TextFilterSettings textFilterSettings) {
            Intrinsics.checkNotNullParameter((Object)textFilterSettings, (String)"<set-?>");
            this.textFilterSettings = textFilterSettings;
        }

        @OptionTag(value="COLUMN_ID_WIDTH")
        @NotNull
        public final Map<String, Integer> getColumnIdWidth() {
            return this.columnIdWidth;
        }

        public final void setColumnIdWidth(@NotNull Map<String, Integer> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.columnIdWidth = map;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogUiPropertiesImpl$TextFilterSettings;", "", "()V", "isMatchCase", "", "()Z", "setMatchCase", "(Z)V", "isRegex", "setRegex", "intellij.platform.vcs.log.impl"})
    public static final class TextFilterSettings {
        private boolean isRegex;
        private boolean isMatchCase;

        @OptionTag(value="REGEX")
        public final boolean isRegex() {
            return this.isRegex;
        }

        public final void setRegex(boolean bl) {
            this.isRegex = bl;
        }

        @OptionTag(value="MATCH_CASE")
        public final boolean isMatchCase() {
            return this.isMatchCase;
        }

        public final void setMatchCase(boolean bl) {
            this.isMatchCase = bl;
        }
    }
}

