/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.VcsLogBookmark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBookmarkRefs", "", "Lcom/intellij/vcs/log/ui/VcsBookmarkRef;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n800#2,11:189\n766#2:200\n857#2,2:201\n1549#2:203\n1620#2,3:204\n*S KotlinDebug\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider\n*L\n137#1:189,11\n138#1:200\n138#1:201,2\n139#1:203\n139#1:204,3\n*E\n"})
public final class VcsLogBookmarkReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public VcsLogBookmarkReferenceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        VcsLogBookmark it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
        if (bookmarksManager == null) {
            return CollectionsKt.emptyList();
        }
        BookmarksManager bookmarksManager2 = bookmarksManager;
        List list = bookmarksManager2.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBookmarks(...)");
        Iterable iterable = list;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VcsLogBookmark)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsLogBookmark)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getHash(), (Object)hash) && Intrinsics.areEqual((Object)it.getRoot(), (Object)root))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void logBookmark;
            it = (VcsLogBookmark)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BookmarkType bookmarkType = bookmarksManager2.getType((Bookmark)logBookmark);
            if (bookmarkType == null) {
                bookmarkType = BookmarkType.DEFAULT;
            }
            BookmarkType bookmarkType2 = bookmarkType;
            Intrinsics.checkNotNull((Object)bookmarkType2);
            BookmarkType type = bookmarkType2;
            if (type != BookmarkType.DEFAULT) {
                Object[] objectArray = new Object[]{Character.valueOf(type.getMnemonic())};
                string = VcsLogBundle.message("vcs.log.bookmark.label.mnemonic", objectArray);
            } else {
                string = VcsLogBundle.message("vcs.log.bookmark.label", new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String text = string2;
            collection.add(new VcsBookmarkRef((Bookmark)logBookmark, type, text));
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Project project, @NotNull Hash hash, @NotNull VirtualFile root) {
        return Companion.getBookmarkRefs(project, hash, root);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion;", "", "()V", "getBookmarkRefs", "", "Lcom/intellij/vcs/log/ui/VcsBookmarkRef;", "project", "Lcom/intellij/openapi/project/Project;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,188:1\n31#2,2:189\n*S KotlinDebug\n*F\n+ 1 VcsLogBookmarkProvider.kt\ncom/intellij/vcs/log/ui/VcsLogBookmarkReferenceProvider$Companion\n*L\n130#1:189,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<VcsBookmarkRef> getBookmarkRefs(@NotNull Project project, @NotNull Hash hash, @NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsLogBookmarkReferenceProvider> serviceClass$iv = VcsLogBookmarkReferenceProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((VcsLogBookmarkReferenceProvider)object).getBookmarkRefs(hash, root);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

