/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.declarative;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.declarative.DeclarativeSchema;
import com.android.tools.idea.gradle.declarative.DeclarativeService;
import com.android.tools.idea.gradle.declarative.DeclarativeServiceKt;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeElement;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeIdentifier;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeIdentifierOwner;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.declarative.dsl.schema.DataClass;
import org.gradle.declarative.dsl.schema.DataProperty;
import org.gradle.declarative.dsl.schema.FqName;
import org.gradle.declarative.dsl.schema.SchemaMemberFunction;
import org.gradle.internal.declarativedsl.analysis.DefaultFqName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/declarative/DeclarativeAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getPath", "", "", "Lcom/android/tools/idea/gradle/declarative/psi/DeclarativeIdentifier;", "isNDOC", "", "parentDataClass", "Lorg/gradle/declarative/dsl/schema/DataClass;", "showUnknownName", "verifyPath", "path", "schema", "Lcom/android/tools/idea/gradle/declarative/DeclarativeSchema;", "intellij.android.gradle.dsl.declarative"})
@SourceDebugExtension(value={"SMAP\nDeclarativeAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeAnnotator.kt\ncom/android/tools/idea/gradle/declarative/DeclarativeAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class DeclarativeAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!((Boolean)StudioFlags.GRADLE_DECLARATIVE_IDE_SUPPORT.get()).booleanValue()) {
            return;
        }
        if (!(element.getParent() instanceof DeclarativeElement)) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof DeclarativeIdentifier) {
            List<String> path = this.getPath((DeclarativeIdentifier)parent);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DeclarativeService service = DeclarativeService.Companion.getInstance(project);
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)element.getContainingFile()));
            if (module == null) {
                return;
            }
            Module module2 = module;
            DeclarativeSchema declarativeSchema = service.getSchema(module2);
            if (declarativeSchema == null) {
                return;
            }
            DeclarativeSchema schema = declarativeSchema;
            if (schema.getFailureHappened()) {
                return;
            }
            this.verifyPath(path, schema, holder);
        }
    }

    private final void verifyPath(List<String> path, DeclarativeSchema schema, AnnotationHolder holder) {
        if (path.isEmpty()) {
            return;
        }
        FqName currentName = null;
        DataClass parentData = null;
        int index = 0;
        int last = path.size() - 1;
        if (index <= last) {
            while (true) {
                if (index == 0) {
                    v0 = DeclarativeServiceKt.getTopLevelReceiverByName(path.get(index), schema);
                } else {
                    DataClass dataClass;
                    if (schema.getDataClassesByFqName().get(currentName) == null) {
                        return;
                    }
                    FqName newName = DeclarativeServiceKt.getReceiverByName(path.get(index), dataClass.getMemberFunctions());
                    if (index == last && newName == null) {
                        SchemaMemberFunction schemaMemberFunction;
                        Object object;
                        block14: {
                            Iterable iterable = dataClass.getMemberFunctions();
                            for (Object object2 : iterable) {
                                SchemaMemberFunction it = (SchemaMemberFunction)object2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)path.get(index))) continue;
                                object = object2;
                                break block14;
                            }
                            object = null;
                        }
                        if ((schemaMemberFunction = (SchemaMemberFunction)object) == null) {
                            Object v3;
                            block15: {
                                Object object2;
                                Iterable iterable = dataClass.getProperties();
                                object2 = iterable.iterator();
                                while (object2.hasNext()) {
                                    Object e = object2.next();
                                    DataProperty it = (DataProperty)e;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)path.get(index))) continue;
                                    v3 = e;
                                    break block15;
                                }
                                v3 = null;
                            }
                            if ((schemaMemberFunction = (DataProperty)v3) == null) {
                                if (!this.isNDOC(dataClass)) {
                                    this.showUnknownName(holder);
                                }
                                schemaMemberFunction = Unit.INSTANCE;
                            }
                        }
                        return;
                    }
                    parentData = dataClass;
                    v0 = currentName = newName;
                }
                if (currentName == null) {
                    if (index == last && !this.isNDOC(parentData)) {
                        this.showUnknownName(holder);
                    }
                    return;
                }
                if (index == last) break;
                ++index;
            }
        }
    }

    private final boolean isNDOC(DataClass parentDataClass) {
        Object object = parentDataClass;
        return object != null && (object = object.getSupertypes()) != null ? object.contains(new DefaultFqName("org.gradle.api", "NamedDomainObjectContainer")) : false;
    }

    private final void showUnknownName(AnnotationHolder holder) {
        holder.newAnnotation(HighlightSeverity.ERROR, "Unknown identifier").create();
    }

    private final List<String> getPath(DeclarativeIdentifier element) {
        List result = new ArrayList();
        PsiElement current = element;
        while (current.getParent() != null && current instanceof DeclarativeElement) {
            if (current instanceof DeclarativeIdentifierOwner) {
                Object object = ((DeclarativeIdentifierOwner)current).getIdentifier();
                if (object != null && (object = object.getName()) != null) {
                    Object it = object;
                    boolean bl = false;
                    result.add(it);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)((DeclarativeElement)current).getParent(), (String)"getParent(...)");
        }
        return CollectionsKt.reversed((Iterable)result);
    }
}

