/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.declarative;

import com.android.tools.idea.gradle.declarative.parser.DeclarativeElementTypeHolder;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeBlock;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeFile;
import com.android.tools.idea.gradle.declarative.psi.DeclarativeIdentifier;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J.\u0010\r\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/gradle/declarative/DeclarativeFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "appendDescriptors", "", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "quick", "", "getLanguagePlaceholderText", "", "range", "Lcom/intellij/openapi/util/TextRange;", "getRangeToFold", "isRegionCollapsedByDefault", "needFolding", "intellij.android.gradle.dsl.declarative"})
public final class DeclarativeFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof DeclarativeFile)) {
            return;
        }
        FileASTNode fileASTNode = ((DeclarativeFile)root).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
        this.appendDescriptors((ASTNode)fileASTNode, document, descriptors);
    }

    private final void appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        if (this.needFolding(node)) {
            TextRange textRange = this.getRangeToFold(node, document);
            descriptors.add(new FoldingDescriptor(node, textRange));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, document, descriptors);
        }
    }

    private final TextRange getRangeToFold(ASTNode node, Document document) {
        PsiElement psiElement;
        DeclarativeIdentifier declarativeIdentifier;
        PsiElement psi = node.getPsi();
        if (psi instanceof DeclarativeBlock && (declarativeIdentifier = ((DeclarativeBlock)psi).getIdentifier()) != null && (psiElement = declarativeIdentifier.getNextSibling()) != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            int start = it.getTextRange().getStartOffset();
            int end = ((DeclarativeBlock)psi).getTextRange().getEndOffset();
            return new TextRange(start, end);
        }
        TextRange textRange = node.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    private final boolean needFolding(ASTNode node) {
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        return Intrinsics.areEqual((Object)type, (Object)DeclarativeElementTypeHolder.BLOCK_COMMENT) || Intrinsics.areEqual((Object)type, (Object)DeclarativeElementTypeHolder.BLOCK);
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)DeclarativeElementTypeHolder.BLOCK_COMMENT) ? "/* ... */" : (Intrinsics.areEqual((Object)iElementType, (Object)DeclarativeElementTypeHolder.BLOCK) ? "{...}" : "{...}");
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }
}

