/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html.ui;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.AttributeImpl;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.HtmlAppendableBase;
import com.vladsch.flexmark.util.html.ui.BackgroundColor;
import com.vladsch.flexmark.util.html.ui.Color;
import com.vladsch.flexmark.util.html.ui.ColorStyler;
import com.vladsch.flexmark.util.html.ui.FontStyle;
import com.vladsch.flexmark.util.html.ui.FontStyleStyler;
import com.vladsch.flexmark.util.html.ui.FontStyler;
import com.vladsch.flexmark.util.html.ui.HtmlStyler;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlBuilder
extends HtmlAppendableBase<HtmlBuilder> {
    public static final HashMap<Class, HtmlStyler> stylerMap = new HashMap();

    public HtmlBuilder() {
        super(0, LineAppendable.F_PASS_THROUGH);
    }

    public HtmlBuilder(int indentSize, int formatOptions) {
        super(indentSize, formatOptions);
    }

    public HtmlBuilder closeAllTags() {
        while (!this.getOpenTags().isEmpty()) {
            CharSequence tag = this.getOpenTags().peek();
            this.closeTag(tag);
        }
        return this;
    }

    public String toFinalizedString() {
        this.closeAllTags();
        return this.toString(0, 0);
    }

    public HtmlBuilder attr(Object ... convertible) {
        for (Object convert : convertible) {
            if (convert instanceof Attribute) {
                super.attr(new Attribute[]{(Attribute)convert});
                super.withAttr();
                continue;
            }
            HtmlStyler styler = HtmlBuilder.getHtmlStyler(convert);
            if (styler == null) {
                throw new IllegalStateException("Don't know how to style " + convert.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
            }
            String value2 = styler.getStyle(styler.getStyleable(convert));
            if (value2 == null || value2.isEmpty()) continue;
            AttributeImpl style = AttributeImpl.of("style", value2);
            super.attr(new Attribute[]{style});
            super.withAttr();
        }
        return this;
    }

    @Override
    @NotNull
    public HtmlBuilder attr(@NotNull CharSequence name, @Nullable CharSequence value2) {
        super.withAttr();
        return (HtmlBuilder)super.attr(name, value2);
    }

    public HtmlBuilder style(CharSequence value2) {
        super.withAttr();
        return (HtmlBuilder)super.attr("style", value2);
    }

    @Override
    @NotNull
    public HtmlBuilder attr(Attribute ... attribute) {
        super.withAttr();
        return (HtmlBuilder)super.attr(attribute);
    }

    @Override
    @NotNull
    public HtmlBuilder attr(@NotNull Attributes attributes) {
        super.withAttr();
        return (HtmlBuilder)super.attr(attributes);
    }

    public HtmlBuilder span() {
        return (HtmlBuilder)this.tag((CharSequence)"span", false);
    }

    public HtmlBuilder span(CharSequence text2) {
        this.tag((CharSequence)"span", false);
        this.text(text2);
        return this.closeSpan();
    }

    public HtmlBuilder span(boolean withLine, Runnable runnable) {
        return (HtmlBuilder)this.tag("span", false, withLine, runnable);
    }

    public HtmlBuilder span(Runnable runnable) {
        return this.span(false, runnable);
    }

    public HtmlBuilder spanLine(Runnable runnable) {
        return this.span(true, runnable);
    }

    public HtmlBuilder closeSpan() {
        return (HtmlBuilder)this.closeTag("span");
    }

    public static void addColorStylerClass(Class clazz) {
        HtmlStyler styler = stylerMap.get(Color.class);
        stylerMap.put(clazz, styler);
    }

    public static HtmlStyler getHtmlStyler(Object item) {
        HtmlStyler styler = stylerMap.get(item.getClass());
        if (styler != null) {
            return styler;
        }
        for (Class value2 : stylerMap.keySet()) {
            if (!value2.isAssignableFrom(item.getClass())) continue;
            styler = stylerMap.get(value2);
            break;
        }
        if (styler != null) {
            stylerMap.put(item.getClass(), styler);
        }
        return styler;
    }

    public static Attribute getAttribute(Object item) {
        String value2;
        HtmlStyler styler = HtmlBuilder.getHtmlStyler(item);
        if (styler != null && (value2 = styler.getStyle(styler.getStyleable(item))) != null && !value2.isEmpty()) {
            return AttributeImpl.of("style", value2);
        }
        return null;
    }

    public HtmlBuilder append(Object obj) {
        return (HtmlBuilder)super.append(String.valueOf(obj));
    }

    public HtmlBuilder append(String str) {
        return (HtmlBuilder)super.append(str);
    }

    public HtmlBuilder append(StringBuffer sb) {
        return (HtmlBuilder)super.append(sb.toString());
    }

    @Override
    @NotNull
    public HtmlBuilder append(@NotNull CharSequence s) {
        return (HtmlBuilder)super.append(s);
    }

    @Override
    @NotNull
    public HtmlBuilder append(@NotNull CharSequence s, int start, int end) {
        return (HtmlBuilder)super.append(s, start, end);
    }

    public HtmlBuilder append(char[] str) {
        return (HtmlBuilder)super.append(String.valueOf(str));
    }

    public HtmlBuilder append(char[] str, int offset, int len) {
        return (HtmlBuilder)super.append(String.valueOf(str, offset, len));
    }

    public HtmlBuilder append(boolean b) {
        return (HtmlBuilder)super.append(b ? "true" : "false");
    }

    @Override
    @NotNull
    public HtmlBuilder append(char c) {
        return (HtmlBuilder)super.append(c);
    }

    public HtmlBuilder append(int i) {
        return (HtmlBuilder)super.append(String.valueOf(i));
    }

    public HtmlBuilder append(long l) {
        return (HtmlBuilder)super.append(String.valueOf(l));
    }

    public HtmlBuilder append(float f) {
        return (HtmlBuilder)super.append(String.valueOf(f));
    }

    public HtmlBuilder append(double d) {
        return (HtmlBuilder)super.append(String.valueOf(d));
    }

    static {
        ColorStyler colorStyler = new ColorStyler();
        stylerMap.put(BackgroundColor.class, colorStyler);
        stylerMap.put(Color.class, colorStyler);
        stylerMap.put(java.awt.Color.class, colorStyler);
        FontStyler fontStyler = new FontStyler();
        stylerMap.put(Font.class, fontStyler);
        stylerMap.put(FontUIResource.class, fontStyler);
        stylerMap.put(FontStyle.class, new FontStyleStyler());
    }
}

