/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class VcsCherryPickManager {
    private static final Logger LOG = Logger.getInstance(VcsCherryPickManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<CommitId> myIdsInProgress;
    @NotNull
    private final BackgroundTaskQueue myTaskQueue;

    public VcsCherryPickManager(@NotNull Project project) {
        if (project == null) {
            VcsCherryPickManager.$$$reportNull$$$0(0);
        }
        this.myIdsInProgress = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
        this.myTaskQueue = new BackgroundTaskQueue(project, DvcsBundle.message("cherry.picking.process", new Object[0]));
    }

    public void cherryPick(@NotNull VcsLogCommitSelection commitSelection) {
        if (commitSelection == null) {
            VcsCherryPickManager.$$$reportNull$$$0(1);
        }
        commitSelection.requestFullDetails(details -> this.myTaskQueue.run((Task.Backgroundable)new CherryPickingTask(ContainerUtil.reverse((List)details))));
    }

    public boolean isCherryPickAlreadyStartedFor(@NotNull List<? extends CommitId> commits) {
        if (commits == null) {
            VcsCherryPickManager.$$$reportNull$$$0(2);
        }
        for (CommitId commitId : commits) {
            if (!this.myIdsInProgress.contains(commitId)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VcsCherryPicker getCherryPickerForCommit(@NotNull VcsFullCommitDetails commitDetails) {
        AbstractVcs vcs;
        if (commitDetails == null) {
            VcsCherryPickManager.$$$reportNull$$$0(3);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(commitDetails.getRoot())) == null) {
            return null;
        }
        VcsKey key = vcs.getKeyInstanceMethod();
        return this.getCherryPickerFor(key);
    }

    @Nullable
    public VcsCherryPicker getCherryPickerFor(@NotNull VcsKey key) {
        if (key == null) {
            VcsCherryPickManager.$$$reportNull$$$0(4);
        }
        return (VcsCherryPicker)ContainerUtil.find((Object[])((VcsCherryPicker[])VcsCherryPicker.EXTENSION_POINT_NAME.getExtensions((AreaInstance)this.myProject)), picker -> picker.getSupportedVcs().equals((Object)key));
    }

    public static VcsCherryPickManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsCherryPickManager.$$$reportNull$$$0(5);
        }
        return (VcsCherryPickManager)project.getService(VcsCherryPickManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitSelection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDetails";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cherryPick";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCherryPickAlreadyStartedFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCherryPickerForCommit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCherryPickerFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class CherryPickingTask
    extends Task.Backgroundable {
        @NotNull
        private final List<? extends VcsFullCommitDetails> myAllDetailsInReverseOrder;
        @NotNull
        private final ChangeListManagerEx myChangeListManager;

        CherryPickingTask(List<? extends VcsFullCommitDetails> detailsInReverseOrder) {
            if (detailsInReverseOrder == null) {
                CherryPickingTask.$$$reportNull$$$0(0);
            }
            super(VcsCherryPickManager.this.myProject, DvcsBundle.message("cherry.picking.process", new Object[0]));
            this.myAllDetailsInReverseOrder = detailsInReverseOrder;
            this.myChangeListManager = ChangeListManagerEx.getInstanceEx((Project)this.myProject);
            this.myChangeListManager.blockModalNotifications();
        }

        @Nullable
        private VcsCherryPicker getCherryPickerOrReportError(@NotNull VcsFullCommitDetails details) {
            CommitId commitId;
            if (details == null) {
                CherryPickingTask.$$$reportNull$$$0(1);
            }
            if (VcsCherryPickManager.this.myIdsInProgress.contains(commitId = new CommitId((Hash)details.getId(), details.getRoot()))) {
                this.showError(DvcsBundle.message("cherry.pick.process.is.already.started.for.commit.from.root", commitId.getHash().toShortString(), commitId.getRoot().getName()));
                return null;
            }
            VcsCherryPickManager.this.myIdsInProgress.add(commitId);
            VcsCherryPicker cherryPicker = VcsCherryPickManager.this.getCherryPickerForCommit(details);
            if (cherryPicker == null) {
                this.showError(DvcsBundle.message("cherry.pick.is.not.supported.for.commit.from.root", ((Hash)details.getId()).toShortString(), details.getRoot().getName()));
                return null;
            }
            return cherryPicker;
        }

        public void showError(@Nls @NotNull String message) {
            if (message == null) {
                CherryPickingTask.$$$reportNull$$$0(2);
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyWeakError("vcs.cherry.pick.error", message);
            LOG.warn(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CherryPickingTask.$$$reportNull$$$0(3);
            }
            try {
                boolean isOk = true;
                MultiMap<VcsCherryPicker, VcsFullCommitDetails> groupedCommits = this.createArrayMultiMap();
                for (VcsFullCommitDetails vcsFullCommitDetails : this.myAllDetailsInReverseOrder) {
                    VcsCherryPicker cherryPicker = this.getCherryPickerOrReportError(vcsFullCommitDetails);
                    if (cherryPicker == null) {
                        isOk = false;
                        break;
                    }
                    groupedCommits.putValue((Object)cherryPicker, (Object)vcsFullCommitDetails);
                }
                if (isOk) {
                    for (Map.Entry entry : groupedCommits.entrySet()) {
                        ((VcsCherryPicker)entry.getKey()).cherryPick(new ArrayList((Collection)entry.getValue()));
                    }
                }
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myChangeListManager.unblockModalNotifications();
                    for (VcsFullCommitDetails vcsFullCommitDetails : this.myAllDetailsInReverseOrder) {
                        VcsCherryPickManager.this.myIdsInProgress.remove(new CommitId((Hash)vcsFullCommitDetails.getId(), vcsFullCommitDetails.getRoot()));
                    }
                });
            }
        }

        @NotNull
        public MultiMap<VcsCherryPicker, VcsFullCommitDetails> createArrayMultiMap() {
            return new MultiMap<VcsCherryPicker, VcsFullCommitDetails>(){

                @NotNull
                protected Collection<VcsFullCommitDetails> createCollection() {
                    return new ArrayList<VcsFullCommitDetails>();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsInReverseOrder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCherryPickerOrReportError";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showError";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

