/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.FilePathDocumentChildPathHandle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H&J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u0006\u0010,\u001a\u00020\u0006J\b\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020\u0006J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u000202H\u0015J\b\u00103\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0005R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent;", "Lcom/intellij/openapi/vcs/ui/VcsCloneComponent;", "Lcom/intellij/openapi/vcs/ui/VcsCloneComponent$WithSettableUrl;", "project", "Lcom/intellij/openapi/project/Project;", "vcsDirectoryName", "", "rememberedInputs", "Lcom/intellij/dvcs/DvcsRememberedInputs;", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/dvcs/DvcsRememberedInputs;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;)V", "cloneDirectoryChildHandle", "Lcom/intellij/dvcs/ui/FilePathDocumentChildPathHandle;", "directoryField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "errorComponent", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getErrorComponent", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "setErrorComponent", "(Lcom/intellij/util/ui/components/BorderLayoutPanel;)V", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "getRememberedInputs", "()Lcom/intellij/dvcs/DvcsRememberedInputs;", "urlEditor", "Lcom/intellij/ui/TextFieldWithHistory;", "defaultDirectoryPath", "url", "dispose", "", "doClone", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "getDirectory", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "getUrl", "getView", "isOkActionEnabled", "", "isOkEnabled", "setUrl", "updateOkActionState", "intellij.platform.vcs.dvcs.impl"})
public abstract class DvcsCloneDialogComponent
implements VcsCloneComponent,
VcsCloneComponent.WithSettableUrl {
    @NotNull
    private Project project;
    @NotNull
    private String vcsDirectoryName;
    @NotNull
    private final DvcsRememberedInputs rememberedInputs;
    @NotNull
    private final VcsCloneDialogComponentStateListener dialogStateListener;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final TextFieldWithHistory urlEditor;
    @NotNull
    private final TextFieldWithBrowseButton directoryField;
    @NotNull
    private final FilePathDocumentChildPathHandle cloneDirectoryChildHandle;
    protected BorderLayoutPanel errorComponent;

    public DvcsCloneDialogComponent(@NotNull Project project, @NotNull String vcsDirectoryName, @NotNull DvcsRememberedInputs rememberedInputs, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsDirectoryName, (String)"vcsDirectoryName");
        Intrinsics.checkNotNullParameter((Object)rememberedInputs, (String)"rememberedInputs");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this.project = project;
        this.vcsDirectoryName = vcsDirectoryName;
        this.rememberedInputs = rememberedInputs;
        this.dialogStateListener = dialogStateListener;
        this.urlEditor = new TextFieldWithHistory();
        this.directoryField = new TextFieldWithBrowseButton();
        Document document = this.directoryField.getTextField().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String string = ClonePathProvider.defaultParentDirectoryPath(this.project, this.rememberedInputs);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultParentDirectoryPath(...)");
        this.cloneDirectoryChildHandle = FilePathDocumentChildPathHandle.Companion.install(document, string);
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.directoryField.addBrowseFolderListener(DvcsBundle.message("clone.destination.directory.browser.title", new Object[0]), DvcsBundle.message("clone.destination.directory.browser.description", new Object[0]), this.project, fcd);
        this.mainPanel = (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = VcsBundle.message((String)"vcs.common.labels.url", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)urlEditor).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                String string2 = VcsBundle.message((String)"vcs.common.labels.directory", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)directoryField).align((Align)AlignX.FILL.INSTANCE);
                    }
                }).bottomGap(BottomGap.SMALL);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.setErrorComponent(new BorderLayoutPanel(10, 0));
                        $this$row.cell((JComponent)this.getErrorComponent()).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null);
            }
        }));
        Insets insets = UIUtil.PANEL_REGULAR_INSETS;
        ((DialogPanel)this.mainPanel).setBorder((Border)new JBEmptyBorder(insets.top / 2, insets.left, insets.bottom, insets.right));
        this.urlEditor.setHistory(this.rememberedInputs.getVisitedUrls());
        this.urlEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilePathDocumentChildPathHandle filePathDocumentChildPathHandle = cloneDirectoryChildHandle;
                String string = urlEditor.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                filePathDocumentChildPathHandle.trySetChildPath(this.defaultDirectoryPath(((Object)StringsKt.trim((CharSequence)string)).toString()));
                this.updateOkActionState(dialogStateListener);
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    protected final DvcsRememberedInputs getRememberedInputs() {
        return this.rememberedInputs;
    }

    @NotNull
    protected final JPanel getMainPanel() {
        return this.mainPanel;
    }

    @NotNull
    protected final BorderLayoutPanel getErrorComponent() {
        BorderLayoutPanel borderLayoutPanel = this.errorComponent;
        if (borderLayoutPanel != null) {
            return borderLayoutPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"errorComponent");
        return null;
    }

    protected final void setErrorComponent(@NotNull BorderLayoutPanel borderLayoutPanel) {
        Intrinsics.checkNotNullParameter((Object)borderLayoutPanel, (String)"<set-?>");
        this.errorComponent = borderLayoutPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.urlEditor;
    }

    private final String defaultDirectoryPath(String url) {
        String string = StringUtil.trimEnd((String)ClonePathProvider.relativeDirectoryPathForVcsUrl(this.project, url), (String)this.vcsDirectoryName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        return string;
    }

    @NotNull
    public JPanel getView() {
        return this.mainPanel;
    }

    public boolean isOkEnabled() {
        return false;
    }

    @NotNull
    public List<ValidationInfo> doValidateAll() {
        ArrayList list = new ArrayList();
        ContainerUtil.addIfNotNull((Collection)list, (Object)CloneDvcsValidationUtils.checkDirectory(this.directoryField.getText(), this.directoryField.getTextField()));
        Collection collection = list;
        JComponent jComponent = (JComponent)this.urlEditor;
        String string = this.urlEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        ContainerUtil.addIfNotNull((Collection)collection, (Object)CloneDvcsValidationUtils.checkRepositoryURL(jComponent, ((Object)StringsKt.trim((CharSequence)string)).toString()));
        return list;
    }

    public abstract void doClone(@NotNull CheckoutProvider.Listener var1);

    @NotNull
    public final String getDirectory() {
        String string = this.directoryField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public void setUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.urlEditor.setText(url);
    }

    @NotNull
    public final String getUrl() {
        String string = CloneDvcsValidationUtils.sanitizeCloneUrl(this.urlEditor.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeCloneUrl(...)");
        return string;
    }

    public void dispose() {
    }

    @RequiresEdt
    protected boolean isOkActionEnabled() {
        return !StringsKt.isBlank((CharSequence)this.getUrl());
    }

    @RequiresEdt
    protected final void updateOkActionState(@NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        dialogStateListener.onOkActionEnabled(this.isOkActionEnabled());
    }
}

