/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;

public class GithubErrorMessage {
    @Nullable
    private String message;
    @Nullable
    private List<Error> errors;

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public List<Error> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        return this.errors;
    }

    @NotNull
    public String getPresentableError() {
        if (this.errors == null) {
            String string = this.message != null ? this.message : GithubBundle.message("unknown.loading.error", new Object[0]);
            if (string == null) {
                GithubErrorMessage.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder s = new StringBuilder();
        if (this.message != null) {
            s.append(this.message);
        }
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        String string = s.toString();
        if (string == null) {
            GithubErrorMessage.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean containsReasonMessage(@NotNull String reason) {
        if (reason == null) {
            GithubErrorMessage.$$$reportNull$$$0(2);
        }
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(@NotNull String code2) {
        if (code2 == null) {
            GithubErrorMessage.$$$reportNull$$$0(3);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(@NotNull String message2) {
        if (message2 == null) {
            GithubErrorMessage.$$$reportNull$$$0(4);
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableError";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/data/GithubErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsReasonMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorCode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class Error {
        private String resource;
        private String field;
        private String code;
        private String message;

        @Nullable
        public String getResource() {
            return this.resource;
        }

        @Nullable
        public String getField() {
            return this.field;
        }

        @Nullable
        public String getCode() {
            return this.code;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }
    }
}

