/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.file.codereview.CodeReviewDiffVirtualFile;
import com.intellij.collaboration.ui.codereview.CodeReviewAdvancedSettings;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHNewPRDiffVirtualFileKt;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0007H\u00c2\u0003J'\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0012\u0010\u0016\u001a\f0\u0003\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile;", "Lcom/intellij/collaboration/file/codereview/CodeReviewDiffVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "component1", "component2", "component3", "copy", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "equals", "", "other", "", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "hashCode", "", "isValid", "toString", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHNewPRDiffVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHNewPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n31#2,2:51\n31#2,2:53\n*S KotlinDebug\n*F\n+ 1 GHNewPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile\n*L\n31#1:51,2\n34#1:53,2\n*E\n"})
public final class GHNewPRDiffVirtualFile
extends CodeReviewDiffVirtualFile {
    @NotNull
    private final String fileManagerId;
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;

    public GHNewPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        super(GHNewPRDiffVirtualFileKt.access$getFileName());
        this.fileManagerId = fileManagerId;
        this.project = project;
        this.repository = repository;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GHPRVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.fileManagerId, this.project, this.repository, null, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GHNewPRDiffVirtualFileKt.access$getPresentablePath(this.repository);
    }

    @NotNull
    public String getPresentableName() {
        String string = GithubBundle.message("pull.request.new.diff.editor.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isValid() {
        return GHNewPRDiffVirtualFileKt.access$isFileValid(this.fileManagerId, this.project, this.repository);
    }

    @NotNull
    public DiffEditorViewer createViewer(@NotNull Project project) {
        DiffEditorViewer diffEditorViewer;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (CodeReviewAdvancedSettings.INSTANCE.isCombinedDiffEnabled()) {
            $this$service$iv = (ComponentManager)project;
            $i$f$service = false;
            serviceClass$iv = GHPRDiffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            diffEditorViewer = (DiffEditorViewer)((GHPRDiffService)object).createCombinedDiffProcessor(this.repository);
        } else {
            $this$service$iv = (ComponentManager)project;
            $i$f$service = false;
            serviceClass$iv = GHPRDiffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            diffEditorViewer = (DiffEditorViewer)((GHPRDiffService)object).createDiffRequestProcessor(this.repository);
        }
        DiffEditorViewer processor = diffEditorViewer;
        processor.getContext().putUserData(DiffUserDataKeysEx.COMBINED_DIFF_TOGGLE, (Object)CodeReviewAdvancedSettings.INSTANCE.getCodeReviewCombinedDiffToggle());
        return processor;
    }

    private final String component1() {
        return this.fileManagerId;
    }

    private final Project component2() {
        return this.project;
    }

    private final GHRepositoryCoordinates component3() {
        return this.repository;
    }

    @NotNull
    public final GHNewPRDiffVirtualFile copy(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return new GHNewPRDiffVirtualFile(fileManagerId, project, repository);
    }

    public static /* synthetic */ GHNewPRDiffVirtualFile copy$default(GHNewPRDiffVirtualFile gHNewPRDiffVirtualFile, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, int n, Object object) {
        if ((n & 1) != 0) {
            string = gHNewPRDiffVirtualFile.fileManagerId;
        }
        if ((n & 2) != 0) {
            project = gHNewPRDiffVirtualFile.project;
        }
        if ((n & 4) != 0) {
            gHRepositoryCoordinates = gHNewPRDiffVirtualFile.repository;
        }
        return gHNewPRDiffVirtualFile.copy(string, project, gHRepositoryCoordinates);
    }

    @NotNull
    public String toString() {
        return "GHNewPRDiffVirtualFile(fileManagerId=" + this.fileManagerId + ", project=" + this.project + ", repository=" + this.repository + ")";
    }

    public int hashCode() {
        int result = this.fileManagerId.hashCode();
        result = result * 31 + this.project.hashCode();
        result = result * 31 + this.repository.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHNewPRDiffVirtualFile)) {
            return false;
        }
        GHNewPRDiffVirtualFile gHNewPRDiffVirtualFile = (GHNewPRDiffVirtualFile)((Object)other);
        if (!Intrinsics.areEqual((Object)this.fileManagerId, (Object)gHNewPRDiffVirtualFile.fileManagerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)gHNewPRDiffVirtualFile.project)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.repository, (Object)gHNewPRDiffVirtualFile.repository);
    }
}

