/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.coverage.view.CoverageClassStructure;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageNodeInfo;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.JavaCoverageNode;
import com.intellij.coverage.view.JavaCoverageRootNode;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageViewExtension
extends CoverageViewExtension {
    private final JavaCoverageAnnotator myAnnotator;

    public JavaCoverageViewExtension(JavaCoverageAnnotator annotator, Project project, CoverageSuitesBundle suitesBundle) {
        super(project, suitesBundle);
        this.myAnnotator = annotator;
    }

    public String getPercentage(int columnIndex, @NotNull AbstractTreeNode node) {
        if (node == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(0);
        }
        PackageAnnotator.SummaryCoverageInfo info = this.getSummaryCoverageForNodeValue(node);
        if (columnIndex == 1) {
            return JavaCoverageAnnotator.getClassCoveredPercentage(info);
        }
        if (columnIndex == 2) {
            return JavaCoverageAnnotator.getMethodCoveredPercentage(info);
        }
        if (columnIndex == 3) {
            return JavaCoverageAnnotator.getLineCoveredPercentage(info);
        }
        if (columnIndex == 4) {
            return JavaCoverageAnnotator.getBranchCoveredPercentage(info);
        }
        return "";
    }

    @Nullable
    private PackageAnnotator.SummaryCoverageInfo getSummaryCoverageForNodeValue(AbstractTreeNode<?> node) {
        CoverageClassStructure structure = this.myAnnotator.getStructure();
        if (structure == null) {
            return null;
        }
        CoverageNodeInfo info = structure.getNodeInfo(JavaCoverageViewExtension.getNodeId(node));
        if (info == null) {
            return null;
        }
        return info.getCounter();
    }

    @NotNull
    private static String getNodeId(AbstractTreeNode<?> node) {
        String string = node instanceof CoverageListRootNode ? "<root>" : ((JavaCoverageNode)node).getQualifiedName();
        if (string == null) {
            JavaCoverageViewExtension.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement getElementToSelect(Object object) {
        PsiFile containingFile;
        PsiElement psiElement = super.getElementToSelect(object);
        if (psiElement != null && psiElement.isValid() && (containingFile = psiElement.getContainingFile()) instanceof PsiClassOwner) {
            PsiClass[] classes2 = ((PsiClassOwner)containingFile).getClasses();
            if (classes2.length == 1) {
                return classes2[0];
            }
            for (PsiClass aClass : classes2) {
                if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)psiElement, (boolean)false)) continue;
                return aClass;
            }
        }
        return psiElement;
    }

    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiPackage) {
            PsiDirectory[] directories = ((PsiPackage)object).getDirectories();
            return directories.length > 0 ? directories[0].getVirtualFile() : null;
        }
        return super.getVirtualFile(object);
    }

    @Nullable
    public PsiElement getParentElement(PsiElement element) {
        if (element instanceof PsiClass) {
            PsiDirectory containingDirectory = element.getContainingFile().getContainingDirectory();
            return containingDirectory != null ? JavaDirectoryService.getInstance().getPackage(containingDirectory) : null;
        }
        return ((PsiPackage)element).getParentPackage();
    }

    @NotNull
    public AbstractTreeNode<?> createRootNode() {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage("");
        return new JavaCoverageRootNode(this.myProject, (PsiNamedElement)Objects.requireNonNull(aPackage), this.mySuitesBundle);
    }

    public boolean hasChildren(AbstractTreeNode<?> node) {
        CoverageClassStructure structure = this.myAnnotator.getStructure();
        if (structure == null) {
            return false;
        }
        return structure.hasChildren(JavaCoverageViewExtension.getNodeId(node));
    }

    public List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node) {
        ArrayList children = new ArrayList();
        CoverageClassStructure structure = this.myAnnotator.getStructure();
        if (structure == null) {
            return children;
        }
        List<CoverageNodeInfo> infos = structure.getChildrenInfo(JavaCoverageViewExtension.getNodeId(node));
        for (CoverageNodeInfo info : infos) {
            children.add((AbstractTreeNode<?>)new JavaCoverageNode(this.myProject, info.getValue(), this.mySuitesBundle, info.getName()));
        }
        return children;
    }

    public boolean hasFullyCoveredNodes() {
        CoverageClassStructure structure = this.myAnnotator.getStructure();
        if (structure == null) {
            return false;
        }
        return structure.getHasFullyCoveredChildren();
    }

    public ColumnInfo[] createColumnInfos() {
        ArrayList<Object> infos = new ArrayList<Object>();
        infos.add(new ElementColumnInfo());
        infos.add(new PercentageCoverageColumnInfo(1, JavaCoverageBundle.message("coverage.view.column.class", new Object[0]), this.mySuitesBundle));
        infos.add(new PercentageCoverageColumnInfo(2, JavaCoverageBundle.message("coverage.view.column.method", new Object[0]), this.mySuitesBundle));
        infos.add(new PercentageCoverageColumnInfo(3, JavaCoverageBundle.message("coverage.view.column.line", new Object[0]), this.mySuitesBundle));
        for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
            if (this.tryAddBranches(infos, suite.getRunner(), suite.isBranchCoverage())) break;
        }
        return infos.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private boolean tryAddBranches(ArrayList<? super ColumnInfo> infos, CoverageRunner coverageRunner, boolean branchCoverage) {
        if (CoverageDataManager.getInstance((Project)this.myProject).isSubCoverageActive()) {
            return false;
        }
        if (this.isBranchInfoAvailable(coverageRunner, branchCoverage)) {
            infos.add((ColumnInfo)new PercentageCoverageColumnInfo(4, JavaCoverageBundle.message("coverage.view.column.branch", new Object[0]), this.mySuitesBundle));
            return true;
        }
        return false;
    }

    protected boolean isBranchInfoAvailable(CoverageRunner coverageRunner, boolean branchCoverage) {
        JavaCoverageRunner javaCoverageRunner;
        return coverageRunner instanceof JavaCoverageRunner && (javaCoverageRunner = (JavaCoverageRunner)coverageRunner).isBranchInfoAvailable(branchCoverage);
    }

    private boolean isInCoverageScope(PsiElement element) {
        if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            String qualifiedName = psiPackage.getQualifiedName();
            for (CoverageSuite suite : this.mySuitesBundle.getSuites()) {
                if (!((JavaCoverageSuite)suite).isPackageFiltered(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSelectInCoverageView(Object object) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
        if (psiFile instanceof PsiClassOwner) {
            String packageName2 = ((PsiClassOwner)psiFile).getPackageName();
            return this.isInCoverageScope((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName2));
        }
        if (object instanceof PsiPackage) {
            return this.isInCoverageScope((PsiElement)object);
        }
        return false;
    }

    public boolean supportFlattenPackages() {
        return true;
    }

    public String getElementsName() {
        return JavaCoverageBundle.message("coverage.classes", new Object[0]);
    }

    public String getElementsCapitalisedName() {
        return JavaCoverageBundle.message("coverage.classes.capitalised", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/JavaCoverageViewExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/JavaCoverageViewExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPercentage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

